/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.util.FastByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public interface DataCodec {
    public byte[] mapToBytes(DataMap var1) throws IOException;

    public byte[] listToBytes(DataList var1) throws IOException;

    default public ByteString mapToByteString(DataMap map) throws IOException {
        FastByteArrayOutputStream outputStream = new FastByteArrayOutputStream();
        this.writeMap(map, outputStream);
        return outputStream.toUnsafeByteString();
    }

    default public ByteString listToByteString(DataList list) throws IOException {
        FastByteArrayOutputStream outputStream = new FastByteArrayOutputStream();
        this.writeList(list, outputStream);
        return outputStream.toUnsafeByteString();
    }

    public DataMap bytesToMap(byte[] var1) throws IOException;

    public DataList bytesToList(byte[] var1) throws IOException;

    public void writeMap(DataMap var1, OutputStream var2) throws IOException;

    public DataMap readMap(InputStream var1) throws IOException;

    public void writeList(DataList var1, OutputStream var2) throws IOException;

    public DataList readList(InputStream var1) throws IOException;

    default public DataMap readMap(ByteString in) throws IOException {
        return this.readMap(in.asInputStream());
    }

    default public DataList readList(ByteString in) throws IOException {
        return this.readList(in.asInputStream());
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

