/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.urn;

import com.linkedin.common.urn.TupleKey;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DirectCoercer;
import com.linkedin.data.template.TemplateOutputCastException;
import java.net.URISyntaxException;

public final class GlossaryTermUrn
extends Urn {
    public static final String ENTITY_TYPE = "glossaryTerm";
    private final String _name;

    public GlossaryTermUrn(String name) {
        super(ENTITY_TYPE, TupleKey.create(name));
        this._name = name;
    }

    public String getNameEntity() {
        return this._name;
    }

    public static GlossaryTermUrn createFromString(String rawUrn) throws URISyntaxException {
        return GlossaryTermUrn.createFromUrn(Urn.createFromString(rawUrn));
    }

    public static GlossaryTermUrn createFromUrn(Urn urn) throws URISyntaxException {
        if (!"li".equals(urn.getNamespace())) {
            throw new URISyntaxException(urn.toString(), "Urn namespace type should be 'li'.");
        }
        if (!ENTITY_TYPE.equals(urn.getEntityType())) {
            throw new URISyntaxException(urn.toString(), "Urn entity type should be 'glossaryTerm'.");
        }
        TupleKey key = urn.getEntityKey();
        if (key.size() != 1) {
            throw new URISyntaxException(urn.toString(), "Invalid number of keys.");
        }
        try {
            return new GlossaryTermUrn(key.getAs(0, String.class));
        }
        catch (Exception var3) {
            throw new URISyntaxException(urn.toString(), "Invalid URN Parameter: '" + var3.getMessage());
        }
    }

    public static GlossaryTermUrn deserialize(String rawUrn) throws URISyntaxException {
        return GlossaryTermUrn.createFromString(rawUrn);
    }

    static {
        Custom.registerCoercer(new DirectCoercer<GlossaryTermUrn>(){

            @Override
            public Object coerceInput(GlossaryTermUrn object) throws ClassCastException {
                return object.toString();
            }

            @Override
            public GlossaryTermUrn coerceOutput(Object object) throws TemplateOutputCastException {
                try {
                    return GlossaryTermUrn.createFromString((String)object);
                }
                catch (URISyntaxException e) {
                    throw new TemplateOutputCastException("Invalid URN syntax: " + e.getMessage(), e);
                }
            }
        }, GlossaryTermUrn.class);
    }
}

