/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.callback;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.Function;
import com.linkedin.common.callback.MultiCallback;
import com.linkedin.common.callback.SimpleCallback;
import com.linkedin.common.callback.SuccessCallback;
import com.linkedin.common.util.None;

public class Callbacks {
    private static final NullCallback NULL_CALLBACK = new NullCallback();

    private Callbacks() {
    }

    public static <T> Callback<T> empty() {
        return NULL_CALLBACK;
    }

    public static <T> Callback<T> adaptSimple(SimpleCallback simpleCallback) {
        return new SimpleCallbackAdapter(simpleCallback);
    }

    public static <T> Callback<T> handle(final SuccessCallback<T> successCallback, final Callback<?> errorCallback) {
        return new Callback<T>(){

            @Override
            public void onError(Throwable e) {
                errorCallback.onError(e);
            }

            @Override
            public void onSuccess(T result) {
                successCallback.onSuccess(result);
            }
        };
    }

    public static Callback<None> countDown(Callback<None> callback, int count) {
        if (count == 0) {
            callback.onSuccess(None.none());
            return Callbacks.empty();
        }
        return new MultiCallback(callback, count);
    }

    public static <IN, OUT> Callback<IN> mapValue(final Callback<OUT> callback, final Function<IN, OUT> fun) {
        return new Callback<IN>(){

            @Override
            public void onError(Throwable error) {
                callback.onError(error);
            }

            @Override
            public void onSuccess(IN in) {
                Object out;
                try {
                    out = fun.map(in);
                }
                catch (Exception e) {
                    callback.onError(e);
                    return;
                }
                catch (Throwable t2) {
                    callback.onError(new Exception(t2));
                    return;
                }
                callback.onSuccess(out);
            }
        };
    }

    private static class SimpleCallbackAdapter<T>
    implements Callback<T> {
        private final SimpleCallback _callback;

        public SimpleCallbackAdapter(SimpleCallback simpleCallback) {
            this._callback = simpleCallback;
        }

        @Override
        public void onSuccess(T t2) {
            this._callback.onDone();
        }

        @Override
        public void onError(Throwable e) {
            this._callback.onDone();
        }
    }

    private static class NullCallback<T>
    implements Callback<T> {
        private NullCallback() {
        }

        @Override
        public void onSuccess(Object o) {
        }

        @Override
        public void onError(Throwable e) {
        }
    }
}

