/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.IconLibrary;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IconProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Properties describing an icon associated with an entity*/record IconProperties{/**The source of the icon: e.g. Antd, Material, etc*/iconLibrary:/**Enum of possible icon sources*/enum IconLibrary{/**Material UI*/MATERIAL}/**The name of the icon*/name:string/**Any modifier for the icon, this will be library-specific, e.g. filled/outlined, etc*/style:string}", SchemaFormatType.PDL);
    private IconLibrary _iconLibraryField = null;
    private String _nameField = null;
    private String _styleField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_IconLibrary = SCHEMA.getField("iconLibrary");
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_Style = SCHEMA.getField("style");

    public IconProperties() {
        super(new DataMap(4, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public IconProperties(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasIconLibrary() {
        if (this._iconLibraryField != null) {
            return true;
        }
        return this._map.containsKey("iconLibrary");
    }

    public void removeIconLibrary() {
        this._map.remove("iconLibrary");
    }

    @Nullable
    public IconLibrary getIconLibrary(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getIconLibrary();
            }
            case DEFAULT: 
            case NULL: {
                if (this._iconLibraryField != null) {
                    return this._iconLibraryField;
                }
                Object __rawValue = this._map.get("iconLibrary");
                this._iconLibraryField = DataTemplateUtil.coerceEnumOutput(__rawValue, IconLibrary.class, IconLibrary.$UNKNOWN);
                return this._iconLibraryField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public IconLibrary getIconLibrary() {
        if (this._iconLibraryField != null) {
            return this._iconLibraryField;
        }
        Object __rawValue = this._map.get("iconLibrary");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("iconLibrary");
        }
        this._iconLibraryField = DataTemplateUtil.coerceEnumOutput(__rawValue, IconLibrary.class, IconLibrary.$UNKNOWN);
        return this._iconLibraryField;
    }

    public IconProperties setIconLibrary(@Nullable IconLibrary value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIconLibrary(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field iconLibrary of com.linkedin.common.IconProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "iconLibrary", value.name());
                this._iconLibraryField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIconLibrary();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "iconLibrary", value.name());
                this._iconLibraryField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "iconLibrary", value.name());
                this._iconLibraryField = value;
            }
        }
        return this;
    }

    public IconProperties setIconLibrary(@Nonnull IconLibrary value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field iconLibrary of com.linkedin.common.IconProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "iconLibrary", value.name());
        this._iconLibraryField = value;
        return this;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nameField != null) {
                    return this._nameField;
                }
                Object __rawValue = this._map.get("name");
                this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("name");
        }
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public IconProperties setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field name of com.linkedin.common.IconProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public IconProperties setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.common.IconProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasStyle() {
        if (this._styleField != null) {
            return true;
        }
        return this._map.containsKey("style");
    }

    public void removeStyle() {
        this._map.remove("style");
    }

    @Nullable
    public String getStyle(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getStyle();
            }
            case DEFAULT: 
            case NULL: {
                if (this._styleField != null) {
                    return this._styleField;
                }
                Object __rawValue = this._map.get("style");
                this._styleField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._styleField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getStyle() {
        if (this._styleField != null) {
            return this._styleField;
        }
        Object __rawValue = this._map.get("style");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("style");
        }
        this._styleField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._styleField;
    }

    public IconProperties setStyle(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStyle(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field style of com.linkedin.common.IconProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "style", value);
                this._styleField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStyle();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "style", value);
                this._styleField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "style", value);
                this._styleField = value;
            }
        }
        return this;
    }

    public IconProperties setStyle(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field style of com.linkedin.common.IconProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "style", value);
        this._styleField = value;
        return this;
    }

    @Override
    public IconProperties clone() throws CloneNotSupportedException {
        IconProperties __clone = (IconProperties)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public IconProperties copy() throws CloneNotSupportedException {
        IconProperties __copy = (IconProperties)super.copy();
        __copy._iconLibraryField = null;
        __copy._nameField = null;
        __copy._styleField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final IconProperties __objectRef;

        private ChangeListener(IconProperties reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "iconLibrary": {
                    this.__objectRef._iconLibraryField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "style": {
                    this.__objectRef._styleField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec iconLibrary() {
            return new PathSpec(this.getPathComponents(), "iconLibrary");
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec style() {
            return new PathSpec(this.getPathComponents(), "style");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withIconLibrary() {
            this.getDataMap().put("iconLibrary", 1);
            return this;
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withStyle() {
            this.getDataMap().put("style", 1);
            return this;
        }
    }
}

