/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.chart;

import com.linkedin.common.urn.DatasetUrn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.HasTyperefInfo;
import com.linkedin.data.template.TyperefInfo;
import com.linkedin.data.template.UnionTemplate;
import java.util.List;

public class ChartDataSourceType
extends UnionTemplate
implements HasTyperefInfo {
    private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema("union[{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}]", SchemaFormatType.PDL);
    private DatasetUrn _datasetUrnMember = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final DataSchema MEMBER_DatasetUrn = SCHEMA.getTypeByMemberKey("string");
    public static final String MEMBERKEY_DatasetUrn = "string";
    private static final TyperefInfo TYPEREFINFO = new UnionTyperefInfo();

    public ChartDataSourceType() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public ChartDataSourceType(Object data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static UnionDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ChartDataSourceType create(DatasetUrn value) {
        ChartDataSourceType newUnion = new ChartDataSourceType();
        newUnion.setDatasetUrn(value);
        return newUnion;
    }

    public boolean isDatasetUrn() {
        return this.memberIs(MEMBERKEY_DatasetUrn);
    }

    public DatasetUrn getDatasetUrn() {
        this.checkNotNull();
        if (this._datasetUrnMember != null) {
            return this._datasetUrnMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_DatasetUrn);
        this._datasetUrnMember = DataTemplateUtil.coerceCustomOutput(__rawValue, DatasetUrn.class);
        return this._datasetUrnMember;
    }

    public void setDatasetUrn(DatasetUrn value) {
        this.checkNotNull();
        this._map.clear();
        this._datasetUrnMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_DatasetUrn, DataTemplateUtil.coerceCustomInput(value, DatasetUrn.class));
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public ChartDataSourceType clone() throws CloneNotSupportedException {
        ChartDataSourceType __clone = (ChartDataSourceType)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public ChartDataSourceType copy() throws CloneNotSupportedException {
        ChartDataSourceType __copy = (ChartDataSourceType)super.copy();
        __copy._datasetUrnMember = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    @Override
    public TyperefInfo typerefInfo() {
        return TYPEREFINFO;
    }

    static {
        Custom.initializeCustomClass(DatasetUrn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final ChartDataSourceType __objectRef;

        private ChangeListener(ChartDataSourceType reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "string": {
                    this.__objectRef._datasetUrnMember = null;
                }
            }
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withDatasetUrn() {
            this.getDataMap().put(ChartDataSourceType.MEMBERKEY_DatasetUrn, 1);
            return this;
        }
    }

    private static final class UnionTyperefInfo
    extends TyperefInfo {
        private static final TyperefDataSchema SCHEMA = (TyperefDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.chart/**Input source type for a chart such as dataset or metric*/typeref ChartDataSourceType=union[{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}]", SchemaFormatType.PDL);

        public UnionTyperefInfo() {
            super(SCHEMA);
        }

        public static TyperefDataSchema dataSchema() {
            return SCHEMA;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec DatasetUrn() {
            return new PathSpec(this.getPathComponents(), ChartDataSourceType.MEMBERKEY_DatasetUrn);
        }
    }
}

