/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.businessattribute;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.GlobalTags;
import com.linkedin.common.GlossaryTerms;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import com.linkedin.schema.SchemaFieldDataType;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BusinessAttributeInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.businessattribute/**Properties associated with a BusinessAttribute*/@Aspect.name=\"businessAttributeInfo\"record BusinessAttributeInfo includes{namespace com.linkedin.schema/**SchemaField to describe metadata related to dataset schema.*/record EditableSchemaFieldInfo{/**FieldPath uniquely identifying the SchemaField this metadata is associated with*/fieldPath:string/**Description*/@Searchable={\"boostScore\":0.1,\"fieldName\":\"editedFieldDescriptions\",\"fieldType\":\"TEXT\"}description:optional string/**Tags associated with the field*/@Relationship.`/tags/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"EditableSchemaFieldTaggedWith\"}@Searchable={\"/tags/*/attribution/actor\":{\"fieldName\":\"editedFieldTagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/tags/*/attribution/source\":{\"fieldName\":\"editedFieldTagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/tags/*/attribution/time\":{\"fieldName\":\"editedFieldTagAttributionDates\",\"fieldType\":\"DATETIME\"},\"/tags/*/tag\":{\"boostScore\":0.5,\"fieldName\":\"editedFieldTags\",\"fieldType\":\"URN\"}}globalTags:optional{namespace com.linkedin.common/**Tag aspect used for applying tags to an entity*/@Aspect.name=\"globalTags\"record GlobalTags{/**Tags associated with a given entity*/@Relationship.`/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"TaggedWith\"}@Searchable.`/*/tag`={\"addToFilters\":true,\"boostScore\":0.5,\"fieldName\":\"tags\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Tag\",\"hasValuesFieldName\":\"hasTags\",\"queryByDefault\":true}tags:array[/**Properties of an applied tag. For now, just an Urn. In the future we can extend this with other properties, e.g.\npropagation parameters.*/record TagAssociation{/**Urn of the applied tag*/tag:/**Globally defined tag*/@java.class=\"com.linkedin.common.urn.TagUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Globally defined tags\",\"entityType\":\"tag\",\"fields\":[{\"doc\":\"tag name\",\"maxLength\":200,\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":220,\"name\":\"Tag\",\"namespace\":\"li\",\"owners\":[],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref TagUrn=string/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"tagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"tagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"tagAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}]}}/**Glossary terms associated with the field*/@Relationship.`/terms/*/urn`={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"EditableSchemaFieldWithGlossaryTerm\"}@Searchable={\"/terms/*/attribution/actor\":{\"fieldName\":\"editedFieldTermAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/terms/*/attribution/source\":{\"fieldName\":\"editedFieldTermAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/terms/*/attribution/time\":{\"fieldName\":\"editedFieldTermAttributionDates\",\"fieldType\":\"DATETIME\"},\"/terms/*/urn\":{\"boostScore\":0.5,\"fieldName\":\"editedFieldGlossaryTerms\",\"fieldType\":\"URN\",\"includeSystemModifiedAt\":true,\"systemModifiedAtFieldName\":\"schemaFieldTermsModifiedAt\"}}glossaryTerms:optional{namespace com.linkedin.common/**Related business terms information*/@Aspect.name=\"glossaryTerms\"record GlossaryTerms{/**The related business terms*/terms:array[/**Properties of an applied glossary term.*/record GlossaryTermAssociation{/**Urn of the applied glossary term*/@Relationship={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"TermedWith\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"glossaryTerms\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Glossary Term\",\"hasValuesFieldName\":\"hasGlossaryTerms\",\"includeSystemModifiedAt\":true,\"systemModifiedAtFieldName\":\"termsModifiedAt\"}urn:/**Business Term*/@java.class=\"com.linkedin.common.urn.GlossaryTermUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"business term\",\"entityType\":\"glossaryTerm\",\"fields\":[{\"doc\":\"The name of business term with hierarchy.\",\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":56,\"name\":\"GlossaryTerm\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref GlossaryTermUrn=string/**The user URN which will be credited for adding associating this term to the entity*/actor:optional Urn/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"termAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"termAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"termAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional MetadataAttribution}]/**Audit stamp containing who reported the related business term*/auditStamp:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:Time/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}}}{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into various lifecycle stages, and who acted to move it into those lifecycle stages. The recommended best practice is to include this record in your record schema, and annotate its fields as @readOnly in your resource. See https://github.com/linkedin/rest.li/wiki/Validation-in-Rest.li#restli-validation-annotations*/record ChangeAuditStamps{/**An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data.*/created:AuditStamp={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data.*/lastModified:AuditStamp={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics.*/deleted:optional AuditStamp}}{/**Display name of the BusinessAttribute*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}name:string,type:optional{namespace com.linkedin.schema/**Schema field data types*/record SchemaFieldDataType{/**Data platform specific types*/type:union[/**Boolean field type.*/record BooleanType{}/**Fixed field type.*/record FixedType{}/**String field type.*/record StringType{}/**Bytes field type.*/record BytesType{}/**Number data type: long, integer, short, etc..*/record NumberType{}/**Date field type.*/record DateType{}/**Time field type. This should also be used for datetimes.*/record TimeType{}/**Enum field type.*/record EnumType{}/**Null field type.*/record NullType{}/**Map field type.*/record MapType{/**Key type in a map*/keyType:optional string/**Type of the value in a map*/valueType:optional string}/**Array field type.*/record ArrayType{/**List of types this array holds.*/nestedType:optional array[string]}/**Union field type.*/record UnionType{/**List of types in union type.*/nestedTypes:optional array[string]}/**Record field type.*/record RecordType{}]}}}", SchemaFormatType.PDL);
    private String _fieldPathField = null;
    private String _descriptionField = null;
    private GlobalTags _globalTagsField = null;
    private GlossaryTerms _glossaryTermsField = null;
    private StringMap _customPropertiesField = null;
    private AuditStamp _createdField = null;
    private AuditStamp _lastModifiedField = null;
    private AuditStamp _deletedField = null;
    private String _nameField = null;
    private SchemaFieldDataType _typeField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_FieldPath = SCHEMA.getField("fieldPath");
    private static final RecordDataSchema.Field FIELD_Description = SCHEMA.getField("description");
    private static final RecordDataSchema.Field FIELD_GlobalTags = SCHEMA.getField("globalTags");
    private static final RecordDataSchema.Field FIELD_GlossaryTerms = SCHEMA.getField("glossaryTerms");
    private static final RecordDataSchema.Field FIELD_CustomProperties = SCHEMA.getField("customProperties");
    private static final StringMap DEFAULT_CustomProperties;
    private static final RecordDataSchema.Field FIELD_Created;
    private static final AuditStamp DEFAULT_Created;
    private static final RecordDataSchema.Field FIELD_LastModified;
    private static final AuditStamp DEFAULT_LastModified;
    private static final RecordDataSchema.Field FIELD_Deleted;
    private static final RecordDataSchema.Field FIELD_Name;
    private static final RecordDataSchema.Field FIELD_Type;

    public BusinessAttributeInfo() {
        super(new DataMap(14, 0.75f), SCHEMA, 10);
        this.addChangeListener(this.__changeListener);
    }

    public BusinessAttributeInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasFieldPath() {
        if (this._fieldPathField != null) {
            return true;
        }
        return this._map.containsKey("fieldPath");
    }

    public void removeFieldPath() {
        this._map.remove("fieldPath");
    }

    @Nullable
    public String getFieldPath(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getFieldPath();
            }
            case DEFAULT: 
            case NULL: {
                if (this._fieldPathField != null) {
                    return this._fieldPathField;
                }
                Object __rawValue = this._map.get("fieldPath");
                this._fieldPathField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._fieldPathField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getFieldPath() {
        if (this._fieldPathField != null) {
            return this._fieldPathField;
        }
        Object __rawValue = this._map.get("fieldPath");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("fieldPath");
        }
        this._fieldPathField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._fieldPathField;
    }

    public BusinessAttributeInfo setFieldPath(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFieldPath(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field fieldPath of com.linkedin.businessattribute.BusinessAttributeInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
                this._fieldPathField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFieldPath();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
                this._fieldPathField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
                this._fieldPathField = value;
            }
        }
        return this;
    }

    public BusinessAttributeInfo setFieldPath(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fieldPath of com.linkedin.businessattribute.BusinessAttributeInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
        this._fieldPathField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public BusinessAttributeInfo setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public BusinessAttributeInfo setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.businessattribute.BusinessAttributeInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasGlobalTags() {
        if (this._globalTagsField != null) {
            return true;
        }
        return this._map.containsKey("globalTags");
    }

    public void removeGlobalTags() {
        this._map.remove("globalTags");
    }

    @Nullable
    public GlobalTags getGlobalTags(GetMode mode) {
        return this.getGlobalTags();
    }

    @Nullable
    public GlobalTags getGlobalTags() {
        if (this._globalTagsField != null) {
            return this._globalTagsField;
        }
        Object __rawValue = this._map.get("globalTags");
        this._globalTagsField = __rawValue == null ? null : new GlobalTags(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._globalTagsField;
    }

    public BusinessAttributeInfo setGlobalTags(@Nullable GlobalTags value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGlobalTags(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGlobalTags();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "globalTags", value.data());
                this._globalTagsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "globalTags", value.data());
                this._globalTagsField = value;
            }
        }
        return this;
    }

    public BusinessAttributeInfo setGlobalTags(@Nonnull GlobalTags value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field globalTags of com.linkedin.businessattribute.BusinessAttributeInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "globalTags", value.data());
        this._globalTagsField = value;
        return this;
    }

    public boolean hasGlossaryTerms() {
        if (this._glossaryTermsField != null) {
            return true;
        }
        return this._map.containsKey("glossaryTerms");
    }

    public void removeGlossaryTerms() {
        this._map.remove("glossaryTerms");
    }

    @Nullable
    public GlossaryTerms getGlossaryTerms(GetMode mode) {
        return this.getGlossaryTerms();
    }

    @Nullable
    public GlossaryTerms getGlossaryTerms() {
        if (this._glossaryTermsField != null) {
            return this._glossaryTermsField;
        }
        Object __rawValue = this._map.get("glossaryTerms");
        this._glossaryTermsField = __rawValue == null ? null : new GlossaryTerms(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._glossaryTermsField;
    }

    public BusinessAttributeInfo setGlossaryTerms(@Nullable GlossaryTerms value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGlossaryTerms(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGlossaryTerms();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "glossaryTerms", value.data());
                this._glossaryTermsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "glossaryTerms", value.data());
                this._glossaryTermsField = value;
            }
        }
        return this;
    }

    public BusinessAttributeInfo setGlossaryTerms(@Nonnull GlossaryTerms value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field glossaryTerms of com.linkedin.businessattribute.BusinessAttributeInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "glossaryTerms", value.data());
        this._glossaryTermsField = value;
        return this;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCustomProperties();
            }
            case NULL: {
                if (this._customPropertiesField != null) {
                    return this._customPropertiesField;
                }
                Object __rawValue = this._map.get("customProperties");
                this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._customPropertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        if (__rawValue == null) {
            return DEFAULT_CustomProperties;
        }
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public BusinessAttributeInfo setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field customProperties of com.linkedin.businessattribute.BusinessAttributeInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public BusinessAttributeInfo setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.businessattribute.BusinessAttributeInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCreated();
            }
            case NULL: {
                if (this._createdField != null) {
                    return this._createdField;
                }
                Object __rawValue = this._map.get("created");
                this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._createdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        if (__rawValue == null) {
            return DEFAULT_Created;
        }
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public BusinessAttributeInfo setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field created of com.linkedin.businessattribute.BusinessAttributeInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public BusinessAttributeInfo setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.businessattribute.BusinessAttributeInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public AuditStamp getLastModified(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getLastModified();
            }
            case NULL: {
                if (this._lastModifiedField != null) {
                    return this._lastModifiedField;
                }
                Object __rawValue = this._map.get("lastModified");
                this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._lastModifiedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        if (__rawValue == null) {
            return DEFAULT_LastModified;
        }
        this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public BusinessAttributeInfo setLastModified(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field lastModified of com.linkedin.businessattribute.BusinessAttributeInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public BusinessAttributeInfo setLastModified(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.businessattribute.BusinessAttributeInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    public boolean hasDeleted() {
        if (this._deletedField != null) {
            return true;
        }
        return this._map.containsKey("deleted");
    }

    public void removeDeleted() {
        this._map.remove("deleted");
    }

    @Nullable
    public AuditStamp getDeleted(GetMode mode) {
        return this.getDeleted();
    }

    @Nullable
    public AuditStamp getDeleted() {
        if (this._deletedField != null) {
            return this._deletedField;
        }
        Object __rawValue = this._map.get("deleted");
        this._deletedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._deletedField;
    }

    public BusinessAttributeInfo setDeleted(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDeleted(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDeleted();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "deleted", value.data());
                this._deletedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "deleted", value.data());
                this._deletedField = value;
            }
        }
        return this;
    }

    public BusinessAttributeInfo setDeleted(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field deleted of com.linkedin.businessattribute.BusinessAttributeInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "deleted", value.data());
        this._deletedField = value;
        return this;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nameField != null) {
                    return this._nameField;
                }
                Object __rawValue = this._map.get("name");
                this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("name");
        }
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public BusinessAttributeInfo setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field name of com.linkedin.businessattribute.BusinessAttributeInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public BusinessAttributeInfo setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.businessattribute.BusinessAttributeInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public SchemaFieldDataType getType(GetMode mode) {
        return this.getType();
    }

    @Nullable
    public SchemaFieldDataType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        this._typeField = __rawValue == null ? null : new SchemaFieldDataType(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._typeField;
    }

    public BusinessAttributeInfo setType(@Nullable SchemaFieldDataType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.data());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.data());
                this._typeField = value;
            }
        }
        return this;
    }

    public BusinessAttributeInfo setType(@Nonnull SchemaFieldDataType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.businessattribute.BusinessAttributeInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.data());
        this._typeField = value;
        return this;
    }

    @Override
    public BusinessAttributeInfo clone() throws CloneNotSupportedException {
        BusinessAttributeInfo __clone = (BusinessAttributeInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public BusinessAttributeInfo copy() throws CloneNotSupportedException {
        BusinessAttributeInfo __copy = (BusinessAttributeInfo)super.copy();
        __copy._customPropertiesField = null;
        __copy._deletedField = null;
        __copy._createdField = null;
        __copy._fieldPathField = null;
        __copy._nameField = null;
        __copy._descriptionField = null;
        __copy._glossaryTermsField = null;
        __copy._lastModifiedField = null;
        __copy._globalTagsField = null;
        __copy._typeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Created = SCHEMA.getField("created");
        FIELD_LastModified = SCHEMA.getField("lastModified");
        FIELD_Deleted = SCHEMA.getField("deleted");
        FIELD_Name = SCHEMA.getField("name");
        FIELD_Type = SCHEMA.getField("type");
        DEFAULT_CustomProperties = FIELD_CustomProperties.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_CustomProperties.getDefault(), DataMap.class));
        DEFAULT_Created = FIELD_Created.getDefault() == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(FIELD_Created.getDefault(), DataMap.class));
        DEFAULT_LastModified = FIELD_LastModified.getDefault() == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(FIELD_LastModified.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final BusinessAttributeInfo __objectRef;

        private ChangeListener(BusinessAttributeInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "deleted": {
                    this.__objectRef._deletedField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "fieldPath": {
                    this.__objectRef._fieldPathField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "glossaryTerms": {
                    this.__objectRef._glossaryTermsField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                    break;
                }
                case "globalTags": {
                    this.__objectRef._globalTagsField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec fieldPath() {
            return new PathSpec(this.getPathComponents(), "fieldPath");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public GlobalTags.Fields globalTags() {
            return new GlobalTags.Fields(this.getPathComponents(), "globalTags");
        }

        public GlossaryTerms.Fields glossaryTerms() {
            return new GlossaryTerms.Fields(this.getPathComponents(), "glossaryTerms");
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }

        public AuditStamp.Fields lastModified() {
            return new AuditStamp.Fields(this.getPathComponents(), "lastModified");
        }

        public AuditStamp.Fields deleted() {
            return new AuditStamp.Fields(this.getPathComponents(), "deleted");
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public SchemaFieldDataType.Fields type() {
            return new SchemaFieldDataType.Fields(this.getPathComponents(), "type");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private GlobalTags.ProjectionMask _globalTagsMask;
        private GlossaryTerms.ProjectionMask _glossaryTermsMask;
        private AuditStamp.ProjectionMask _createdMask;
        private AuditStamp.ProjectionMask _lastModifiedMask;
        private AuditStamp.ProjectionMask _deletedMask;
        private SchemaFieldDataType.ProjectionMask _typeMask;

        ProjectionMask() {
            super(14);
        }

        public ProjectionMask withFieldPath() {
            this.getDataMap().put("fieldPath", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withGlobalTags(Function<GlobalTags.ProjectionMask, GlobalTags.ProjectionMask> nestedMask) {
            this._globalTagsMask = nestedMask.apply(this._globalTagsMask == null ? GlobalTags.createMask() : this._globalTagsMask);
            this.getDataMap().put("globalTags", this._globalTagsMask.getDataMap());
            return this;
        }

        public ProjectionMask withGlobalTags() {
            this._globalTagsMask = null;
            this.getDataMap().put("globalTags", 1);
            return this;
        }

        public ProjectionMask withGlossaryTerms(Function<GlossaryTerms.ProjectionMask, GlossaryTerms.ProjectionMask> nestedMask) {
            this._glossaryTermsMask = nestedMask.apply(this._glossaryTermsMask == null ? GlossaryTerms.createMask() : this._glossaryTermsMask);
            this.getDataMap().put("glossaryTerms", this._glossaryTermsMask.getDataMap());
            return this;
        }

        public ProjectionMask withGlossaryTerms() {
            this._glossaryTermsMask = null;
            this.getDataMap().put("glossaryTerms", 1);
            return this;
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? AuditStamp.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }

        public ProjectionMask withDeleted(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._deletedMask = nestedMask.apply(this._deletedMask == null ? AuditStamp.createMask() : this._deletedMask);
            this.getDataMap().put("deleted", this._deletedMask.getDataMap());
            return this;
        }

        public ProjectionMask withDeleted(MaskMap nestedMask) {
            this.getDataMap().put("deleted", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withDeleted() {
            this._deletedMask = null;
            this.getDataMap().put("deleted", 1);
            return this;
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withType(Function<SchemaFieldDataType.ProjectionMask, SchemaFieldDataType.ProjectionMask> nestedMask) {
            this._typeMask = nestedMask.apply(this._typeMask == null ? SchemaFieldDataType.createMask() : this._typeMask);
            this.getDataMap().put("type", this._typeMask.getDataMap());
            return this;
        }

        public ProjectionMask withType() {
            this._typeMask = null;
            this.getDataMap().put("type", 1);
            return this;
        }
    }
}

