/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FreshnessCronSchedule
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**Attributes defining a CRON-formatted schedule used for defining a freshness assertion.*/record FreshnessCronSchedule{/**A cron-formatted execution interval, as a cron string, e.g. 1 * * * **/cron:string/**Timezone in which the cron interval applies, e.g. America/Los Angeles*/timezone:string/**An optional offset in milliseconds to SUBTRACT from the timestamp generated by the cron schedule\nto generate the lower bounds of the \"freshness window\", or the window of time in which an event must have occurred in order for the Freshness check\nto be considering passing.\n\nIf left empty, the start of the SLA window will be the _end_ of the previously evaluated Freshness window.*/windowStartOffsetMs:optional long}", SchemaFormatType.PDL);
    private String _cronField = null;
    private String _timezoneField = null;
    private Long _windowStartOffsetMsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Cron = SCHEMA.getField("cron");
    private static final RecordDataSchema.Field FIELD_Timezone = SCHEMA.getField("timezone");
    private static final RecordDataSchema.Field FIELD_WindowStartOffsetMs = SCHEMA.getField("windowStartOffsetMs");

    public FreshnessCronSchedule() {
        super(new DataMap(4, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public FreshnessCronSchedule(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCron() {
        if (this._cronField != null) {
            return true;
        }
        return this._map.containsKey("cron");
    }

    public void removeCron() {
        this._map.remove("cron");
    }

    @Nullable
    public String getCron(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCron();
            }
            case DEFAULT: 
            case NULL: {
                if (this._cronField != null) {
                    return this._cronField;
                }
                Object __rawValue = this._map.get("cron");
                this._cronField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._cronField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getCron() {
        if (this._cronField != null) {
            return this._cronField;
        }
        Object __rawValue = this._map.get("cron");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("cron");
        }
        this._cronField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._cronField;
    }

    public FreshnessCronSchedule setCron(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCron(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field cron of com.linkedin.assertion.FreshnessCronSchedule");
                }
                CheckedUtil.putWithoutChecking(this._map, "cron", value);
                this._cronField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCron();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "cron", value);
                this._cronField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "cron", value);
                this._cronField = value;
            }
        }
        return this;
    }

    public FreshnessCronSchedule setCron(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field cron of com.linkedin.assertion.FreshnessCronSchedule to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "cron", value);
        this._cronField = value;
        return this;
    }

    public boolean hasTimezone() {
        if (this._timezoneField != null) {
            return true;
        }
        return this._map.containsKey("timezone");
    }

    public void removeTimezone() {
        this._map.remove("timezone");
    }

    @Nullable
    public String getTimezone(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTimezone();
            }
            case DEFAULT: 
            case NULL: {
                if (this._timezoneField != null) {
                    return this._timezoneField;
                }
                Object __rawValue = this._map.get("timezone");
                this._timezoneField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._timezoneField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getTimezone() {
        if (this._timezoneField != null) {
            return this._timezoneField;
        }
        Object __rawValue = this._map.get("timezone");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("timezone");
        }
        this._timezoneField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._timezoneField;
    }

    public FreshnessCronSchedule setTimezone(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTimezone(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field timezone of com.linkedin.assertion.FreshnessCronSchedule");
                }
                CheckedUtil.putWithoutChecking(this._map, "timezone", value);
                this._timezoneField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTimezone();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "timezone", value);
                this._timezoneField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "timezone", value);
                this._timezoneField = value;
            }
        }
        return this;
    }

    public FreshnessCronSchedule setTimezone(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field timezone of com.linkedin.assertion.FreshnessCronSchedule to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "timezone", value);
        this._timezoneField = value;
        return this;
    }

    public boolean hasWindowStartOffsetMs() {
        if (this._windowStartOffsetMsField != null) {
            return true;
        }
        return this._map.containsKey("windowStartOffsetMs");
    }

    public void removeWindowStartOffsetMs() {
        this._map.remove("windowStartOffsetMs");
    }

    @Nullable
    public Long getWindowStartOffsetMs(GetMode mode) {
        return this.getWindowStartOffsetMs();
    }

    @Nullable
    public Long getWindowStartOffsetMs() {
        if (this._windowStartOffsetMsField != null) {
            return this._windowStartOffsetMsField;
        }
        Object __rawValue = this._map.get("windowStartOffsetMs");
        this._windowStartOffsetMsField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._windowStartOffsetMsField;
    }

    public FreshnessCronSchedule setWindowStartOffsetMs(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setWindowStartOffsetMs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeWindowStartOffsetMs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "windowStartOffsetMs", DataTemplateUtil.coerceLongInput(value));
                this._windowStartOffsetMsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "windowStartOffsetMs", DataTemplateUtil.coerceLongInput(value));
                this._windowStartOffsetMsField = value;
            }
        }
        return this;
    }

    public FreshnessCronSchedule setWindowStartOffsetMs(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field windowStartOffsetMs of com.linkedin.assertion.FreshnessCronSchedule to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "windowStartOffsetMs", DataTemplateUtil.coerceLongInput(value));
        this._windowStartOffsetMsField = value;
        return this;
    }

    public FreshnessCronSchedule setWindowStartOffsetMs(long value) {
        CheckedUtil.putWithoutChecking(this._map, "windowStartOffsetMs", DataTemplateUtil.coerceLongInput(value));
        this._windowStartOffsetMsField = value;
        return this;
    }

    @Override
    public FreshnessCronSchedule clone() throws CloneNotSupportedException {
        FreshnessCronSchedule __clone = (FreshnessCronSchedule)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public FreshnessCronSchedule copy() throws CloneNotSupportedException {
        FreshnessCronSchedule __copy = (FreshnessCronSchedule)super.copy();
        __copy._cronField = null;
        __copy._timezoneField = null;
        __copy._windowStartOffsetMsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final FreshnessCronSchedule __objectRef;

        private ChangeListener(FreshnessCronSchedule reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "cron": {
                    this.__objectRef._cronField = null;
                    break;
                }
                case "timezone": {
                    this.__objectRef._timezoneField = null;
                    break;
                }
                case "windowStartOffsetMs": {
                    this.__objectRef._windowStartOffsetMsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec cron() {
            return new PathSpec(this.getPathComponents(), "cron");
        }

        public PathSpec timezone() {
            return new PathSpec(this.getPathComponents(), "timezone");
        }

        public PathSpec windowStartOffsetMs() {
            return new PathSpec(this.getPathComponents(), "windowStartOffsetMs");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withCron() {
            this.getDataMap().put("cron", 1);
            return this;
        }

        public ProjectionMask withTimezone() {
            this.getDataMap().put("timezone", 1);
            return this;
        }

        public ProjectionMask withWindowStartOffsetMs() {
            this.getDataMap().put("windowStartOffsetMs", 1);
            return this;
        }
    }
}

