/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.assertion.AssertionStdParameter;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssertionStdParameters
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**Parameters for AssertionStdOperators.*/record AssertionStdParameters{/**The value parameter of an assertion*/value:optional/**Single parameter for AssertionStdOperators.*/record AssertionStdParameter{/**The parameter value*/value:string/**The type of the parameter*/type:enum AssertionStdParameterType{/**A string value*/STRING/**A numeric value*/NUMBER/**A list of values. When used, value should be formatted as a serialized JSON array.*/LIST/**A set of values. When used, value should be formatted as a serialized JSON array.*/SET/**A value of unknown type*/UNKNOWN}}/**The maxValue parameter of an assertion*/maxValue:optional AssertionStdParameter/**The minValue parameter of an assertion*/minValue:optional AssertionStdParameter}", SchemaFormatType.PDL);
    private AssertionStdParameter _valueField = null;
    private AssertionStdParameter _maxValueField = null;
    private AssertionStdParameter _minValueField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Value = SCHEMA.getField("value");
    private static final RecordDataSchema.Field FIELD_MaxValue = SCHEMA.getField("maxValue");
    private static final RecordDataSchema.Field FIELD_MinValue = SCHEMA.getField("minValue");

    public AssertionStdParameters() {
        super(new DataMap(4, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public AssertionStdParameters(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasValue() {
        if (this._valueField != null) {
            return true;
        }
        return this._map.containsKey("value");
    }

    public void removeValue() {
        this._map.remove("value");
    }

    @Nullable
    public AssertionStdParameter getValue(GetMode mode) {
        return this.getValue();
    }

    @Nullable
    public AssertionStdParameter getValue() {
        if (this._valueField != null) {
            return this._valueField;
        }
        Object __rawValue = this._map.get("value");
        this._valueField = __rawValue == null ? null : new AssertionStdParameter(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._valueField;
    }

    public AssertionStdParameters setValue(@Nullable AssertionStdParameter value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setValue(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeValue();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "value", value.data());
                this._valueField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "value", value.data());
                this._valueField = value;
            }
        }
        return this;
    }

    public AssertionStdParameters setValue(@Nonnull AssertionStdParameter value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field value of com.linkedin.assertion.AssertionStdParameters to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "value", value.data());
        this._valueField = value;
        return this;
    }

    public boolean hasMaxValue() {
        if (this._maxValueField != null) {
            return true;
        }
        return this._map.containsKey("maxValue");
    }

    public void removeMaxValue() {
        this._map.remove("maxValue");
    }

    @Nullable
    public AssertionStdParameter getMaxValue(GetMode mode) {
        return this.getMaxValue();
    }

    @Nullable
    public AssertionStdParameter getMaxValue() {
        if (this._maxValueField != null) {
            return this._maxValueField;
        }
        Object __rawValue = this._map.get("maxValue");
        this._maxValueField = __rawValue == null ? null : new AssertionStdParameter(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._maxValueField;
    }

    public AssertionStdParameters setMaxValue(@Nullable AssertionStdParameter value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMaxValue(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMaxValue();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "maxValue", value.data());
                this._maxValueField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "maxValue", value.data());
                this._maxValueField = value;
            }
        }
        return this;
    }

    public AssertionStdParameters setMaxValue(@Nonnull AssertionStdParameter value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field maxValue of com.linkedin.assertion.AssertionStdParameters to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "maxValue", value.data());
        this._maxValueField = value;
        return this;
    }

    public boolean hasMinValue() {
        if (this._minValueField != null) {
            return true;
        }
        return this._map.containsKey("minValue");
    }

    public void removeMinValue() {
        this._map.remove("minValue");
    }

    @Nullable
    public AssertionStdParameter getMinValue(GetMode mode) {
        return this.getMinValue();
    }

    @Nullable
    public AssertionStdParameter getMinValue() {
        if (this._minValueField != null) {
            return this._minValueField;
        }
        Object __rawValue = this._map.get("minValue");
        this._minValueField = __rawValue == null ? null : new AssertionStdParameter(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._minValueField;
    }

    public AssertionStdParameters setMinValue(@Nullable AssertionStdParameter value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMinValue(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMinValue();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "minValue", value.data());
                this._minValueField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "minValue", value.data());
                this._minValueField = value;
            }
        }
        return this;
    }

    public AssertionStdParameters setMinValue(@Nonnull AssertionStdParameter value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field minValue of com.linkedin.assertion.AssertionStdParameters to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "minValue", value.data());
        this._minValueField = value;
        return this;
    }

    @Override
    public AssertionStdParameters clone() throws CloneNotSupportedException {
        AssertionStdParameters __clone = (AssertionStdParameters)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public AssertionStdParameters copy() throws CloneNotSupportedException {
        AssertionStdParameters __copy = (AssertionStdParameters)super.copy();
        __copy._minValueField = null;
        __copy._maxValueField = null;
        __copy._valueField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final AssertionStdParameters __objectRef;

        private ChangeListener(AssertionStdParameters reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "minValue": {
                    this.__objectRef._minValueField = null;
                    break;
                }
                case "maxValue": {
                    this.__objectRef._maxValueField = null;
                    break;
                }
                case "value": {
                    this.__objectRef._valueField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public AssertionStdParameter.Fields value() {
            return new AssertionStdParameter.Fields(this.getPathComponents(), "value");
        }

        public AssertionStdParameter.Fields maxValue() {
            return new AssertionStdParameter.Fields(this.getPathComponents(), "maxValue");
        }

        public AssertionStdParameter.Fields minValue() {
            return new AssertionStdParameter.Fields(this.getPathComponents(), "minValue");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AssertionStdParameter.ProjectionMask _valueMask;
        private AssertionStdParameter.ProjectionMask _maxValueMask;
        private AssertionStdParameter.ProjectionMask _minValueMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withValue(Function<AssertionStdParameter.ProjectionMask, AssertionStdParameter.ProjectionMask> nestedMask) {
            this._valueMask = nestedMask.apply(this._valueMask == null ? AssertionStdParameter.createMask() : this._valueMask);
            this.getDataMap().put("value", this._valueMask.getDataMap());
            return this;
        }

        public ProjectionMask withValue() {
            this._valueMask = null;
            this.getDataMap().put("value", 1);
            return this;
        }

        public ProjectionMask withMaxValue(Function<AssertionStdParameter.ProjectionMask, AssertionStdParameter.ProjectionMask> nestedMask) {
            this._maxValueMask = nestedMask.apply(this._maxValueMask == null ? AssertionStdParameter.createMask() : this._maxValueMask);
            this.getDataMap().put("maxValue", this._maxValueMask.getDataMap());
            return this;
        }

        public ProjectionMask withMaxValue() {
            this._maxValueMask = null;
            this.getDataMap().put("maxValue", 1);
            return this;
        }

        public ProjectionMask withMinValue(Function<AssertionStdParameter.ProjectionMask, AssertionStdParameter.ProjectionMask> nestedMask) {
            this._minValueMask = nestedMask.apply(this._minValueMask == null ? AssertionStdParameter.createMask() : this._minValueMask);
            this.getDataMap().put("minValue", this._minValueMask.getDataMap());
            return this;
        }

        public ProjectionMask withMinValue() {
            this._minValueMask = null;
            this.getDataMap().put("minValue", 1);
            return this;
        }
    }
}

