/*
 * Decompiled with CFR 0.152.
 */
package com.datahub.util.validator;

import com.datahub.util.validator.ValidationUtils;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.RecordTemplate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public final class DocumentValidator {
    private static final Set<String> NON_OPTIONAL_FIELDS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("urn");
        }
    });
    private static final Set<Class<? extends RecordTemplate>> VALIDATED = ConcurrentHashMap.newKeySet();

    private DocumentValidator() {
    }

    public static void validateDocumentSchema(@Nonnull RecordDataSchema schema) {
        String className = schema.getBindingName();
        if (!ValidationUtils.schemaHasExactlyOneSuchField(schema, ValidationUtils::isValidUrnField)) {
            ValidationUtils.invalidSchema("Document '%s' must contain an non-optional 'urn' field of URN type", className);
        }
        ValidationUtils.fieldsUsingInvalidType(schema, ValidationUtils.PRIMITIVE_TYPES).forEach(field -> ValidationUtils.invalidSchema("Document '%s' contains a field '%s' that makes use of a disallowed type '%s'.", new Object[]{className, field.getName(), field.getType().getType()}));
        ValidationUtils.nonOptionalFields(schema, NON_OPTIONAL_FIELDS).forEach(field -> ValidationUtils.invalidSchema("Document '%s' must contain an optional '%s' field", className, field.getName()));
    }

    public static void validateDocumentSchema(@Nonnull Class<? extends RecordTemplate> clazz) {
        if (VALIDATED.contains(clazz)) {
            return;
        }
        DocumentValidator.validateDocumentSchema(ValidationUtils.getRecordSchema(clazz));
        VALIDATED.add(clazz);
    }
}

