/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.usage;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.usage.FieldUsageCountsArray;
import com.linkedin.usage.UserUsageCountsArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UsageQueryResultAggregations
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.usage,record UsageQueryResultAggregations{uniqueUserCount:optional int,totalSqlQueries:optional int,users:optional array[/** Records a single user's usage counts for a given resource */record UserUsageCounts{user:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}count:int/** If user_email is set, we attempt to resolve the user's urn upon ingest */userEmail:optional string}]fields:optional array[/** Records field-level usage counts for a given resource */record FieldUsageCounts{fieldName:string,count:int}]}", SchemaFormatType.PDL);
    private Integer _uniqueUserCountField = null;
    private Integer _totalSqlQueriesField = null;
    private UserUsageCountsArray _usersField = null;
    private FieldUsageCountsArray _fieldsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_UniqueUserCount = SCHEMA.getField("uniqueUserCount");
    private static final RecordDataSchema.Field FIELD_TotalSqlQueries = SCHEMA.getField("totalSqlQueries");
    private static final RecordDataSchema.Field FIELD_Users = SCHEMA.getField("users");
    private static final RecordDataSchema.Field FIELD_Fields = SCHEMA.getField("fields");

    public UsageQueryResultAggregations() {
        super(new DataMap(6, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public UsageQueryResultAggregations(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUniqueUserCount() {
        if (this._uniqueUserCountField != null) {
            return true;
        }
        return this._map.containsKey("uniqueUserCount");
    }

    public void removeUniqueUserCount() {
        this._map.remove("uniqueUserCount");
    }

    @Nullable
    public Integer getUniqueUserCount(GetMode mode) {
        return this.getUniqueUserCount();
    }

    @Nullable
    public Integer getUniqueUserCount() {
        if (this._uniqueUserCountField != null) {
            return this._uniqueUserCountField;
        }
        Object __rawValue = this._map.get("uniqueUserCount");
        this._uniqueUserCountField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._uniqueUserCountField;
    }

    public UsageQueryResultAggregations setUniqueUserCount(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUniqueUserCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUniqueUserCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "uniqueUserCount", DataTemplateUtil.coerceIntInput(value));
                this._uniqueUserCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "uniqueUserCount", DataTemplateUtil.coerceIntInput(value));
                this._uniqueUserCountField = value;
            }
        }
        return this;
    }

    public UsageQueryResultAggregations setUniqueUserCount(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field uniqueUserCount of com.linkedin.usage.UsageQueryResultAggregations to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "uniqueUserCount", DataTemplateUtil.coerceIntInput(value));
        this._uniqueUserCountField = value;
        return this;
    }

    public UsageQueryResultAggregations setUniqueUserCount(int value) {
        CheckedUtil.putWithoutChecking(this._map, "uniqueUserCount", DataTemplateUtil.coerceIntInput(value));
        this._uniqueUserCountField = value;
        return this;
    }

    public boolean hasTotalSqlQueries() {
        if (this._totalSqlQueriesField != null) {
            return true;
        }
        return this._map.containsKey("totalSqlQueries");
    }

    public void removeTotalSqlQueries() {
        this._map.remove("totalSqlQueries");
    }

    @Nullable
    public Integer getTotalSqlQueries(GetMode mode) {
        return this.getTotalSqlQueries();
    }

    @Nullable
    public Integer getTotalSqlQueries() {
        if (this._totalSqlQueriesField != null) {
            return this._totalSqlQueriesField;
        }
        Object __rawValue = this._map.get("totalSqlQueries");
        this._totalSqlQueriesField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._totalSqlQueriesField;
    }

    public UsageQueryResultAggregations setTotalSqlQueries(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTotalSqlQueries(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTotalSqlQueries();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "totalSqlQueries", DataTemplateUtil.coerceIntInput(value));
                this._totalSqlQueriesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "totalSqlQueries", DataTemplateUtil.coerceIntInput(value));
                this._totalSqlQueriesField = value;
            }
        }
        return this;
    }

    public UsageQueryResultAggregations setTotalSqlQueries(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field totalSqlQueries of com.linkedin.usage.UsageQueryResultAggregations to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "totalSqlQueries", DataTemplateUtil.coerceIntInput(value));
        this._totalSqlQueriesField = value;
        return this;
    }

    public UsageQueryResultAggregations setTotalSqlQueries(int value) {
        CheckedUtil.putWithoutChecking(this._map, "totalSqlQueries", DataTemplateUtil.coerceIntInput(value));
        this._totalSqlQueriesField = value;
        return this;
    }

    public boolean hasUsers() {
        if (this._usersField != null) {
            return true;
        }
        return this._map.containsKey("users");
    }

    public void removeUsers() {
        this._map.remove("users");
    }

    @Nullable
    public UserUsageCountsArray getUsers(GetMode mode) {
        return this.getUsers();
    }

    @Nullable
    public UserUsageCountsArray getUsers() {
        if (this._usersField != null) {
            return this._usersField;
        }
        Object __rawValue = this._map.get("users");
        this._usersField = __rawValue == null ? null : new UserUsageCountsArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._usersField;
    }

    public UsageQueryResultAggregations setUsers(@Nullable UserUsageCountsArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUsers(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUsers();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "users", value.data());
                this._usersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "users", value.data());
                this._usersField = value;
            }
        }
        return this;
    }

    public UsageQueryResultAggregations setUsers(@Nonnull UserUsageCountsArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field users of com.linkedin.usage.UsageQueryResultAggregations to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "users", value.data());
        this._usersField = value;
        return this;
    }

    public boolean hasFields() {
        if (this._fieldsField != null) {
            return true;
        }
        return this._map.containsKey("fields");
    }

    public void removeFields() {
        this._map.remove("fields");
    }

    @Nullable
    public FieldUsageCountsArray getFields(GetMode mode) {
        return this.getFields();
    }

    @Nullable
    public FieldUsageCountsArray getFields() {
        if (this._fieldsField != null) {
            return this._fieldsField;
        }
        Object __rawValue = this._map.get("fields");
        this._fieldsField = __rawValue == null ? null : new FieldUsageCountsArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._fieldsField;
    }

    public UsageQueryResultAggregations setFields(@Nullable FieldUsageCountsArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFields(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFields();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fields", value.data());
                this._fieldsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fields", value.data());
                this._fieldsField = value;
            }
        }
        return this;
    }

    public UsageQueryResultAggregations setFields(@Nonnull FieldUsageCountsArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fields of com.linkedin.usage.UsageQueryResultAggregations to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fields", value.data());
        this._fieldsField = value;
        return this;
    }

    @Override
    public UsageQueryResultAggregations clone() throws CloneNotSupportedException {
        UsageQueryResultAggregations __clone = (UsageQueryResultAggregations)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public UsageQueryResultAggregations copy() throws CloneNotSupportedException {
        UsageQueryResultAggregations __copy = (UsageQueryResultAggregations)super.copy();
        __copy._totalSqlQueriesField = null;
        __copy._fieldsField = null;
        __copy._uniqueUserCountField = null;
        __copy._usersField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final UsageQueryResultAggregations __objectRef;

        private ChangeListener(UsageQueryResultAggregations reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "totalSqlQueries": {
                    this.__objectRef._totalSqlQueriesField = null;
                    break;
                }
                case "fields": {
                    this.__objectRef._fieldsField = null;
                    break;
                }
                case "uniqueUserCount": {
                    this.__objectRef._uniqueUserCountField = null;
                    break;
                }
                case "users": {
                    this.__objectRef._usersField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec uniqueUserCount() {
            return new PathSpec(this.getPathComponents(), "uniqueUserCount");
        }

        public PathSpec totalSqlQueries() {
            return new PathSpec(this.getPathComponents(), "totalSqlQueries");
        }

        public UserUsageCountsArray.Fields users() {
            return new UserUsageCountsArray.Fields(this.getPathComponents(), "users");
        }

        public PathSpec users(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "users");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public FieldUsageCountsArray.Fields fields() {
            return new FieldUsageCountsArray.Fields(this.getPathComponents(), "fields");
        }

        public PathSpec fields(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "fields");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private UserUsageCountsArray.ProjectionMask _usersMask;
        private FieldUsageCountsArray.ProjectionMask _fieldsMask;

        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withUniqueUserCount() {
            this.getDataMap().put("uniqueUserCount", 1);
            return this;
        }

        public ProjectionMask withTotalSqlQueries() {
            this.getDataMap().put("totalSqlQueries", 1);
            return this;
        }

        public ProjectionMask withUsers(Function<UserUsageCountsArray.ProjectionMask, UserUsageCountsArray.ProjectionMask> nestedMask) {
            this._usersMask = nestedMask.apply(this._usersMask == null ? UserUsageCountsArray.createMask() : this._usersMask);
            this.getDataMap().put("users", this._usersMask.getDataMap());
            return this;
        }

        public ProjectionMask withUsers() {
            this._usersMask = null;
            this.getDataMap().put("users", 1);
            return this;
        }

        public ProjectionMask withUsers(Function<UserUsageCountsArray.ProjectionMask, UserUsageCountsArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._usersMask = nestedMask.apply(this._usersMask == null ? UserUsageCountsArray.createMask() : this._usersMask);
            this.getDataMap().put("users", this._usersMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("users").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("users").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withUsers(Integer start, Integer count) {
            this._usersMask = null;
            this.getDataMap().put("users", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("users").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("users").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withFields(Function<FieldUsageCountsArray.ProjectionMask, FieldUsageCountsArray.ProjectionMask> nestedMask) {
            this._fieldsMask = nestedMask.apply(this._fieldsMask == null ? FieldUsageCountsArray.createMask() : this._fieldsMask);
            this.getDataMap().put("fields", this._fieldsMask.getDataMap());
            return this;
        }

        public ProjectionMask withFields() {
            this._fieldsMask = null;
            this.getDataMap().put("fields", 1);
            return this;
        }

        public ProjectionMask withFields(Function<FieldUsageCountsArray.ProjectionMask, FieldUsageCountsArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._fieldsMask = nestedMask.apply(this._fieldsMask == null ? FieldUsageCountsArray.createMask() : this._fieldsMask);
            this.getDataMap().put("fields", this._fieldsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("fields").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("fields").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withFields(Integer start, Integer count) {
            this._fieldsMask = null;
            this.getDataMap().put("fields", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("fields").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("fields").put("$count", count);
            }
            return this;
        }
    }
}

