/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.timeseries;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.timeseries.TimeWindowSize;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TimeWindow
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.timeseries,record TimeWindow{/**Start time as epoch at UTC.*/startTimeMillis:long/**The length of the window.*/length:/**Defines the size of a time window.*/record TimeWindowSize{/**Interval unit such as minute/hour/day etc.*/unit:enum CalendarInterval{SECOND,MINUTE,HOUR,DAY,WEEK,MONTH,QUARTER,YEAR}/**How many units. Defaults to 1.*/multiple:int=1}}", SchemaFormatType.PDL);
    private Long _startTimeMillisField = null;
    private TimeWindowSize _lengthField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_StartTimeMillis = SCHEMA.getField("startTimeMillis");
    private static final RecordDataSchema.Field FIELD_Length = SCHEMA.getField("length");

    public TimeWindow() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public TimeWindow(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasStartTimeMillis() {
        if (this._startTimeMillisField != null) {
            return true;
        }
        return this._map.containsKey("startTimeMillis");
    }

    public void removeStartTimeMillis() {
        this._map.remove("startTimeMillis");
    }

    @Nullable
    public Long getStartTimeMillis(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getStartTimeMillis();
            }
            case DEFAULT: 
            case NULL: {
                if (this._startTimeMillisField != null) {
                    return this._startTimeMillisField;
                }
                Object __rawValue = this._map.get("startTimeMillis");
                this._startTimeMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._startTimeMillisField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getStartTimeMillis() {
        if (this._startTimeMillisField != null) {
            return this._startTimeMillisField;
        }
        Object __rawValue = this._map.get("startTimeMillis");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("startTimeMillis");
        }
        this._startTimeMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._startTimeMillisField;
    }

    public TimeWindow setStartTimeMillis(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStartTimeMillis(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field startTimeMillis of com.linkedin.timeseries.TimeWindow");
                }
                CheckedUtil.putWithoutChecking(this._map, "startTimeMillis", DataTemplateUtil.coerceLongInput(value));
                this._startTimeMillisField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStartTimeMillis();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "startTimeMillis", DataTemplateUtil.coerceLongInput(value));
                this._startTimeMillisField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "startTimeMillis", DataTemplateUtil.coerceLongInput(value));
                this._startTimeMillisField = value;
            }
        }
        return this;
    }

    public TimeWindow setStartTimeMillis(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field startTimeMillis of com.linkedin.timeseries.TimeWindow to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "startTimeMillis", DataTemplateUtil.coerceLongInput(value));
        this._startTimeMillisField = value;
        return this;
    }

    public TimeWindow setStartTimeMillis(long value) {
        CheckedUtil.putWithoutChecking(this._map, "startTimeMillis", DataTemplateUtil.coerceLongInput(value));
        this._startTimeMillisField = value;
        return this;
    }

    public boolean hasLength() {
        if (this._lengthField != null) {
            return true;
        }
        return this._map.containsKey("length");
    }

    public void removeLength() {
        this._map.remove("length");
    }

    @Nullable
    public TimeWindowSize getLength(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getLength();
            }
            case DEFAULT: 
            case NULL: {
                if (this._lengthField != null) {
                    return this._lengthField;
                }
                Object __rawValue = this._map.get("length");
                this._lengthField = __rawValue == null ? null : new TimeWindowSize(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._lengthField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public TimeWindowSize getLength() {
        if (this._lengthField != null) {
            return this._lengthField;
        }
        Object __rawValue = this._map.get("length");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("length");
        }
        this._lengthField = __rawValue == null ? null : new TimeWindowSize(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lengthField;
    }

    public TimeWindow setLength(@Nullable TimeWindowSize value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLength(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field length of com.linkedin.timeseries.TimeWindow");
                }
                CheckedUtil.putWithoutChecking(this._map, "length", value.data());
                this._lengthField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLength();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "length", value.data());
                this._lengthField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "length", value.data());
                this._lengthField = value;
            }
        }
        return this;
    }

    public TimeWindow setLength(@Nonnull TimeWindowSize value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field length of com.linkedin.timeseries.TimeWindow to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "length", value.data());
        this._lengthField = value;
        return this;
    }

    @Override
    public TimeWindow clone() throws CloneNotSupportedException {
        TimeWindow __clone = (TimeWindow)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public TimeWindow copy() throws CloneNotSupportedException {
        TimeWindow __copy = (TimeWindow)super.copy();
        __copy._startTimeMillisField = null;
        __copy._lengthField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final TimeWindow __objectRef;

        private ChangeListener(TimeWindow reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "startTimeMillis": {
                    this.__objectRef._startTimeMillisField = null;
                    break;
                }
                case "length": {
                    this.__objectRef._lengthField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec startTimeMillis() {
            return new PathSpec(this.getPathComponents(), "startTimeMillis");
        }

        public TimeWindowSize.Fields length() {
            return new TimeWindowSize.Fields(this.getPathComponents(), "length");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TimeWindowSize.ProjectionMask _lengthMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withStartTimeMillis() {
            this.getDataMap().put("startTimeMillis", 1);
            return this;
        }

        public ProjectionMask withLength(Function<TimeWindowSize.ProjectionMask, TimeWindowSize.ProjectionMask> nestedMask) {
            this._lengthMask = nestedMask.apply(this._lengthMask == null ? TimeWindowSize.createMask() : this._lengthMask);
            this.getDataMap().put("length", this._lengthMask.getDataMap());
            return this;
        }

        public ProjectionMask withLength() {
            this._lengthMask = null;
            this.getDataMap().put("length", 1);
            return this;
        }
    }
}

