/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.template;

import com.linkedin.common.UrnArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataHubPageTemplateRow
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.template/**A row of modules contained in a template*/record DataHubPageTemplateRow{/**The modules that exist in this template row*/modules:array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]}", SchemaFormatType.PDL);
    private UrnArray _modulesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Modules = SCHEMA.getField("modules");

    public DataHubPageTemplateRow() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public DataHubPageTemplateRow(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasModules() {
        if (this._modulesField != null) {
            return true;
        }
        return this._map.containsKey("modules");
    }

    public void removeModules() {
        this._map.remove("modules");
    }

    @Nullable
    public UrnArray getModules(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getModules();
            }
            case DEFAULT: 
            case NULL: {
                if (this._modulesField != null) {
                    return this._modulesField;
                }
                Object __rawValue = this._map.get("modules");
                this._modulesField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._modulesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UrnArray getModules() {
        if (this._modulesField != null) {
            return this._modulesField;
        }
        Object __rawValue = this._map.get("modules");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("modules");
        }
        this._modulesField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._modulesField;
    }

    public DataHubPageTemplateRow setModules(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setModules(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field modules of com.linkedin.template.DataHubPageTemplateRow");
                }
                CheckedUtil.putWithoutChecking(this._map, "modules", value.data());
                this._modulesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeModules();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "modules", value.data());
                this._modulesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "modules", value.data());
                this._modulesField = value;
            }
        }
        return this;
    }

    public DataHubPageTemplateRow setModules(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field modules of com.linkedin.template.DataHubPageTemplateRow to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "modules", value.data());
        this._modulesField = value;
        return this;
    }

    @Override
    public DataHubPageTemplateRow clone() throws CloneNotSupportedException {
        DataHubPageTemplateRow __clone = (DataHubPageTemplateRow)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataHubPageTemplateRow copy() throws CloneNotSupportedException {
        DataHubPageTemplateRow __copy = (DataHubPageTemplateRow)super.copy();
        __copy._modulesField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataHubPageTemplateRow __objectRef;

        private ChangeListener(DataHubPageTemplateRow reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "modules": {
                    this.__objectRef._modulesField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec modules() {
            return new PathSpec(this.getPathComponents(), "modules");
        }

        public PathSpec modules(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "modules");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withModules() {
            this.getDataMap().put("modules", 1);
            return this;
        }

        public ProjectionMask withModules(Integer start, Integer count) {
            this.getDataMap().put("modules", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("modules").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("modules").put("$count", count);
            }
            return this;
        }
    }
}

