/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.template;

import com.linkedin.common.AuditStamp;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.template.DataHubPageTemplateRowArray;
import com.linkedin.template.DataHubPageTemplateSurface;
import com.linkedin.template.DataHubPageTemplateVisibility;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataHubPageTemplateProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.template/**The main properties of a DataHub page template*/@Aspect.name=\"dataHubPageTemplateProperties\"record DataHubPageTemplateProperties{/**The rows of modules contained in this template*/@Relationship.`/*/modules/*`={\"entityTypes\":[\"dataHubPageModule\"],\"name\":\"ContainedIn\"}rows:array[/**A row of modules contained in a template*/record DataHubPageTemplateRow{/**The modules that exist in this template row*/modules:array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]}]/**Info about the surface area of the product that this template is deployed in*/surface:/**Info about the surface area of the product that this template is deployed in*/record DataHubPageTemplateSurface{/**Where exactly is this template being used*/@Searchable.fieldType=\"KEYWORD\"surfaceType:enum PageTemplateSurfaceType{/**This template applies to what to display on the home page for users.*/HOME_PAGE}}/**Info about the visibility of this template*/visibility:/**Info about the visibility of this template*/record DataHubPageTemplateVisibility{/**The scope of this template and who can use/see it*/@Searchable.fieldType=\"KEYWORD\"scope:enum PageTemplateScope{/**This template is used for individual use only*/PERSONAL/**This template is used across users*/GLOBAL}}/**Audit stamp for when and by whom this template was created*/@Searchable={\"/actor\":{\"fieldName\":\"createdBy\",\"fieldType\":\"URN\"},\"/time\":{\"fieldName\":\"createdAt\",\"fieldType\":\"DATETIME\"}}created:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}/**Audit stamp for when and by whom this template was last updated*/@Searchable.`/time`={\"fieldName\":\"lastModifiedAt\",\"fieldType\":\"DATETIME\"}lastModified:com.linkedin.common.AuditStamp}", SchemaFormatType.PDL);
    private DataHubPageTemplateRowArray _rowsField = null;
    private DataHubPageTemplateSurface _surfaceField = null;
    private DataHubPageTemplateVisibility _visibilityField = null;
    private AuditStamp _createdField = null;
    private AuditStamp _lastModifiedField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Rows = SCHEMA.getField("rows");
    private static final RecordDataSchema.Field FIELD_Surface = SCHEMA.getField("surface");
    private static final RecordDataSchema.Field FIELD_Visibility = SCHEMA.getField("visibility");
    private static final RecordDataSchema.Field FIELD_Created = SCHEMA.getField("created");
    private static final RecordDataSchema.Field FIELD_LastModified = SCHEMA.getField("lastModified");

    public DataHubPageTemplateProperties() {
        super(new DataMap(7, 0.75f), SCHEMA, 7);
        this.addChangeListener(this.__changeListener);
    }

    public DataHubPageTemplateProperties(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasRows() {
        if (this._rowsField != null) {
            return true;
        }
        return this._map.containsKey("rows");
    }

    public void removeRows() {
        this._map.remove("rows");
    }

    @Nullable
    public DataHubPageTemplateRowArray getRows(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getRows();
            }
            case DEFAULT: 
            case NULL: {
                if (this._rowsField != null) {
                    return this._rowsField;
                }
                Object __rawValue = this._map.get("rows");
                this._rowsField = __rawValue == null ? null : new DataHubPageTemplateRowArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._rowsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DataHubPageTemplateRowArray getRows() {
        if (this._rowsField != null) {
            return this._rowsField;
        }
        Object __rawValue = this._map.get("rows");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("rows");
        }
        this._rowsField = __rawValue == null ? null : new DataHubPageTemplateRowArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._rowsField;
    }

    public DataHubPageTemplateProperties setRows(@Nullable DataHubPageTemplateRowArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRows(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field rows of com.linkedin.template.DataHubPageTemplateProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "rows", value.data());
                this._rowsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRows();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "rows", value.data());
                this._rowsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "rows", value.data());
                this._rowsField = value;
            }
        }
        return this;
    }

    public DataHubPageTemplateProperties setRows(@Nonnull DataHubPageTemplateRowArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field rows of com.linkedin.template.DataHubPageTemplateProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "rows", value.data());
        this._rowsField = value;
        return this;
    }

    public boolean hasSurface() {
        if (this._surfaceField != null) {
            return true;
        }
        return this._map.containsKey("surface");
    }

    public void removeSurface() {
        this._map.remove("surface");
    }

    @Nullable
    public DataHubPageTemplateSurface getSurface(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSurface();
            }
            case DEFAULT: 
            case NULL: {
                if (this._surfaceField != null) {
                    return this._surfaceField;
                }
                Object __rawValue = this._map.get("surface");
                this._surfaceField = __rawValue == null ? null : new DataHubPageTemplateSurface(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._surfaceField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DataHubPageTemplateSurface getSurface() {
        if (this._surfaceField != null) {
            return this._surfaceField;
        }
        Object __rawValue = this._map.get("surface");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("surface");
        }
        this._surfaceField = __rawValue == null ? null : new DataHubPageTemplateSurface(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._surfaceField;
    }

    public DataHubPageTemplateProperties setSurface(@Nullable DataHubPageTemplateSurface value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSurface(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field surface of com.linkedin.template.DataHubPageTemplateProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "surface", value.data());
                this._surfaceField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSurface();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "surface", value.data());
                this._surfaceField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "surface", value.data());
                this._surfaceField = value;
            }
        }
        return this;
    }

    public DataHubPageTemplateProperties setSurface(@Nonnull DataHubPageTemplateSurface value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field surface of com.linkedin.template.DataHubPageTemplateProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "surface", value.data());
        this._surfaceField = value;
        return this;
    }

    public boolean hasVisibility() {
        if (this._visibilityField != null) {
            return true;
        }
        return this._map.containsKey("visibility");
    }

    public void removeVisibility() {
        this._map.remove("visibility");
    }

    @Nullable
    public DataHubPageTemplateVisibility getVisibility(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getVisibility();
            }
            case DEFAULT: 
            case NULL: {
                if (this._visibilityField != null) {
                    return this._visibilityField;
                }
                Object __rawValue = this._map.get("visibility");
                this._visibilityField = __rawValue == null ? null : new DataHubPageTemplateVisibility(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._visibilityField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DataHubPageTemplateVisibility getVisibility() {
        if (this._visibilityField != null) {
            return this._visibilityField;
        }
        Object __rawValue = this._map.get("visibility");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("visibility");
        }
        this._visibilityField = __rawValue == null ? null : new DataHubPageTemplateVisibility(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._visibilityField;
    }

    public DataHubPageTemplateProperties setVisibility(@Nullable DataHubPageTemplateVisibility value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVisibility(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field visibility of com.linkedin.template.DataHubPageTemplateProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "visibility", value.data());
                this._visibilityField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVisibility();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "visibility", value.data());
                this._visibilityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "visibility", value.data());
                this._visibilityField = value;
            }
        }
        return this;
    }

    public DataHubPageTemplateProperties setVisibility(@Nonnull DataHubPageTemplateVisibility value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field visibility of com.linkedin.template.DataHubPageTemplateProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "visibility", value.data());
        this._visibilityField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCreated();
            }
            case DEFAULT: 
            case NULL: {
                if (this._createdField != null) {
                    return this._createdField;
                }
                Object __rawValue = this._map.get("created");
                this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._createdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("created");
        }
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public DataHubPageTemplateProperties setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field created of com.linkedin.template.DataHubPageTemplateProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public DataHubPageTemplateProperties setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.template.DataHubPageTemplateProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public AuditStamp getLastModified(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getLastModified();
            }
            case DEFAULT: 
            case NULL: {
                if (this._lastModifiedField != null) {
                    return this._lastModifiedField;
                }
                Object __rawValue = this._map.get("lastModified");
                this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._lastModifiedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("lastModified");
        }
        this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public DataHubPageTemplateProperties setLastModified(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field lastModified of com.linkedin.template.DataHubPageTemplateProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public DataHubPageTemplateProperties setLastModified(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.template.DataHubPageTemplateProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    @Override
    public DataHubPageTemplateProperties clone() throws CloneNotSupportedException {
        DataHubPageTemplateProperties __clone = (DataHubPageTemplateProperties)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataHubPageTemplateProperties copy() throws CloneNotSupportedException {
        DataHubPageTemplateProperties __copy = (DataHubPageTemplateProperties)super.copy();
        __copy._surfaceField = null;
        __copy._visibilityField = null;
        __copy._createdField = null;
        __copy._lastModifiedField = null;
        __copy._rowsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataHubPageTemplateProperties __objectRef;

        private ChangeListener(DataHubPageTemplateProperties reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "surface": {
                    this.__objectRef._surfaceField = null;
                    break;
                }
                case "visibility": {
                    this.__objectRef._visibilityField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                    break;
                }
                case "rows": {
                    this.__objectRef._rowsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public DataHubPageTemplateRowArray.Fields rows() {
            return new DataHubPageTemplateRowArray.Fields(this.getPathComponents(), "rows");
        }

        public PathSpec rows(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "rows");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public DataHubPageTemplateSurface.Fields surface() {
            return new DataHubPageTemplateSurface.Fields(this.getPathComponents(), "surface");
        }

        public DataHubPageTemplateVisibility.Fields visibility() {
            return new DataHubPageTemplateVisibility.Fields(this.getPathComponents(), "visibility");
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }

        public AuditStamp.Fields lastModified() {
            return new AuditStamp.Fields(this.getPathComponents(), "lastModified");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private DataHubPageTemplateRowArray.ProjectionMask _rowsMask;
        private DataHubPageTemplateSurface.ProjectionMask _surfaceMask;
        private DataHubPageTemplateVisibility.ProjectionMask _visibilityMask;
        private AuditStamp.ProjectionMask _createdMask;
        private AuditStamp.ProjectionMask _lastModifiedMask;

        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withRows(Function<DataHubPageTemplateRowArray.ProjectionMask, DataHubPageTemplateRowArray.ProjectionMask> nestedMask) {
            this._rowsMask = nestedMask.apply(this._rowsMask == null ? DataHubPageTemplateRowArray.createMask() : this._rowsMask);
            this.getDataMap().put("rows", this._rowsMask.getDataMap());
            return this;
        }

        public ProjectionMask withRows() {
            this._rowsMask = null;
            this.getDataMap().put("rows", 1);
            return this;
        }

        public ProjectionMask withRows(Function<DataHubPageTemplateRowArray.ProjectionMask, DataHubPageTemplateRowArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._rowsMask = nestedMask.apply(this._rowsMask == null ? DataHubPageTemplateRowArray.createMask() : this._rowsMask);
            this.getDataMap().put("rows", this._rowsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("rows").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("rows").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withRows(Integer start, Integer count) {
            this._rowsMask = null;
            this.getDataMap().put("rows", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("rows").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("rows").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withSurface(Function<DataHubPageTemplateSurface.ProjectionMask, DataHubPageTemplateSurface.ProjectionMask> nestedMask) {
            this._surfaceMask = nestedMask.apply(this._surfaceMask == null ? DataHubPageTemplateSurface.createMask() : this._surfaceMask);
            this.getDataMap().put("surface", this._surfaceMask.getDataMap());
            return this;
        }

        public ProjectionMask withSurface() {
            this._surfaceMask = null;
            this.getDataMap().put("surface", 1);
            return this;
        }

        public ProjectionMask withVisibility(Function<DataHubPageTemplateVisibility.ProjectionMask, DataHubPageTemplateVisibility.ProjectionMask> nestedMask) {
            this._visibilityMask = nestedMask.apply(this._visibilityMask == null ? DataHubPageTemplateVisibility.createMask() : this._visibilityMask);
            this.getDataMap().put("visibility", this._visibilityMask.getDataMap());
            return this;
        }

        public ProjectionMask withVisibility() {
            this._visibilityMask = null;
            this.getDataMap().put("visibility", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? AuditStamp.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }
    }
}

