/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.structured;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.MetadataAttribution;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.structured.PrimitivePropertyValueArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StructuredPropertyValueAssignment
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.structured,record StructuredPropertyValueAssignment{/**The property that is being assigned a value.*/propertyUrn:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The value assigned to the property.*/values:array[/**Represents a stored primitive property value\n*/typeref PrimitivePropertyValue=union[string,double]]/**Audit stamp containing who created this relationship edge and when*/created:optional{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}/**Audit stamp containing who last modified this relationship edge and when*/lastModified:optional com.linkedin.common.AuditStamp/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"structuredPropertyAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"structuredPropertyAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"structuredPropertyAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional{namespace com.linkedin.common/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:Time/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}}", SchemaFormatType.PDL);
    private Urn _propertyUrnField = null;
    private PrimitivePropertyValueArray _valuesField = null;
    private AuditStamp _createdField = null;
    private AuditStamp _lastModifiedField = null;
    private MetadataAttribution _attributionField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_PropertyUrn = SCHEMA.getField("propertyUrn");
    private static final RecordDataSchema.Field FIELD_Values = SCHEMA.getField("values");
    private static final RecordDataSchema.Field FIELD_Created = SCHEMA.getField("created");
    private static final RecordDataSchema.Field FIELD_LastModified = SCHEMA.getField("lastModified");
    private static final RecordDataSchema.Field FIELD_Attribution = SCHEMA.getField("attribution");

    public StructuredPropertyValueAssignment() {
        super(new DataMap(7, 0.75f), SCHEMA, 6);
        this.addChangeListener(this.__changeListener);
    }

    public StructuredPropertyValueAssignment(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasPropertyUrn() {
        if (this._propertyUrnField != null) {
            return true;
        }
        return this._map.containsKey("propertyUrn");
    }

    public void removePropertyUrn() {
        this._map.remove("propertyUrn");
    }

    @Nullable
    public Urn getPropertyUrn(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPropertyUrn();
            }
            case DEFAULT: 
            case NULL: {
                if (this._propertyUrnField != null) {
                    return this._propertyUrnField;
                }
                Object __rawValue = this._map.get("propertyUrn");
                this._propertyUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._propertyUrnField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getPropertyUrn() {
        if (this._propertyUrnField != null) {
            return this._propertyUrnField;
        }
        Object __rawValue = this._map.get("propertyUrn");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("propertyUrn");
        }
        this._propertyUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._propertyUrnField;
    }

    public StructuredPropertyValueAssignment setPropertyUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPropertyUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field propertyUrn of com.linkedin.structured.StructuredPropertyValueAssignment");
                }
                CheckedUtil.putWithoutChecking(this._map, "propertyUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._propertyUrnField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePropertyUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "propertyUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._propertyUrnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "propertyUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._propertyUrnField = value;
            }
        }
        return this;
    }

    public StructuredPropertyValueAssignment setPropertyUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field propertyUrn of com.linkedin.structured.StructuredPropertyValueAssignment to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "propertyUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._propertyUrnField = value;
        return this;
    }

    public boolean hasValues() {
        if (this._valuesField != null) {
            return true;
        }
        return this._map.containsKey("values");
    }

    public void removeValues() {
        this._map.remove("values");
    }

    @Nullable
    public PrimitivePropertyValueArray getValues(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getValues();
            }
            case DEFAULT: 
            case NULL: {
                if (this._valuesField != null) {
                    return this._valuesField;
                }
                Object __rawValue = this._map.get("values");
                this._valuesField = __rawValue == null ? null : new PrimitivePropertyValueArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._valuesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public PrimitivePropertyValueArray getValues() {
        if (this._valuesField != null) {
            return this._valuesField;
        }
        Object __rawValue = this._map.get("values");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("values");
        }
        this._valuesField = __rawValue == null ? null : new PrimitivePropertyValueArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._valuesField;
    }

    public StructuredPropertyValueAssignment setValues(@Nullable PrimitivePropertyValueArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setValues(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field values of com.linkedin.structured.StructuredPropertyValueAssignment");
                }
                CheckedUtil.putWithoutChecking(this._map, "values", value.data());
                this._valuesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeValues();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "values", value.data());
                this._valuesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "values", value.data());
                this._valuesField = value;
            }
        }
        return this;
    }

    public StructuredPropertyValueAssignment setValues(@Nonnull PrimitivePropertyValueArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field values of com.linkedin.structured.StructuredPropertyValueAssignment to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "values", value.data());
        this._valuesField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        return this.getCreated();
    }

    @Nullable
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public StructuredPropertyValueAssignment setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public StructuredPropertyValueAssignment setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.structured.StructuredPropertyValueAssignment to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public AuditStamp getLastModified(GetMode mode) {
        return this.getLastModified();
    }

    @Nullable
    public AuditStamp getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public StructuredPropertyValueAssignment setLastModified(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public StructuredPropertyValueAssignment setLastModified(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.structured.StructuredPropertyValueAssignment to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    public boolean hasAttribution() {
        if (this._attributionField != null) {
            return true;
        }
        return this._map.containsKey("attribution");
    }

    public void removeAttribution() {
        this._map.remove("attribution");
    }

    @Nullable
    public MetadataAttribution getAttribution(GetMode mode) {
        return this.getAttribution();
    }

    @Nullable
    public MetadataAttribution getAttribution() {
        if (this._attributionField != null) {
            return this._attributionField;
        }
        Object __rawValue = this._map.get("attribution");
        this._attributionField = __rawValue == null ? null : new MetadataAttribution(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._attributionField;
    }

    public StructuredPropertyValueAssignment setAttribution(@Nullable MetadataAttribution value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAttribution(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAttribution();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "attribution", value.data());
                this._attributionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "attribution", value.data());
                this._attributionField = value;
            }
        }
        return this;
    }

    public StructuredPropertyValueAssignment setAttribution(@Nonnull MetadataAttribution value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field attribution of com.linkedin.structured.StructuredPropertyValueAssignment to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "attribution", value.data());
        this._attributionField = value;
        return this;
    }

    @Override
    public StructuredPropertyValueAssignment clone() throws CloneNotSupportedException {
        StructuredPropertyValueAssignment __clone = (StructuredPropertyValueAssignment)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public StructuredPropertyValueAssignment copy() throws CloneNotSupportedException {
        StructuredPropertyValueAssignment __copy = (StructuredPropertyValueAssignment)super.copy();
        __copy._createdField = null;
        __copy._propertyUrnField = null;
        __copy._valuesField = null;
        __copy._attributionField = null;
        __copy._lastModifiedField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final StructuredPropertyValueAssignment __objectRef;

        private ChangeListener(StructuredPropertyValueAssignment reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "propertyUrn": {
                    this.__objectRef._propertyUrnField = null;
                    break;
                }
                case "values": {
                    this.__objectRef._valuesField = null;
                    break;
                }
                case "attribution": {
                    this.__objectRef._attributionField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec propertyUrn() {
            return new PathSpec(this.getPathComponents(), "propertyUrn");
        }

        public PrimitivePropertyValueArray.Fields values() {
            return new PrimitivePropertyValueArray.Fields(this.getPathComponents(), "values");
        }

        public PathSpec values(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "values");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }

        public AuditStamp.Fields lastModified() {
            return new AuditStamp.Fields(this.getPathComponents(), "lastModified");
        }

        public MetadataAttribution.Fields attribution() {
            return new MetadataAttribution.Fields(this.getPathComponents(), "attribution");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private PrimitivePropertyValueArray.ProjectionMask _valuesMask;
        private AuditStamp.ProjectionMask _createdMask;
        private AuditStamp.ProjectionMask _lastModifiedMask;
        private MetadataAttribution.ProjectionMask _attributionMask;

        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withPropertyUrn() {
            this.getDataMap().put("propertyUrn", 1);
            return this;
        }

        public ProjectionMask withValues(Function<PrimitivePropertyValueArray.ProjectionMask, PrimitivePropertyValueArray.ProjectionMask> nestedMask) {
            this._valuesMask = nestedMask.apply(this._valuesMask == null ? PrimitivePropertyValueArray.createMask() : this._valuesMask);
            this.getDataMap().put("values", this._valuesMask.getDataMap());
            return this;
        }

        public ProjectionMask withValues() {
            this._valuesMask = null;
            this.getDataMap().put("values", 1);
            return this;
        }

        public ProjectionMask withValues(Function<PrimitivePropertyValueArray.ProjectionMask, PrimitivePropertyValueArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._valuesMask = nestedMask.apply(this._valuesMask == null ? PrimitivePropertyValueArray.createMask() : this._valuesMask);
            this.getDataMap().put("values", this._valuesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("values").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("values").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withValues(Integer start, Integer count) {
            this._valuesMask = null;
            this.getDataMap().put("values", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("values").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("values").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? AuditStamp.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }

        public ProjectionMask withAttribution(Function<MetadataAttribution.ProjectionMask, MetadataAttribution.ProjectionMask> nestedMask) {
            this._attributionMask = nestedMask.apply(this._attributionMask == null ? MetadataAttribution.createMask() : this._attributionMask);
            this.getDataMap().put("attribution", this._attributionMask.getDataMap());
            return this;
        }

        public ProjectionMask withAttribution() {
            this._attributionMask = null;
            this.getDataMap().put("attribution", 1);
            return this;
        }
    }
}

