/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.settings.global;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OidcSettings
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.settings.global/**Settings for OIDC SSO integration.*/record OidcSettings{/**Whether OIDC SSO is enabled.*/enabled:boolean/**Unique client id issued by the identity provider.*/clientId:string/**Unique client secret issued by the identity provider.*/clientSecret:string/**The IdP OIDC discovery url.*/discoveryUri:string/**ADVANCED. The attribute / claim used to derive the DataHub username. Defaults to \"preferred_username\".*/userNameClaim:optional string/**ADVANCED. TThe regex used to parse the DataHub username from the user name claim. Defaults to (.*) (all).*/userNameClaimRegex:optional string/**ADVANCED. String representing the requested scope from the IdP. Defaults to \"oidc email profile\".*/scope:optional string/**ADVANCED. Which authentication method to use to pass credentials (clientId and clientSecret) to the token endpoint: Defaults to \"client_secret_basic\".*/clientAuthenticationMethod:optional string/**ADVANCED. Whether DataHub users should be provisioned on login if they do not exist. Defaults to true.*/jitProvisioningEnabled:optional boolean/**ADVANCED. Whether the user should already exist in DataHub on login, failing login if they are not. Defaults to false.*/preProvisioningRequired:optional boolean/**ADVANCED. Whether groups should be extracted from a claim in the OIDC profile. Only applies if JIT provisioning is enabled. Groups will be created if they do not exist. Defaults to true.*/extractGroupsEnabled:optional boolean/**ADVANCED. The OIDC claim to extract groups information from. Defaults to 'groups'.*/groupsClaim:optional string/**ADVANCED. Response type.*/responseType:optional string/**ADVANCED. Response mode.*/responseMode:optional string/**ADVANCED. Use Nonce.*/useNonce:optional boolean/**ADVANCED. Read timeout.*/readTimeout:optional long/**ADVANCED. Whether to extract claims from JWT access token.  Defaults to false.*/extractJwtAccessTokenClaims:optional boolean/** ADVANCED. Which jws algorithm to use. Unused.*/preferredJwsAlgorithm:optional string/** ADVANCED. Which jws algorithm to use.*/preferredJwsAlgorithm2:optional string}", SchemaFormatType.PDL);
    private Boolean _enabledField = null;
    private String _clientIdField = null;
    private String _clientSecretField = null;
    private String _discoveryUriField = null;
    private String _userNameClaimField = null;
    private String _userNameClaimRegexField = null;
    private String _scopeField = null;
    private String _clientAuthenticationMethodField = null;
    private Boolean _jitProvisioningEnabledField = null;
    private Boolean _preProvisioningRequiredField = null;
    private Boolean _extractGroupsEnabledField = null;
    private String _groupsClaimField = null;
    private String _responseTypeField = null;
    private String _responseModeField = null;
    private Boolean _useNonceField = null;
    private Long _readTimeoutField = null;
    private Boolean _extractJwtAccessTokenClaimsField = null;
    private String _preferredJwsAlgorithmField = null;
    private String _preferredJwsAlgorithm2Field = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Enabled = SCHEMA.getField("enabled");
    private static final RecordDataSchema.Field FIELD_ClientId = SCHEMA.getField("clientId");
    private static final RecordDataSchema.Field FIELD_ClientSecret = SCHEMA.getField("clientSecret");
    private static final RecordDataSchema.Field FIELD_DiscoveryUri = SCHEMA.getField("discoveryUri");
    private static final RecordDataSchema.Field FIELD_UserNameClaim = SCHEMA.getField("userNameClaim");
    private static final RecordDataSchema.Field FIELD_UserNameClaimRegex = SCHEMA.getField("userNameClaimRegex");
    private static final RecordDataSchema.Field FIELD_Scope = SCHEMA.getField("scope");
    private static final RecordDataSchema.Field FIELD_ClientAuthenticationMethod = SCHEMA.getField("clientAuthenticationMethod");
    private static final RecordDataSchema.Field FIELD_JitProvisioningEnabled = SCHEMA.getField("jitProvisioningEnabled");
    private static final RecordDataSchema.Field FIELD_PreProvisioningRequired = SCHEMA.getField("preProvisioningRequired");
    private static final RecordDataSchema.Field FIELD_ExtractGroupsEnabled = SCHEMA.getField("extractGroupsEnabled");
    private static final RecordDataSchema.Field FIELD_GroupsClaim = SCHEMA.getField("groupsClaim");
    private static final RecordDataSchema.Field FIELD_ResponseType = SCHEMA.getField("responseType");
    private static final RecordDataSchema.Field FIELD_ResponseMode = SCHEMA.getField("responseMode");
    private static final RecordDataSchema.Field FIELD_UseNonce = SCHEMA.getField("useNonce");
    private static final RecordDataSchema.Field FIELD_ReadTimeout = SCHEMA.getField("readTimeout");
    private static final RecordDataSchema.Field FIELD_ExtractJwtAccessTokenClaims = SCHEMA.getField("extractJwtAccessTokenClaims");
    private static final RecordDataSchema.Field FIELD_PreferredJwsAlgorithm = SCHEMA.getField("preferredJwsAlgorithm");
    private static final RecordDataSchema.Field FIELD_PreferredJwsAlgorithm2 = SCHEMA.getField("preferredJwsAlgorithm2");

    public OidcSettings() {
        super(new DataMap(), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public OidcSettings(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasEnabled() {
        if (this._enabledField != null) {
            return true;
        }
        return this._map.containsKey("enabled");
    }

    public void removeEnabled() {
        this._map.remove("enabled");
    }

    @Nullable
    public Boolean isEnabled(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isEnabled();
            }
            case DEFAULT: 
            case NULL: {
                if (this._enabledField != null) {
                    return this._enabledField;
                }
                Object __rawValue = this._map.get("enabled");
                this._enabledField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._enabledField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isEnabled() {
        if (this._enabledField != null) {
            return this._enabledField;
        }
        Object __rawValue = this._map.get("enabled");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("enabled");
        }
        this._enabledField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._enabledField;
    }

    public OidcSettings setEnabled(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEnabled(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field enabled of com.linkedin.settings.global.OidcSettings");
                }
                CheckedUtil.putWithoutChecking(this._map, "enabled", value);
                this._enabledField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEnabled();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "enabled", value);
                this._enabledField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "enabled", value);
                this._enabledField = value;
            }
        }
        return this;
    }

    public OidcSettings setEnabled(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field enabled of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "enabled", value);
        this._enabledField = value;
        return this;
    }

    public OidcSettings setEnabled(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "enabled", value);
        this._enabledField = value;
        return this;
    }

    public boolean hasClientId() {
        if (this._clientIdField != null) {
            return true;
        }
        return this._map.containsKey("clientId");
    }

    public void removeClientId() {
        this._map.remove("clientId");
    }

    @Nullable
    public String getClientId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getClientId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._clientIdField != null) {
                    return this._clientIdField;
                }
                Object __rawValue = this._map.get("clientId");
                this._clientIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._clientIdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getClientId() {
        if (this._clientIdField != null) {
            return this._clientIdField;
        }
        Object __rawValue = this._map.get("clientId");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("clientId");
        }
        this._clientIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._clientIdField;
    }

    public OidcSettings setClientId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setClientId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field clientId of com.linkedin.settings.global.OidcSettings");
                }
                CheckedUtil.putWithoutChecking(this._map, "clientId", value);
                this._clientIdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeClientId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "clientId", value);
                this._clientIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "clientId", value);
                this._clientIdField = value;
            }
        }
        return this;
    }

    public OidcSettings setClientId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field clientId of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "clientId", value);
        this._clientIdField = value;
        return this;
    }

    public boolean hasClientSecret() {
        if (this._clientSecretField != null) {
            return true;
        }
        return this._map.containsKey("clientSecret");
    }

    public void removeClientSecret() {
        this._map.remove("clientSecret");
    }

    @Nullable
    public String getClientSecret(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getClientSecret();
            }
            case DEFAULT: 
            case NULL: {
                if (this._clientSecretField != null) {
                    return this._clientSecretField;
                }
                Object __rawValue = this._map.get("clientSecret");
                this._clientSecretField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._clientSecretField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getClientSecret() {
        if (this._clientSecretField != null) {
            return this._clientSecretField;
        }
        Object __rawValue = this._map.get("clientSecret");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("clientSecret");
        }
        this._clientSecretField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._clientSecretField;
    }

    public OidcSettings setClientSecret(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setClientSecret(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field clientSecret of com.linkedin.settings.global.OidcSettings");
                }
                CheckedUtil.putWithoutChecking(this._map, "clientSecret", value);
                this._clientSecretField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeClientSecret();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "clientSecret", value);
                this._clientSecretField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "clientSecret", value);
                this._clientSecretField = value;
            }
        }
        return this;
    }

    public OidcSettings setClientSecret(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field clientSecret of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "clientSecret", value);
        this._clientSecretField = value;
        return this;
    }

    public boolean hasDiscoveryUri() {
        if (this._discoveryUriField != null) {
            return true;
        }
        return this._map.containsKey("discoveryUri");
    }

    public void removeDiscoveryUri() {
        this._map.remove("discoveryUri");
    }

    @Nullable
    public String getDiscoveryUri(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDiscoveryUri();
            }
            case DEFAULT: 
            case NULL: {
                if (this._discoveryUriField != null) {
                    return this._discoveryUriField;
                }
                Object __rawValue = this._map.get("discoveryUri");
                this._discoveryUriField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._discoveryUriField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getDiscoveryUri() {
        if (this._discoveryUriField != null) {
            return this._discoveryUriField;
        }
        Object __rawValue = this._map.get("discoveryUri");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("discoveryUri");
        }
        this._discoveryUriField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._discoveryUriField;
    }

    public OidcSettings setDiscoveryUri(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDiscoveryUri(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field discoveryUri of com.linkedin.settings.global.OidcSettings");
                }
                CheckedUtil.putWithoutChecking(this._map, "discoveryUri", value);
                this._discoveryUriField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDiscoveryUri();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "discoveryUri", value);
                this._discoveryUriField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "discoveryUri", value);
                this._discoveryUriField = value;
            }
        }
        return this;
    }

    public OidcSettings setDiscoveryUri(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field discoveryUri of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "discoveryUri", value);
        this._discoveryUriField = value;
        return this;
    }

    public boolean hasUserNameClaim() {
        if (this._userNameClaimField != null) {
            return true;
        }
        return this._map.containsKey("userNameClaim");
    }

    public void removeUserNameClaim() {
        this._map.remove("userNameClaim");
    }

    @Nullable
    public String getUserNameClaim(GetMode mode) {
        return this.getUserNameClaim();
    }

    @Nullable
    public String getUserNameClaim() {
        if (this._userNameClaimField != null) {
            return this._userNameClaimField;
        }
        Object __rawValue = this._map.get("userNameClaim");
        this._userNameClaimField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._userNameClaimField;
    }

    public OidcSettings setUserNameClaim(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUserNameClaim(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUserNameClaim();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "userNameClaim", value);
                this._userNameClaimField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "userNameClaim", value);
                this._userNameClaimField = value;
            }
        }
        return this;
    }

    public OidcSettings setUserNameClaim(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field userNameClaim of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "userNameClaim", value);
        this._userNameClaimField = value;
        return this;
    }

    public boolean hasUserNameClaimRegex() {
        if (this._userNameClaimRegexField != null) {
            return true;
        }
        return this._map.containsKey("userNameClaimRegex");
    }

    public void removeUserNameClaimRegex() {
        this._map.remove("userNameClaimRegex");
    }

    @Nullable
    public String getUserNameClaimRegex(GetMode mode) {
        return this.getUserNameClaimRegex();
    }

    @Nullable
    public String getUserNameClaimRegex() {
        if (this._userNameClaimRegexField != null) {
            return this._userNameClaimRegexField;
        }
        Object __rawValue = this._map.get("userNameClaimRegex");
        this._userNameClaimRegexField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._userNameClaimRegexField;
    }

    public OidcSettings setUserNameClaimRegex(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUserNameClaimRegex(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUserNameClaimRegex();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "userNameClaimRegex", value);
                this._userNameClaimRegexField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "userNameClaimRegex", value);
                this._userNameClaimRegexField = value;
            }
        }
        return this;
    }

    public OidcSettings setUserNameClaimRegex(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field userNameClaimRegex of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "userNameClaimRegex", value);
        this._userNameClaimRegexField = value;
        return this;
    }

    public boolean hasScope() {
        if (this._scopeField != null) {
            return true;
        }
        return this._map.containsKey("scope");
    }

    public void removeScope() {
        this._map.remove("scope");
    }

    @Nullable
    public String getScope(GetMode mode) {
        return this.getScope();
    }

    @Nullable
    public String getScope() {
        if (this._scopeField != null) {
            return this._scopeField;
        }
        Object __rawValue = this._map.get("scope");
        this._scopeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._scopeField;
    }

    public OidcSettings setScope(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setScope(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeScope();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "scope", value);
                this._scopeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "scope", value);
                this._scopeField = value;
            }
        }
        return this;
    }

    public OidcSettings setScope(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field scope of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "scope", value);
        this._scopeField = value;
        return this;
    }

    public boolean hasClientAuthenticationMethod() {
        if (this._clientAuthenticationMethodField != null) {
            return true;
        }
        return this._map.containsKey("clientAuthenticationMethod");
    }

    public void removeClientAuthenticationMethod() {
        this._map.remove("clientAuthenticationMethod");
    }

    @Nullable
    public String getClientAuthenticationMethod(GetMode mode) {
        return this.getClientAuthenticationMethod();
    }

    @Nullable
    public String getClientAuthenticationMethod() {
        if (this._clientAuthenticationMethodField != null) {
            return this._clientAuthenticationMethodField;
        }
        Object __rawValue = this._map.get("clientAuthenticationMethod");
        this._clientAuthenticationMethodField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._clientAuthenticationMethodField;
    }

    public OidcSettings setClientAuthenticationMethod(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setClientAuthenticationMethod(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeClientAuthenticationMethod();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "clientAuthenticationMethod", value);
                this._clientAuthenticationMethodField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "clientAuthenticationMethod", value);
                this._clientAuthenticationMethodField = value;
            }
        }
        return this;
    }

    public OidcSettings setClientAuthenticationMethod(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field clientAuthenticationMethod of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "clientAuthenticationMethod", value);
        this._clientAuthenticationMethodField = value;
        return this;
    }

    public boolean hasJitProvisioningEnabled() {
        if (this._jitProvisioningEnabledField != null) {
            return true;
        }
        return this._map.containsKey("jitProvisioningEnabled");
    }

    public void removeJitProvisioningEnabled() {
        this._map.remove("jitProvisioningEnabled");
    }

    @Nullable
    public Boolean isJitProvisioningEnabled(GetMode mode) {
        return this.isJitProvisioningEnabled();
    }

    @Nullable
    public Boolean isJitProvisioningEnabled() {
        if (this._jitProvisioningEnabledField != null) {
            return this._jitProvisioningEnabledField;
        }
        Object __rawValue = this._map.get("jitProvisioningEnabled");
        this._jitProvisioningEnabledField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._jitProvisioningEnabledField;
    }

    public OidcSettings setJitProvisioningEnabled(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setJitProvisioningEnabled(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeJitProvisioningEnabled();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "jitProvisioningEnabled", value);
                this._jitProvisioningEnabledField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "jitProvisioningEnabled", value);
                this._jitProvisioningEnabledField = value;
            }
        }
        return this;
    }

    public OidcSettings setJitProvisioningEnabled(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field jitProvisioningEnabled of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "jitProvisioningEnabled", value);
        this._jitProvisioningEnabledField = value;
        return this;
    }

    public OidcSettings setJitProvisioningEnabled(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "jitProvisioningEnabled", value);
        this._jitProvisioningEnabledField = value;
        return this;
    }

    public boolean hasPreProvisioningRequired() {
        if (this._preProvisioningRequiredField != null) {
            return true;
        }
        return this._map.containsKey("preProvisioningRequired");
    }

    public void removePreProvisioningRequired() {
        this._map.remove("preProvisioningRequired");
    }

    @Nullable
    public Boolean isPreProvisioningRequired(GetMode mode) {
        return this.isPreProvisioningRequired();
    }

    @Nullable
    public Boolean isPreProvisioningRequired() {
        if (this._preProvisioningRequiredField != null) {
            return this._preProvisioningRequiredField;
        }
        Object __rawValue = this._map.get("preProvisioningRequired");
        this._preProvisioningRequiredField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._preProvisioningRequiredField;
    }

    public OidcSettings setPreProvisioningRequired(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPreProvisioningRequired(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePreProvisioningRequired();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "preProvisioningRequired", value);
                this._preProvisioningRequiredField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "preProvisioningRequired", value);
                this._preProvisioningRequiredField = value;
            }
        }
        return this;
    }

    public OidcSettings setPreProvisioningRequired(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field preProvisioningRequired of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "preProvisioningRequired", value);
        this._preProvisioningRequiredField = value;
        return this;
    }

    public OidcSettings setPreProvisioningRequired(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "preProvisioningRequired", value);
        this._preProvisioningRequiredField = value;
        return this;
    }

    public boolean hasExtractGroupsEnabled() {
        if (this._extractGroupsEnabledField != null) {
            return true;
        }
        return this._map.containsKey("extractGroupsEnabled");
    }

    public void removeExtractGroupsEnabled() {
        this._map.remove("extractGroupsEnabled");
    }

    @Nullable
    public Boolean isExtractGroupsEnabled(GetMode mode) {
        return this.isExtractGroupsEnabled();
    }

    @Nullable
    public Boolean isExtractGroupsEnabled() {
        if (this._extractGroupsEnabledField != null) {
            return this._extractGroupsEnabledField;
        }
        Object __rawValue = this._map.get("extractGroupsEnabled");
        this._extractGroupsEnabledField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._extractGroupsEnabledField;
    }

    public OidcSettings setExtractGroupsEnabled(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExtractGroupsEnabled(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExtractGroupsEnabled();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "extractGroupsEnabled", value);
                this._extractGroupsEnabledField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "extractGroupsEnabled", value);
                this._extractGroupsEnabledField = value;
            }
        }
        return this;
    }

    public OidcSettings setExtractGroupsEnabled(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field extractGroupsEnabled of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "extractGroupsEnabled", value);
        this._extractGroupsEnabledField = value;
        return this;
    }

    public OidcSettings setExtractGroupsEnabled(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "extractGroupsEnabled", value);
        this._extractGroupsEnabledField = value;
        return this;
    }

    public boolean hasGroupsClaim() {
        if (this._groupsClaimField != null) {
            return true;
        }
        return this._map.containsKey("groupsClaim");
    }

    public void removeGroupsClaim() {
        this._map.remove("groupsClaim");
    }

    @Nullable
    public String getGroupsClaim(GetMode mode) {
        return this.getGroupsClaim();
    }

    @Nullable
    public String getGroupsClaim() {
        if (this._groupsClaimField != null) {
            return this._groupsClaimField;
        }
        Object __rawValue = this._map.get("groupsClaim");
        this._groupsClaimField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._groupsClaimField;
    }

    public OidcSettings setGroupsClaim(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGroupsClaim(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGroupsClaim();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "groupsClaim", value);
                this._groupsClaimField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "groupsClaim", value);
                this._groupsClaimField = value;
            }
        }
        return this;
    }

    public OidcSettings setGroupsClaim(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field groupsClaim of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "groupsClaim", value);
        this._groupsClaimField = value;
        return this;
    }

    public boolean hasResponseType() {
        if (this._responseTypeField != null) {
            return true;
        }
        return this._map.containsKey("responseType");
    }

    public void removeResponseType() {
        this._map.remove("responseType");
    }

    @Nullable
    public String getResponseType(GetMode mode) {
        return this.getResponseType();
    }

    @Nullable
    public String getResponseType() {
        if (this._responseTypeField != null) {
            return this._responseTypeField;
        }
        Object __rawValue = this._map.get("responseType");
        this._responseTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._responseTypeField;
    }

    public OidcSettings setResponseType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setResponseType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeResponseType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "responseType", value);
                this._responseTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "responseType", value);
                this._responseTypeField = value;
            }
        }
        return this;
    }

    public OidcSettings setResponseType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field responseType of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "responseType", value);
        this._responseTypeField = value;
        return this;
    }

    public boolean hasResponseMode() {
        if (this._responseModeField != null) {
            return true;
        }
        return this._map.containsKey("responseMode");
    }

    public void removeResponseMode() {
        this._map.remove("responseMode");
    }

    @Nullable
    public String getResponseMode(GetMode mode) {
        return this.getResponseMode();
    }

    @Nullable
    public String getResponseMode() {
        if (this._responseModeField != null) {
            return this._responseModeField;
        }
        Object __rawValue = this._map.get("responseMode");
        this._responseModeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._responseModeField;
    }

    public OidcSettings setResponseMode(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setResponseMode(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeResponseMode();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "responseMode", value);
                this._responseModeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "responseMode", value);
                this._responseModeField = value;
            }
        }
        return this;
    }

    public OidcSettings setResponseMode(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field responseMode of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "responseMode", value);
        this._responseModeField = value;
        return this;
    }

    public boolean hasUseNonce() {
        if (this._useNonceField != null) {
            return true;
        }
        return this._map.containsKey("useNonce");
    }

    public void removeUseNonce() {
        this._map.remove("useNonce");
    }

    @Nullable
    public Boolean isUseNonce(GetMode mode) {
        return this.isUseNonce();
    }

    @Nullable
    public Boolean isUseNonce() {
        if (this._useNonceField != null) {
            return this._useNonceField;
        }
        Object __rawValue = this._map.get("useNonce");
        this._useNonceField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._useNonceField;
    }

    public OidcSettings setUseNonce(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUseNonce(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUseNonce();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "useNonce", value);
                this._useNonceField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "useNonce", value);
                this._useNonceField = value;
            }
        }
        return this;
    }

    public OidcSettings setUseNonce(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field useNonce of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "useNonce", value);
        this._useNonceField = value;
        return this;
    }

    public OidcSettings setUseNonce(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "useNonce", value);
        this._useNonceField = value;
        return this;
    }

    public boolean hasReadTimeout() {
        if (this._readTimeoutField != null) {
            return true;
        }
        return this._map.containsKey("readTimeout");
    }

    public void removeReadTimeout() {
        this._map.remove("readTimeout");
    }

    @Nullable
    public Long getReadTimeout(GetMode mode) {
        return this.getReadTimeout();
    }

    @Nullable
    public Long getReadTimeout() {
        if (this._readTimeoutField != null) {
            return this._readTimeoutField;
        }
        Object __rawValue = this._map.get("readTimeout");
        this._readTimeoutField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._readTimeoutField;
    }

    public OidcSettings setReadTimeout(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setReadTimeout(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeReadTimeout();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "readTimeout", DataTemplateUtil.coerceLongInput(value));
                this._readTimeoutField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "readTimeout", DataTemplateUtil.coerceLongInput(value));
                this._readTimeoutField = value;
            }
        }
        return this;
    }

    public OidcSettings setReadTimeout(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field readTimeout of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "readTimeout", DataTemplateUtil.coerceLongInput(value));
        this._readTimeoutField = value;
        return this;
    }

    public OidcSettings setReadTimeout(long value) {
        CheckedUtil.putWithoutChecking(this._map, "readTimeout", DataTemplateUtil.coerceLongInput(value));
        this._readTimeoutField = value;
        return this;
    }

    public boolean hasExtractJwtAccessTokenClaims() {
        if (this._extractJwtAccessTokenClaimsField != null) {
            return true;
        }
        return this._map.containsKey("extractJwtAccessTokenClaims");
    }

    public void removeExtractJwtAccessTokenClaims() {
        this._map.remove("extractJwtAccessTokenClaims");
    }

    @Nullable
    public Boolean isExtractJwtAccessTokenClaims(GetMode mode) {
        return this.isExtractJwtAccessTokenClaims();
    }

    @Nullable
    public Boolean isExtractJwtAccessTokenClaims() {
        if (this._extractJwtAccessTokenClaimsField != null) {
            return this._extractJwtAccessTokenClaimsField;
        }
        Object __rawValue = this._map.get("extractJwtAccessTokenClaims");
        this._extractJwtAccessTokenClaimsField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._extractJwtAccessTokenClaimsField;
    }

    public OidcSettings setExtractJwtAccessTokenClaims(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExtractJwtAccessTokenClaims(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExtractJwtAccessTokenClaims();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "extractJwtAccessTokenClaims", value);
                this._extractJwtAccessTokenClaimsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "extractJwtAccessTokenClaims", value);
                this._extractJwtAccessTokenClaimsField = value;
            }
        }
        return this;
    }

    public OidcSettings setExtractJwtAccessTokenClaims(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field extractJwtAccessTokenClaims of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "extractJwtAccessTokenClaims", value);
        this._extractJwtAccessTokenClaimsField = value;
        return this;
    }

    public OidcSettings setExtractJwtAccessTokenClaims(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "extractJwtAccessTokenClaims", value);
        this._extractJwtAccessTokenClaimsField = value;
        return this;
    }

    public boolean hasPreferredJwsAlgorithm() {
        if (this._preferredJwsAlgorithmField != null) {
            return true;
        }
        return this._map.containsKey("preferredJwsAlgorithm");
    }

    public void removePreferredJwsAlgorithm() {
        this._map.remove("preferredJwsAlgorithm");
    }

    @Nullable
    public String getPreferredJwsAlgorithm(GetMode mode) {
        return this.getPreferredJwsAlgorithm();
    }

    @Nullable
    public String getPreferredJwsAlgorithm() {
        if (this._preferredJwsAlgorithmField != null) {
            return this._preferredJwsAlgorithmField;
        }
        Object __rawValue = this._map.get("preferredJwsAlgorithm");
        this._preferredJwsAlgorithmField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._preferredJwsAlgorithmField;
    }

    public OidcSettings setPreferredJwsAlgorithm(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPreferredJwsAlgorithm(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePreferredJwsAlgorithm();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "preferredJwsAlgorithm", value);
                this._preferredJwsAlgorithmField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "preferredJwsAlgorithm", value);
                this._preferredJwsAlgorithmField = value;
            }
        }
        return this;
    }

    public OidcSettings setPreferredJwsAlgorithm(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field preferredJwsAlgorithm of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "preferredJwsAlgorithm", value);
        this._preferredJwsAlgorithmField = value;
        return this;
    }

    public boolean hasPreferredJwsAlgorithm2() {
        if (this._preferredJwsAlgorithm2Field != null) {
            return true;
        }
        return this._map.containsKey("preferredJwsAlgorithm2");
    }

    public void removePreferredJwsAlgorithm2() {
        this._map.remove("preferredJwsAlgorithm2");
    }

    @Nullable
    public String getPreferredJwsAlgorithm2(GetMode mode) {
        return this.getPreferredJwsAlgorithm2();
    }

    @Nullable
    public String getPreferredJwsAlgorithm2() {
        if (this._preferredJwsAlgorithm2Field != null) {
            return this._preferredJwsAlgorithm2Field;
        }
        Object __rawValue = this._map.get("preferredJwsAlgorithm2");
        this._preferredJwsAlgorithm2Field = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._preferredJwsAlgorithm2Field;
    }

    public OidcSettings setPreferredJwsAlgorithm2(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPreferredJwsAlgorithm2(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePreferredJwsAlgorithm2();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "preferredJwsAlgorithm2", value);
                this._preferredJwsAlgorithm2Field = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "preferredJwsAlgorithm2", value);
                this._preferredJwsAlgorithm2Field = value;
            }
        }
        return this;
    }

    public OidcSettings setPreferredJwsAlgorithm2(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field preferredJwsAlgorithm2 of com.linkedin.settings.global.OidcSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "preferredJwsAlgorithm2", value);
        this._preferredJwsAlgorithm2Field = value;
        return this;
    }

    @Override
    public OidcSettings clone() throws CloneNotSupportedException {
        OidcSettings __clone = (OidcSettings)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public OidcSettings copy() throws CloneNotSupportedException {
        OidcSettings __copy = (OidcSettings)super.copy();
        __copy._responseModeField = null;
        __copy._clientIdField = null;
        __copy._jitProvisioningEnabledField = null;
        __copy._preProvisioningRequiredField = null;
        __copy._useNonceField = null;
        __copy._userNameClaimField = null;
        __copy._extractGroupsEnabledField = null;
        __copy._enabledField = null;
        __copy._groupsClaimField = null;
        __copy._responseTypeField = null;
        __copy._preferredJwsAlgorithmField = null;
        __copy._preferredJwsAlgorithm2Field = null;
        __copy._scopeField = null;
        __copy._readTimeoutField = null;
        __copy._clientSecretField = null;
        __copy._discoveryUriField = null;
        __copy._clientAuthenticationMethodField = null;
        __copy._extractJwtAccessTokenClaimsField = null;
        __copy._userNameClaimRegexField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final OidcSettings __objectRef;

        private ChangeListener(OidcSettings reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "responseMode": {
                    this.__objectRef._responseModeField = null;
                    break;
                }
                case "clientId": {
                    this.__objectRef._clientIdField = null;
                    break;
                }
                case "jitProvisioningEnabled": {
                    this.__objectRef._jitProvisioningEnabledField = null;
                    break;
                }
                case "preProvisioningRequired": {
                    this.__objectRef._preProvisioningRequiredField = null;
                    break;
                }
                case "useNonce": {
                    this.__objectRef._useNonceField = null;
                    break;
                }
                case "userNameClaim": {
                    this.__objectRef._userNameClaimField = null;
                    break;
                }
                case "extractGroupsEnabled": {
                    this.__objectRef._extractGroupsEnabledField = null;
                    break;
                }
                case "enabled": {
                    this.__objectRef._enabledField = null;
                    break;
                }
                case "groupsClaim": {
                    this.__objectRef._groupsClaimField = null;
                    break;
                }
                case "responseType": {
                    this.__objectRef._responseTypeField = null;
                    break;
                }
                case "preferredJwsAlgorithm": {
                    this.__objectRef._preferredJwsAlgorithmField = null;
                    break;
                }
                case "preferredJwsAlgorithm2": {
                    this.__objectRef._preferredJwsAlgorithm2Field = null;
                    break;
                }
                case "scope": {
                    this.__objectRef._scopeField = null;
                    break;
                }
                case "readTimeout": {
                    this.__objectRef._readTimeoutField = null;
                    break;
                }
                case "clientSecret": {
                    this.__objectRef._clientSecretField = null;
                    break;
                }
                case "discoveryUri": {
                    this.__objectRef._discoveryUriField = null;
                    break;
                }
                case "clientAuthenticationMethod": {
                    this.__objectRef._clientAuthenticationMethodField = null;
                    break;
                }
                case "extractJwtAccessTokenClaims": {
                    this.__objectRef._extractJwtAccessTokenClaimsField = null;
                    break;
                }
                case "userNameClaimRegex": {
                    this.__objectRef._userNameClaimRegexField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec enabled() {
            return new PathSpec(this.getPathComponents(), "enabled");
        }

        public PathSpec clientId() {
            return new PathSpec(this.getPathComponents(), "clientId");
        }

        public PathSpec clientSecret() {
            return new PathSpec(this.getPathComponents(), "clientSecret");
        }

        public PathSpec discoveryUri() {
            return new PathSpec(this.getPathComponents(), "discoveryUri");
        }

        public PathSpec userNameClaim() {
            return new PathSpec(this.getPathComponents(), "userNameClaim");
        }

        public PathSpec userNameClaimRegex() {
            return new PathSpec(this.getPathComponents(), "userNameClaimRegex");
        }

        public PathSpec scope() {
            return new PathSpec(this.getPathComponents(), "scope");
        }

        public PathSpec clientAuthenticationMethod() {
            return new PathSpec(this.getPathComponents(), "clientAuthenticationMethod");
        }

        public PathSpec jitProvisioningEnabled() {
            return new PathSpec(this.getPathComponents(), "jitProvisioningEnabled");
        }

        public PathSpec preProvisioningRequired() {
            return new PathSpec(this.getPathComponents(), "preProvisioningRequired");
        }

        public PathSpec extractGroupsEnabled() {
            return new PathSpec(this.getPathComponents(), "extractGroupsEnabled");
        }

        public PathSpec groupsClaim() {
            return new PathSpec(this.getPathComponents(), "groupsClaim");
        }

        public PathSpec responseType() {
            return new PathSpec(this.getPathComponents(), "responseType");
        }

        public PathSpec responseMode() {
            return new PathSpec(this.getPathComponents(), "responseMode");
        }

        public PathSpec useNonce() {
            return new PathSpec(this.getPathComponents(), "useNonce");
        }

        public PathSpec readTimeout() {
            return new PathSpec(this.getPathComponents(), "readTimeout");
        }

        public PathSpec extractJwtAccessTokenClaims() {
            return new PathSpec(this.getPathComponents(), "extractJwtAccessTokenClaims");
        }

        public PathSpec preferredJwsAlgorithm() {
            return new PathSpec(this.getPathComponents(), "preferredJwsAlgorithm");
        }

        public PathSpec preferredJwsAlgorithm2() {
            return new PathSpec(this.getPathComponents(), "preferredJwsAlgorithm2");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
        }

        public ProjectionMask withEnabled() {
            this.getDataMap().put("enabled", 1);
            return this;
        }

        public ProjectionMask withClientId() {
            this.getDataMap().put("clientId", 1);
            return this;
        }

        public ProjectionMask withClientSecret() {
            this.getDataMap().put("clientSecret", 1);
            return this;
        }

        public ProjectionMask withDiscoveryUri() {
            this.getDataMap().put("discoveryUri", 1);
            return this;
        }

        public ProjectionMask withUserNameClaim() {
            this.getDataMap().put("userNameClaim", 1);
            return this;
        }

        public ProjectionMask withUserNameClaimRegex() {
            this.getDataMap().put("userNameClaimRegex", 1);
            return this;
        }

        public ProjectionMask withScope() {
            this.getDataMap().put("scope", 1);
            return this;
        }

        public ProjectionMask withClientAuthenticationMethod() {
            this.getDataMap().put("clientAuthenticationMethod", 1);
            return this;
        }

        public ProjectionMask withJitProvisioningEnabled() {
            this.getDataMap().put("jitProvisioningEnabled", 1);
            return this;
        }

        public ProjectionMask withPreProvisioningRequired() {
            this.getDataMap().put("preProvisioningRequired", 1);
            return this;
        }

        public ProjectionMask withExtractGroupsEnabled() {
            this.getDataMap().put("extractGroupsEnabled", 1);
            return this;
        }

        public ProjectionMask withGroupsClaim() {
            this.getDataMap().put("groupsClaim", 1);
            return this;
        }

        public ProjectionMask withResponseType() {
            this.getDataMap().put("responseType", 1);
            return this;
        }

        public ProjectionMask withResponseMode() {
            this.getDataMap().put("responseMode", 1);
            return this;
        }

        public ProjectionMask withUseNonce() {
            this.getDataMap().put("useNonce", 1);
            return this;
        }

        public ProjectionMask withReadTimeout() {
            this.getDataMap().put("readTimeout", 1);
            return this;
        }

        public ProjectionMask withExtractJwtAccessTokenClaims() {
            this.getDataMap().put("extractJwtAccessTokenClaims", 1);
            return this;
        }

        public ProjectionMask withPreferredJwsAlgorithm() {
            this.getDataMap().put("preferredJwsAlgorithm", 1);
            return this;
        }

        public ProjectionMask withPreferredJwsAlgorithm2() {
            this.getDataMap().put("preferredJwsAlgorithm2", 1);
            return this;
        }
    }
}

