/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.schema;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.GlobalTags;
import com.linkedin.common.GlossaryTerms;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.schema.SchemaFieldDataType;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SchemaField
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.schema/**SchemaField to describe metadata related to dataset schema.*/record SchemaField{/**Flattened name of the field. Field is computed from jsonPath field.*/@Searchable={\"boostScore\":1.0,\"fieldName\":\"fieldPaths\",\"fieldType\":\"TEXT\",\"queryByDefault\":\"true\"}fieldPath:{namespace com.linkedin.dataset/**Schema field path. TODO: Add formal documentation on normalization rules.*/typeref SchemaFieldPath=string}/**Flattened name of a field in JSON Path notation.*/@Deprecated,jsonPath:optional string/**Indicates if this field is optional or nullable*/nullable:boolean=false/**Description*/@Searchable={\"boostScore\":0.1,\"fieldName\":\"fieldDescriptions\",\"fieldType\":\"TEXT\"}description:optional string/**Label of the field. Provides a more human-readable name for the field than field path. Some sources will\nprovide this metadata but not all sources have the concept of a label. If just one string is associated with\na field in a source, that is most likely a description.\n\nNote that this field is deprecated and is not surfaced in the UI.*/@Deprecated@Searchable={\"boostScore\":0.2,\"fieldName\":\"fieldLabels\",\"fieldType\":\"TEXT\"}label:optional string/**An AuditStamp corresponding to the creation of this schema field.*/created:optional{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}/**An AuditStamp corresponding to the last modification of this schema field.*/lastModified:optional com.linkedin.common.AuditStamp/**Platform independent field type of the field.*/type:/**Schema field data types*/record SchemaFieldDataType{/**Data platform specific types*/type:union[/**Boolean field type.*/record BooleanType{}/**Fixed field type.*/record FixedType{}/**String field type.*/record StringType{}/**Bytes field type.*/record BytesType{}/**Number data type: long, integer, short, etc..*/record NumberType{}/**Date field type.*/record DateType{}/**Time field type. This should also be used for datetimes.*/record TimeType{}/**Enum field type.*/record EnumType{}/**Null field type.*/record NullType{}/**Map field type.*/record MapType{/**Key type in a map*/keyType:optional string/**Type of the value in a map*/valueType:optional string}/**Array field type.*/record ArrayType{/**List of types this array holds.*/nestedType:optional array[string]}/**Union field type.*/record UnionType{/**List of types in union type.*/nestedTypes:optional array[string]}/**Record field type.*/record RecordType{}]}/**The native type of the field in the dataset's platform as declared by platform schema.*/nativeDataType:string/**There are use cases when a field in type B references type A. A field in A references field of type B. In such cases, we will mark the first field as recursive.*/recursive:boolean=false/**Tags associated with the field*/@Relationship.`/tags/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"SchemaFieldTaggedWith\"}@Searchable={\"/tags/*/attribution/actor\":{\"fieldName\":\"fieldTagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/tags/*/attribution/source\":{\"fieldName\":\"fieldTagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/tags/*/attribution/time\":{\"fieldName\":\"fieldTagAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false},\"/tags/*/tag\":{\"boostScore\":0.5,\"fieldName\":\"fieldTags\",\"fieldType\":\"URN\"}}globalTags:optional{namespace com.linkedin.common/**Tag aspect used for applying tags to an entity*/@Aspect.name=\"globalTags\"record GlobalTags{/**Tags associated with a given entity*/@Relationship.`/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"TaggedWith\"}@Searchable.`/*/tag`={\"addToFilters\":true,\"boostScore\":0.5,\"fieldName\":\"tags\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Tag\",\"hasValuesFieldName\":\"hasTags\",\"queryByDefault\":true}tags:array[/**Properties of an applied tag. For now, just an Urn. In the future we can extend this with other properties, e.g.\npropagation parameters.*/record TagAssociation{/**Urn of the applied tag*/tag:/**Globally defined tag*/@java.class=\"com.linkedin.common.urn.TagUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Globally defined tags\",\"entityType\":\"tag\",\"fields\":[{\"doc\":\"tag name\",\"maxLength\":200,\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":220,\"name\":\"Tag\",\"namespace\":\"li\",\"owners\":[],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref TagUrn=string/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"tagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"tagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"tagAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:Time/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}]}}/**Glossary terms associated with the field*/@Relationship.`/terms/*/urn`={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"SchemaFieldWithGlossaryTerm\"}@Searchable={\"/terms/*/attribution/actor\":{\"fieldName\":\"fieldTermAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/terms/*/attribution/source\":{\"fieldName\":\"fieldTermAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/terms/*/attribution/time\":{\"fieldName\":\"fieldTermAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false},\"/terms/*/urn\":{\"boostScore\":0.5,\"fieldName\":\"fieldGlossaryTerms\",\"fieldType\":\"URN\"}}glossaryTerms:optional{namespace com.linkedin.common/**Related business terms information*/@Aspect.name=\"glossaryTerms\"record GlossaryTerms{/**The related business terms*/terms:array[/**Properties of an applied glossary term.*/record GlossaryTermAssociation{/**Urn of the applied glossary term*/@Relationship={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"TermedWith\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"glossaryTerms\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Glossary Term\",\"hasValuesFieldName\":\"hasGlossaryTerms\",\"includeSystemModifiedAt\":true,\"systemModifiedAtFieldName\":\"termsModifiedAt\"}urn:/**Business Term*/@java.class=\"com.linkedin.common.urn.GlossaryTermUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"business term\",\"entityType\":\"glossaryTerm\",\"fields\":[{\"doc\":\"The name of business term with hierarchy.\",\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":56,\"name\":\"GlossaryTerm\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref GlossaryTermUrn=string/**The user URN which will be credited for adding associating this term to the entity*/actor:optional Urn/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"termAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"termAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"termAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional MetadataAttribution}]/**Audit stamp containing who reported the related business term*/auditStamp:AuditStamp}}/**For schema fields that are part of complex keys, set this field to true\nWe do this to easily distinguish between value and key fields*/isPartOfKey:boolean=false/**For Datasets which are partitioned, this determines the partitioning key.\nNote that multiple columns can be part of a partitioning key, but currently we do not support\nrendering the ordered partitioning key.*/isPartitioningKey:optional boolean/**For schema fields that have other properties that are not modeled explicitly,\nuse this field to serialize those properties into a JSON string*/jsonProps:optional string}", SchemaFormatType.PDL);
    private String _fieldPathField = null;
    private String _jsonPathField = null;
    private Boolean _nullableField = null;
    private String _descriptionField = null;
    private String _labelField = null;
    private AuditStamp _createdField = null;
    private AuditStamp _lastModifiedField = null;
    private SchemaFieldDataType _typeField = null;
    private String _nativeDataTypeField = null;
    private Boolean _recursiveField = null;
    private GlobalTags _globalTagsField = null;
    private GlossaryTerms _glossaryTermsField = null;
    private Boolean _isPartOfKeyField = null;
    private Boolean _isPartitioningKeyField = null;
    private String _jsonPropsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_FieldPath = SCHEMA.getField("fieldPath");
    private static final RecordDataSchema.Field FIELD_JsonPath = SCHEMA.getField("jsonPath");
    private static final RecordDataSchema.Field FIELD_Nullable = SCHEMA.getField("nullable");
    private static final Boolean DEFAULT_Nullable;
    private static final RecordDataSchema.Field FIELD_Description;
    private static final RecordDataSchema.Field FIELD_Label;
    private static final RecordDataSchema.Field FIELD_Created;
    private static final RecordDataSchema.Field FIELD_LastModified;
    private static final RecordDataSchema.Field FIELD_Type;
    private static final RecordDataSchema.Field FIELD_NativeDataType;
    private static final RecordDataSchema.Field FIELD_Recursive;
    private static final Boolean DEFAULT_Recursive;
    private static final RecordDataSchema.Field FIELD_GlobalTags;
    private static final RecordDataSchema.Field FIELD_GlossaryTerms;
    private static final RecordDataSchema.Field FIELD_IsPartOfKey;
    private static final Boolean DEFAULT_IsPartOfKey;
    private static final RecordDataSchema.Field FIELD_IsPartitioningKey;
    private static final RecordDataSchema.Field FIELD_JsonProps;

    public SchemaField() {
        super(new DataMap(), SCHEMA, 7);
        this.addChangeListener(this.__changeListener);
    }

    public SchemaField(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasFieldPath() {
        if (this._fieldPathField != null) {
            return true;
        }
        return this._map.containsKey("fieldPath");
    }

    public void removeFieldPath() {
        this._map.remove("fieldPath");
    }

    @Nullable
    public String getFieldPath(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getFieldPath();
            }
            case DEFAULT: 
            case NULL: {
                if (this._fieldPathField != null) {
                    return this._fieldPathField;
                }
                Object __rawValue = this._map.get("fieldPath");
                this._fieldPathField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._fieldPathField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getFieldPath() {
        if (this._fieldPathField != null) {
            return this._fieldPathField;
        }
        Object __rawValue = this._map.get("fieldPath");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("fieldPath");
        }
        this._fieldPathField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._fieldPathField;
    }

    public SchemaField setFieldPath(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFieldPath(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field fieldPath of com.linkedin.schema.SchemaField");
                }
                CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
                this._fieldPathField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFieldPath();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
                this._fieldPathField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
                this._fieldPathField = value;
            }
        }
        return this;
    }

    public SchemaField setFieldPath(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fieldPath of com.linkedin.schema.SchemaField to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
        this._fieldPathField = value;
        return this;
    }

    public boolean hasJsonPath() {
        if (this._jsonPathField != null) {
            return true;
        }
        return this._map.containsKey("jsonPath");
    }

    public void removeJsonPath() {
        this._map.remove("jsonPath");
    }

    @Nullable
    public String getJsonPath(GetMode mode) {
        return this.getJsonPath();
    }

    @Nullable
    public String getJsonPath() {
        if (this._jsonPathField != null) {
            return this._jsonPathField;
        }
        Object __rawValue = this._map.get("jsonPath");
        this._jsonPathField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._jsonPathField;
    }

    public SchemaField setJsonPath(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setJsonPath(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeJsonPath();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "jsonPath", value);
                this._jsonPathField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "jsonPath", value);
                this._jsonPathField = value;
            }
        }
        return this;
    }

    public SchemaField setJsonPath(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field jsonPath of com.linkedin.schema.SchemaField to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "jsonPath", value);
        this._jsonPathField = value;
        return this;
    }

    public boolean hasNullable() {
        if (this._nullableField != null) {
            return true;
        }
        return this._map.containsKey("nullable");
    }

    public void removeNullable() {
        this._map.remove("nullable");
    }

    @Nullable
    public Boolean isNullable(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isNullable();
            }
            case NULL: {
                if (this._nullableField != null) {
                    return this._nullableField;
                }
                Object __rawValue = this._map.get("nullable");
                this._nullableField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._nullableField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isNullable() {
        if (this._nullableField != null) {
            return this._nullableField;
        }
        Object __rawValue = this._map.get("nullable");
        if (__rawValue == null) {
            return DEFAULT_Nullable;
        }
        this._nullableField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._nullableField;
    }

    public SchemaField setNullable(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNullable(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field nullable of com.linkedin.schema.SchemaField");
                }
                CheckedUtil.putWithoutChecking(this._map, "nullable", value);
                this._nullableField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNullable();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "nullable", value);
                this._nullableField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "nullable", value);
                this._nullableField = value;
            }
        }
        return this;
    }

    public SchemaField setNullable(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field nullable of com.linkedin.schema.SchemaField to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "nullable", value);
        this._nullableField = value;
        return this;
    }

    public SchemaField setNullable(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "nullable", value);
        this._nullableField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public SchemaField setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public SchemaField setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.schema.SchemaField to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasLabel() {
        if (this._labelField != null) {
            return true;
        }
        return this._map.containsKey("label");
    }

    public void removeLabel() {
        this._map.remove("label");
    }

    @Nullable
    public String getLabel(GetMode mode) {
        return this.getLabel();
    }

    @Nullable
    public String getLabel() {
        if (this._labelField != null) {
            return this._labelField;
        }
        Object __rawValue = this._map.get("label");
        this._labelField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._labelField;
    }

    public SchemaField setLabel(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLabel(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLabel();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "label", value);
                this._labelField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "label", value);
                this._labelField = value;
            }
        }
        return this;
    }

    public SchemaField setLabel(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field label of com.linkedin.schema.SchemaField to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "label", value);
        this._labelField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        return this.getCreated();
    }

    @Nullable
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public SchemaField setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public SchemaField setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.schema.SchemaField to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public AuditStamp getLastModified(GetMode mode) {
        return this.getLastModified();
    }

    @Nullable
    public AuditStamp getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public SchemaField setLastModified(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public SchemaField setLastModified(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.schema.SchemaField to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public SchemaFieldDataType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = __rawValue == null ? null : new SchemaFieldDataType(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public SchemaFieldDataType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = __rawValue == null ? null : new SchemaFieldDataType(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._typeField;
    }

    public SchemaField setType(@Nullable SchemaFieldDataType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.schema.SchemaField");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.data());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.data());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.data());
                this._typeField = value;
            }
        }
        return this;
    }

    public SchemaField setType(@Nonnull SchemaFieldDataType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.schema.SchemaField to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.data());
        this._typeField = value;
        return this;
    }

    public boolean hasNativeDataType() {
        if (this._nativeDataTypeField != null) {
            return true;
        }
        return this._map.containsKey("nativeDataType");
    }

    public void removeNativeDataType() {
        this._map.remove("nativeDataType");
    }

    @Nullable
    public String getNativeDataType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getNativeDataType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nativeDataTypeField != null) {
                    return this._nativeDataTypeField;
                }
                Object __rawValue = this._map.get("nativeDataType");
                this._nativeDataTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nativeDataTypeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getNativeDataType() {
        if (this._nativeDataTypeField != null) {
            return this._nativeDataTypeField;
        }
        Object __rawValue = this._map.get("nativeDataType");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("nativeDataType");
        }
        this._nativeDataTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nativeDataTypeField;
    }

    public SchemaField setNativeDataType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNativeDataType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field nativeDataType of com.linkedin.schema.SchemaField");
                }
                CheckedUtil.putWithoutChecking(this._map, "nativeDataType", value);
                this._nativeDataTypeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNativeDataType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "nativeDataType", value);
                this._nativeDataTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "nativeDataType", value);
                this._nativeDataTypeField = value;
            }
        }
        return this;
    }

    public SchemaField setNativeDataType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field nativeDataType of com.linkedin.schema.SchemaField to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "nativeDataType", value);
        this._nativeDataTypeField = value;
        return this;
    }

    public boolean hasRecursive() {
        if (this._recursiveField != null) {
            return true;
        }
        return this._map.containsKey("recursive");
    }

    public void removeRecursive() {
        this._map.remove("recursive");
    }

    @Nullable
    public Boolean isRecursive(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isRecursive();
            }
            case NULL: {
                if (this._recursiveField != null) {
                    return this._recursiveField;
                }
                Object __rawValue = this._map.get("recursive");
                this._recursiveField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._recursiveField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isRecursive() {
        if (this._recursiveField != null) {
            return this._recursiveField;
        }
        Object __rawValue = this._map.get("recursive");
        if (__rawValue == null) {
            return DEFAULT_Recursive;
        }
        this._recursiveField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._recursiveField;
    }

    public SchemaField setRecursive(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRecursive(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field recursive of com.linkedin.schema.SchemaField");
                }
                CheckedUtil.putWithoutChecking(this._map, "recursive", value);
                this._recursiveField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRecursive();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "recursive", value);
                this._recursiveField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "recursive", value);
                this._recursiveField = value;
            }
        }
        return this;
    }

    public SchemaField setRecursive(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field recursive of com.linkedin.schema.SchemaField to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "recursive", value);
        this._recursiveField = value;
        return this;
    }

    public SchemaField setRecursive(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "recursive", value);
        this._recursiveField = value;
        return this;
    }

    public boolean hasGlobalTags() {
        if (this._globalTagsField != null) {
            return true;
        }
        return this._map.containsKey("globalTags");
    }

    public void removeGlobalTags() {
        this._map.remove("globalTags");
    }

    @Nullable
    public GlobalTags getGlobalTags(GetMode mode) {
        return this.getGlobalTags();
    }

    @Nullable
    public GlobalTags getGlobalTags() {
        if (this._globalTagsField != null) {
            return this._globalTagsField;
        }
        Object __rawValue = this._map.get("globalTags");
        this._globalTagsField = __rawValue == null ? null : new GlobalTags(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._globalTagsField;
    }

    public SchemaField setGlobalTags(@Nullable GlobalTags value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGlobalTags(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGlobalTags();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "globalTags", value.data());
                this._globalTagsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "globalTags", value.data());
                this._globalTagsField = value;
            }
        }
        return this;
    }

    public SchemaField setGlobalTags(@Nonnull GlobalTags value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field globalTags of com.linkedin.schema.SchemaField to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "globalTags", value.data());
        this._globalTagsField = value;
        return this;
    }

    public boolean hasGlossaryTerms() {
        if (this._glossaryTermsField != null) {
            return true;
        }
        return this._map.containsKey("glossaryTerms");
    }

    public void removeGlossaryTerms() {
        this._map.remove("glossaryTerms");
    }

    @Nullable
    public GlossaryTerms getGlossaryTerms(GetMode mode) {
        return this.getGlossaryTerms();
    }

    @Nullable
    public GlossaryTerms getGlossaryTerms() {
        if (this._glossaryTermsField != null) {
            return this._glossaryTermsField;
        }
        Object __rawValue = this._map.get("glossaryTerms");
        this._glossaryTermsField = __rawValue == null ? null : new GlossaryTerms(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._glossaryTermsField;
    }

    public SchemaField setGlossaryTerms(@Nullable GlossaryTerms value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGlossaryTerms(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGlossaryTerms();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "glossaryTerms", value.data());
                this._glossaryTermsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "glossaryTerms", value.data());
                this._glossaryTermsField = value;
            }
        }
        return this;
    }

    public SchemaField setGlossaryTerms(@Nonnull GlossaryTerms value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field glossaryTerms of com.linkedin.schema.SchemaField to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "glossaryTerms", value.data());
        this._glossaryTermsField = value;
        return this;
    }

    public boolean hasIsPartOfKey() {
        if (this._isPartOfKeyField != null) {
            return true;
        }
        return this._map.containsKey("isPartOfKey");
    }

    public void removeIsPartOfKey() {
        this._map.remove("isPartOfKey");
    }

    @Nullable
    public Boolean isIsPartOfKey(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isIsPartOfKey();
            }
            case NULL: {
                if (this._isPartOfKeyField != null) {
                    return this._isPartOfKeyField;
                }
                Object __rawValue = this._map.get("isPartOfKey");
                this._isPartOfKeyField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._isPartOfKeyField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isIsPartOfKey() {
        if (this._isPartOfKeyField != null) {
            return this._isPartOfKeyField;
        }
        Object __rawValue = this._map.get("isPartOfKey");
        if (__rawValue == null) {
            return DEFAULT_IsPartOfKey;
        }
        this._isPartOfKeyField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._isPartOfKeyField;
    }

    public SchemaField setIsPartOfKey(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIsPartOfKey(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field isPartOfKey of com.linkedin.schema.SchemaField");
                }
                CheckedUtil.putWithoutChecking(this._map, "isPartOfKey", value);
                this._isPartOfKeyField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIsPartOfKey();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "isPartOfKey", value);
                this._isPartOfKeyField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "isPartOfKey", value);
                this._isPartOfKeyField = value;
            }
        }
        return this;
    }

    public SchemaField setIsPartOfKey(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field isPartOfKey of com.linkedin.schema.SchemaField to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "isPartOfKey", value);
        this._isPartOfKeyField = value;
        return this;
    }

    public SchemaField setIsPartOfKey(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "isPartOfKey", value);
        this._isPartOfKeyField = value;
        return this;
    }

    public boolean hasIsPartitioningKey() {
        if (this._isPartitioningKeyField != null) {
            return true;
        }
        return this._map.containsKey("isPartitioningKey");
    }

    public void removeIsPartitioningKey() {
        this._map.remove("isPartitioningKey");
    }

    @Nullable
    public Boolean isIsPartitioningKey(GetMode mode) {
        return this.isIsPartitioningKey();
    }

    @Nullable
    public Boolean isIsPartitioningKey() {
        if (this._isPartitioningKeyField != null) {
            return this._isPartitioningKeyField;
        }
        Object __rawValue = this._map.get("isPartitioningKey");
        this._isPartitioningKeyField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._isPartitioningKeyField;
    }

    public SchemaField setIsPartitioningKey(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIsPartitioningKey(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIsPartitioningKey();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "isPartitioningKey", value);
                this._isPartitioningKeyField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "isPartitioningKey", value);
                this._isPartitioningKeyField = value;
            }
        }
        return this;
    }

    public SchemaField setIsPartitioningKey(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field isPartitioningKey of com.linkedin.schema.SchemaField to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "isPartitioningKey", value);
        this._isPartitioningKeyField = value;
        return this;
    }

    public SchemaField setIsPartitioningKey(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "isPartitioningKey", value);
        this._isPartitioningKeyField = value;
        return this;
    }

    public boolean hasJsonProps() {
        if (this._jsonPropsField != null) {
            return true;
        }
        return this._map.containsKey("jsonProps");
    }

    public void removeJsonProps() {
        this._map.remove("jsonProps");
    }

    @Nullable
    public String getJsonProps(GetMode mode) {
        return this.getJsonProps();
    }

    @Nullable
    public String getJsonProps() {
        if (this._jsonPropsField != null) {
            return this._jsonPropsField;
        }
        Object __rawValue = this._map.get("jsonProps");
        this._jsonPropsField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._jsonPropsField;
    }

    public SchemaField setJsonProps(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setJsonProps(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeJsonProps();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "jsonProps", value);
                this._jsonPropsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "jsonProps", value);
                this._jsonPropsField = value;
            }
        }
        return this;
    }

    public SchemaField setJsonProps(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field jsonProps of com.linkedin.schema.SchemaField to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "jsonProps", value);
        this._jsonPropsField = value;
        return this;
    }

    @Override
    public SchemaField clone() throws CloneNotSupportedException {
        SchemaField __clone = (SchemaField)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public SchemaField copy() throws CloneNotSupportedException {
        SchemaField __copy = (SchemaField)super.copy();
        __copy._nullableField = null;
        __copy._createdField = null;
        __copy._descriptionField = null;
        __copy._jsonPathField = null;
        __copy._isPartOfKeyField = null;
        __copy._jsonPropsField = null;
        __copy._labelField = null;
        __copy._typeField = null;
        __copy._globalTagsField = null;
        __copy._nativeDataTypeField = null;
        __copy._recursiveField = null;
        __copy._fieldPathField = null;
        __copy._glossaryTermsField = null;
        __copy._lastModifiedField = null;
        __copy._isPartitioningKeyField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Description = SCHEMA.getField("description");
        FIELD_Label = SCHEMA.getField("label");
        FIELD_Created = SCHEMA.getField("created");
        FIELD_LastModified = SCHEMA.getField("lastModified");
        FIELD_Type = SCHEMA.getField("type");
        FIELD_NativeDataType = SCHEMA.getField("nativeDataType");
        FIELD_Recursive = SCHEMA.getField("recursive");
        FIELD_GlobalTags = SCHEMA.getField("globalTags");
        FIELD_GlossaryTerms = SCHEMA.getField("glossaryTerms");
        FIELD_IsPartOfKey = SCHEMA.getField("isPartOfKey");
        FIELD_IsPartitioningKey = SCHEMA.getField("isPartitioningKey");
        FIELD_JsonProps = SCHEMA.getField("jsonProps");
        DEFAULT_Nullable = DataTemplateUtil.coerceBooleanOutput(FIELD_Nullable.getDefault());
        DEFAULT_Recursive = DataTemplateUtil.coerceBooleanOutput(FIELD_Recursive.getDefault());
        DEFAULT_IsPartOfKey = DataTemplateUtil.coerceBooleanOutput(FIELD_IsPartOfKey.getDefault());
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final SchemaField __objectRef;

        private ChangeListener(SchemaField reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "nullable": {
                    this.__objectRef._nullableField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "jsonPath": {
                    this.__objectRef._jsonPathField = null;
                    break;
                }
                case "isPartOfKey": {
                    this.__objectRef._isPartOfKeyField = null;
                    break;
                }
                case "jsonProps": {
                    this.__objectRef._jsonPropsField = null;
                    break;
                }
                case "label": {
                    this.__objectRef._labelField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "globalTags": {
                    this.__objectRef._globalTagsField = null;
                    break;
                }
                case "nativeDataType": {
                    this.__objectRef._nativeDataTypeField = null;
                    break;
                }
                case "recursive": {
                    this.__objectRef._recursiveField = null;
                    break;
                }
                case "fieldPath": {
                    this.__objectRef._fieldPathField = null;
                    break;
                }
                case "glossaryTerms": {
                    this.__objectRef._glossaryTermsField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                    break;
                }
                case "isPartitioningKey": {
                    this.__objectRef._isPartitioningKeyField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec fieldPath() {
            return new PathSpec(this.getPathComponents(), "fieldPath");
        }

        public PathSpec jsonPath() {
            return new PathSpec(this.getPathComponents(), "jsonPath");
        }

        public PathSpec nullable() {
            return new PathSpec(this.getPathComponents(), "nullable");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public PathSpec label() {
            return new PathSpec(this.getPathComponents(), "label");
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }

        public AuditStamp.Fields lastModified() {
            return new AuditStamp.Fields(this.getPathComponents(), "lastModified");
        }

        public SchemaFieldDataType.Fields type() {
            return new SchemaFieldDataType.Fields(this.getPathComponents(), "type");
        }

        public PathSpec nativeDataType() {
            return new PathSpec(this.getPathComponents(), "nativeDataType");
        }

        public PathSpec recursive() {
            return new PathSpec(this.getPathComponents(), "recursive");
        }

        public GlobalTags.Fields globalTags() {
            return new GlobalTags.Fields(this.getPathComponents(), "globalTags");
        }

        public GlossaryTerms.Fields glossaryTerms() {
            return new GlossaryTerms.Fields(this.getPathComponents(), "glossaryTerms");
        }

        public PathSpec isPartOfKey() {
            return new PathSpec(this.getPathComponents(), "isPartOfKey");
        }

        public PathSpec isPartitioningKey() {
            return new PathSpec(this.getPathComponents(), "isPartitioningKey");
        }

        public PathSpec jsonProps() {
            return new PathSpec(this.getPathComponents(), "jsonProps");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _createdMask;
        private AuditStamp.ProjectionMask _lastModifiedMask;
        private SchemaFieldDataType.ProjectionMask _typeMask;
        private GlobalTags.ProjectionMask _globalTagsMask;
        private GlossaryTerms.ProjectionMask _glossaryTermsMask;

        ProjectionMask() {
        }

        public ProjectionMask withFieldPath() {
            this.getDataMap().put("fieldPath", 1);
            return this;
        }

        public ProjectionMask withJsonPath() {
            this.getDataMap().put("jsonPath", 1);
            return this;
        }

        public ProjectionMask withNullable() {
            this.getDataMap().put("nullable", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withLabel() {
            this.getDataMap().put("label", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? AuditStamp.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }

        public ProjectionMask withType(Function<SchemaFieldDataType.ProjectionMask, SchemaFieldDataType.ProjectionMask> nestedMask) {
            this._typeMask = nestedMask.apply(this._typeMask == null ? SchemaFieldDataType.createMask() : this._typeMask);
            this.getDataMap().put("type", this._typeMask.getDataMap());
            return this;
        }

        public ProjectionMask withType() {
            this._typeMask = null;
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withNativeDataType() {
            this.getDataMap().put("nativeDataType", 1);
            return this;
        }

        public ProjectionMask withRecursive() {
            this.getDataMap().put("recursive", 1);
            return this;
        }

        public ProjectionMask withGlobalTags(Function<GlobalTags.ProjectionMask, GlobalTags.ProjectionMask> nestedMask) {
            this._globalTagsMask = nestedMask.apply(this._globalTagsMask == null ? GlobalTags.createMask() : this._globalTagsMask);
            this.getDataMap().put("globalTags", this._globalTagsMask.getDataMap());
            return this;
        }

        public ProjectionMask withGlobalTags() {
            this._globalTagsMask = null;
            this.getDataMap().put("globalTags", 1);
            return this;
        }

        public ProjectionMask withGlossaryTerms(Function<GlossaryTerms.ProjectionMask, GlossaryTerms.ProjectionMask> nestedMask) {
            this._glossaryTermsMask = nestedMask.apply(this._glossaryTermsMask == null ? GlossaryTerms.createMask() : this._glossaryTermsMask);
            this.getDataMap().put("glossaryTerms", this._glossaryTermsMask.getDataMap());
            return this;
        }

        public ProjectionMask withGlossaryTerms() {
            this._glossaryTermsMask = null;
            this.getDataMap().put("glossaryTerms", 1);
            return this;
        }

        public ProjectionMask withIsPartOfKey() {
            this.getDataMap().put("isPartOfKey", 1);
            return this;
        }

        public ProjectionMask withIsPartitioningKey() {
            this.getDataMap().put("isPartitioningKey", 1);
            return this;
        }

        public ProjectionMask withJsonProps() {
            this.getDataMap().put("jsonProps", 1);
            return this;
        }
    }
}

