/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.query;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.query.QuerySubjectArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class QuerySubjects
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.query/**Information about the subjects of a particular Query, i.e. the assets\nbeing queried.*/@Aspect.name=\"querySubjects\"record QuerySubjects{/**One or more subjects of the query.\n\nIn single-asset queries (e.g. table select), this will contain the Table reference\nand optionally schema field references.\n\nIn multi-asset queries (e.g. table joins), this may contain multiple Table references\nand optionally schema field references.*/subjects:array[/**A single subject of a particular query.\nIn the future, we may evolve this model to include richer details\nabout the Query Subject in relation to the query.*/record QuerySubject{/**An entity which is the subject of a query.*/@Searchable={\"fieldName\":\"entities\",\"fieldType\":\"URN\"}entity:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}]}", SchemaFormatType.PDL);
    private QuerySubjectArray _subjectsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Subjects = SCHEMA.getField("subjects");

    public QuerySubjects() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public QuerySubjects(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasSubjects() {
        if (this._subjectsField != null) {
            return true;
        }
        return this._map.containsKey("subjects");
    }

    public void removeSubjects() {
        this._map.remove("subjects");
    }

    @Nullable
    public QuerySubjectArray getSubjects(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSubjects();
            }
            case DEFAULT: 
            case NULL: {
                if (this._subjectsField != null) {
                    return this._subjectsField;
                }
                Object __rawValue = this._map.get("subjects");
                this._subjectsField = __rawValue == null ? null : new QuerySubjectArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._subjectsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public QuerySubjectArray getSubjects() {
        if (this._subjectsField != null) {
            return this._subjectsField;
        }
        Object __rawValue = this._map.get("subjects");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("subjects");
        }
        this._subjectsField = __rawValue == null ? null : new QuerySubjectArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._subjectsField;
    }

    public QuerySubjects setSubjects(@Nullable QuerySubjectArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSubjects(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field subjects of com.linkedin.query.QuerySubjects");
                }
                CheckedUtil.putWithoutChecking(this._map, "subjects", value.data());
                this._subjectsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSubjects();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "subjects", value.data());
                this._subjectsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "subjects", value.data());
                this._subjectsField = value;
            }
        }
        return this;
    }

    public QuerySubjects setSubjects(@Nonnull QuerySubjectArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field subjects of com.linkedin.query.QuerySubjects to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "subjects", value.data());
        this._subjectsField = value;
        return this;
    }

    @Override
    public QuerySubjects clone() throws CloneNotSupportedException {
        QuerySubjects __clone = (QuerySubjects)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public QuerySubjects copy() throws CloneNotSupportedException {
        QuerySubjects __copy = (QuerySubjects)super.copy();
        __copy._subjectsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final QuerySubjects __objectRef;

        private ChangeListener(QuerySubjects reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "subjects": {
                    this.__objectRef._subjectsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public QuerySubjectArray.Fields subjects() {
            return new QuerySubjectArray.Fields(this.getPathComponents(), "subjects");
        }

        public PathSpec subjects(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "subjects");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private QuerySubjectArray.ProjectionMask _subjectsMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withSubjects(Function<QuerySubjectArray.ProjectionMask, QuerySubjectArray.ProjectionMask> nestedMask) {
            this._subjectsMask = nestedMask.apply(this._subjectsMask == null ? QuerySubjectArray.createMask() : this._subjectsMask);
            this.getDataMap().put("subjects", this._subjectsMask.getDataMap());
            return this;
        }

        public ProjectionMask withSubjects() {
            this._subjectsMask = null;
            this.getDataMap().put("subjects", 1);
            return this;
        }

        public ProjectionMask withSubjects(Function<QuerySubjectArray.ProjectionMask, QuerySubjectArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._subjectsMask = nestedMask.apply(this._subjectsMask == null ? QuerySubjectArray.createMask() : this._subjectsMask);
            this.getDataMap().put("subjects", this._subjectsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("subjects").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("subjects").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withSubjects(Integer start, Integer count) {
            this._subjectsMask = null;
            this.getDataMap().put("subjects", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("subjects").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("subjects").put("$count", count);
            }
            return this;
        }
    }
}

