/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.policy;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.policy.PolicyMatchCondition;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PolicyMatchCriterion
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.policy/**A criterion for matching a field with given value*/record PolicyMatchCriterion{/**The name of the field that the criterion refers to*/field:string/**Values. Matches criterion if any one of the values matches condition (OR-relationship)*/values:array[string]/**The condition for the criterion*/condition:/**The matching condition in a filter criterion*/enum PolicyMatchCondition{/**Whether the field matches the value*/EQUALS/**Whether the field value starts with the value*/STARTS_WITH/**Whether the field does not match the value*/NOT_EQUALS}=\"EQUALS\"}", SchemaFormatType.PDL);
    private String _fieldField = null;
    private StringArray _valuesField = null;
    private PolicyMatchCondition _conditionField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Field = SCHEMA.getField("field");
    private static final RecordDataSchema.Field FIELD_Values = SCHEMA.getField("values");
    private static final RecordDataSchema.Field FIELD_Condition = SCHEMA.getField("condition");
    private static final PolicyMatchCondition DEFAULT_Condition = DataTemplateUtil.coerceEnumOutput(FIELD_Condition.getDefault(), PolicyMatchCondition.class, PolicyMatchCondition.$UNKNOWN);

    public PolicyMatchCriterion() {
        super(new DataMap(4, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public PolicyMatchCriterion(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasField() {
        if (this._fieldField != null) {
            return true;
        }
        return this._map.containsKey("field");
    }

    public void removeField() {
        this._map.remove("field");
    }

    @Nullable
    public String getField(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getField();
            }
            case DEFAULT: 
            case NULL: {
                if (this._fieldField != null) {
                    return this._fieldField;
                }
                Object __rawValue = this._map.get("field");
                this._fieldField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._fieldField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getField() {
        if (this._fieldField != null) {
            return this._fieldField;
        }
        Object __rawValue = this._map.get("field");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("field");
        }
        this._fieldField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._fieldField;
    }

    public PolicyMatchCriterion setField(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setField(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field field of com.linkedin.policy.PolicyMatchCriterion");
                }
                CheckedUtil.putWithoutChecking(this._map, "field", value);
                this._fieldField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeField();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "field", value);
                this._fieldField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "field", value);
                this._fieldField = value;
            }
        }
        return this;
    }

    public PolicyMatchCriterion setField(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field field of com.linkedin.policy.PolicyMatchCriterion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "field", value);
        this._fieldField = value;
        return this;
    }

    public boolean hasValues() {
        if (this._valuesField != null) {
            return true;
        }
        return this._map.containsKey("values");
    }

    public void removeValues() {
        this._map.remove("values");
    }

    @Nullable
    public StringArray getValues(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getValues();
            }
            case DEFAULT: 
            case NULL: {
                if (this._valuesField != null) {
                    return this._valuesField;
                }
                Object __rawValue = this._map.get("values");
                this._valuesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._valuesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringArray getValues() {
        if (this._valuesField != null) {
            return this._valuesField;
        }
        Object __rawValue = this._map.get("values");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("values");
        }
        this._valuesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._valuesField;
    }

    public PolicyMatchCriterion setValues(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setValues(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field values of com.linkedin.policy.PolicyMatchCriterion");
                }
                CheckedUtil.putWithoutChecking(this._map, "values", value.data());
                this._valuesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeValues();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "values", value.data());
                this._valuesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "values", value.data());
                this._valuesField = value;
            }
        }
        return this;
    }

    public PolicyMatchCriterion setValues(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field values of com.linkedin.policy.PolicyMatchCriterion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "values", value.data());
        this._valuesField = value;
        return this;
    }

    public boolean hasCondition() {
        if (this._conditionField != null) {
            return true;
        }
        return this._map.containsKey("condition");
    }

    public void removeCondition() {
        this._map.remove("condition");
    }

    @Nullable
    public PolicyMatchCondition getCondition(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCondition();
            }
            case NULL: {
                if (this._conditionField != null) {
                    return this._conditionField;
                }
                Object __rawValue = this._map.get("condition");
                this._conditionField = DataTemplateUtil.coerceEnumOutput(__rawValue, PolicyMatchCondition.class, PolicyMatchCondition.$UNKNOWN);
                return this._conditionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public PolicyMatchCondition getCondition() {
        if (this._conditionField != null) {
            return this._conditionField;
        }
        Object __rawValue = this._map.get("condition");
        if (__rawValue == null) {
            return DEFAULT_Condition;
        }
        this._conditionField = DataTemplateUtil.coerceEnumOutput(__rawValue, PolicyMatchCondition.class, PolicyMatchCondition.$UNKNOWN);
        return this._conditionField;
    }

    public PolicyMatchCriterion setCondition(@Nullable PolicyMatchCondition value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCondition(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field condition of com.linkedin.policy.PolicyMatchCriterion");
                }
                CheckedUtil.putWithoutChecking(this._map, "condition", value.name());
                this._conditionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCondition();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "condition", value.name());
                this._conditionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "condition", value.name());
                this._conditionField = value;
            }
        }
        return this;
    }

    public PolicyMatchCriterion setCondition(@Nonnull PolicyMatchCondition value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field condition of com.linkedin.policy.PolicyMatchCriterion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "condition", value.name());
        this._conditionField = value;
        return this;
    }

    @Override
    public PolicyMatchCriterion clone() throws CloneNotSupportedException {
        PolicyMatchCriterion __clone = (PolicyMatchCriterion)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public PolicyMatchCriterion copy() throws CloneNotSupportedException {
        PolicyMatchCriterion __copy = (PolicyMatchCriterion)super.copy();
        __copy._conditionField = null;
        __copy._fieldField = null;
        __copy._valuesField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final PolicyMatchCriterion __objectRef;

        private ChangeListener(PolicyMatchCriterion reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "condition": {
                    this.__objectRef._conditionField = null;
                    break;
                }
                case "field": {
                    this.__objectRef._fieldField = null;
                    break;
                }
                case "values": {
                    this.__objectRef._valuesField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec field() {
            return new PathSpec(this.getPathComponents(), "field");
        }

        public PathSpec values() {
            return new PathSpec(this.getPathComponents(), "values");
        }

        public PathSpec values(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "values");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec condition() {
            return new PathSpec(this.getPathComponents(), "condition");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withField() {
            this.getDataMap().put("field", 1);
            return this;
        }

        public ProjectionMask withValues() {
            this.getDataMap().put("values", 1);
            return this;
        }

        public ProjectionMask withValues(Integer start, Integer count) {
            this.getDataMap().put("values", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("values").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("values").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withCondition() {
            this.getDataMap().put("condition", 1);
            return this;
        }
    }
}

