/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.ml.metadata.BaseDataArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TrainingData
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**Ideally, the MLModel card would contain as much information about the training data as the evaluation data. However, there might be cases where it is not feasible to provide this level of detailed information about the training data. For example, the data may be proprietary, or require a non-disclosure agreement. In these cases, we advocate for basic details about the distributions over groups in the data, as well as any other details that could inform stakeholders on the kinds of biases the model may have encoded.*/@Aspect.name=\"mlModelTrainingData\"record TrainingData{/**Details on the dataset(s) used for training the MLModel*/trainingData:array[/**BaseData record*/record BaseData{/**What dataset were used in the MLModel?*/dataset:{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}/**Why was this dataset chosen?*/motivation:optional string/**How was the data preprocessed (e.g., tokenization of sentences, cropping of images, any filtering such as dropping images without faces)?*/preProcessing:optional array[string]}]}", SchemaFormatType.PDL);
    private BaseDataArray _trainingDataField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_TrainingData = SCHEMA.getField("trainingData");

    public TrainingData() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public TrainingData(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTrainingData() {
        if (this._trainingDataField != null) {
            return true;
        }
        return this._map.containsKey("trainingData");
    }

    public void removeTrainingData() {
        this._map.remove("trainingData");
    }

    @Nullable
    public BaseDataArray getTrainingData(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTrainingData();
            }
            case DEFAULT: 
            case NULL: {
                if (this._trainingDataField != null) {
                    return this._trainingDataField;
                }
                Object __rawValue = this._map.get("trainingData");
                this._trainingDataField = __rawValue == null ? null : new BaseDataArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._trainingDataField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public BaseDataArray getTrainingData() {
        if (this._trainingDataField != null) {
            return this._trainingDataField;
        }
        Object __rawValue = this._map.get("trainingData");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("trainingData");
        }
        this._trainingDataField = __rawValue == null ? null : new BaseDataArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._trainingDataField;
    }

    public TrainingData setTrainingData(@Nullable BaseDataArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTrainingData(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field trainingData of com.linkedin.ml.metadata.TrainingData");
                }
                CheckedUtil.putWithoutChecking(this._map, "trainingData", value.data());
                this._trainingDataField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTrainingData();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "trainingData", value.data());
                this._trainingDataField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "trainingData", value.data());
                this._trainingDataField = value;
            }
        }
        return this;
    }

    public TrainingData setTrainingData(@Nonnull BaseDataArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field trainingData of com.linkedin.ml.metadata.TrainingData to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "trainingData", value.data());
        this._trainingDataField = value;
        return this;
    }

    @Override
    public TrainingData clone() throws CloneNotSupportedException {
        TrainingData __clone = (TrainingData)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public TrainingData copy() throws CloneNotSupportedException {
        TrainingData __copy = (TrainingData)super.copy();
        __copy._trainingDataField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final TrainingData __objectRef;

        private ChangeListener(TrainingData reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "trainingData": {
                    this.__objectRef._trainingDataField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public BaseDataArray.Fields trainingData() {
            return new BaseDataArray.Fields(this.getPathComponents(), "trainingData");
        }

        public PathSpec trainingData(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "trainingData");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private BaseDataArray.ProjectionMask _trainingDataMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withTrainingData(Function<BaseDataArray.ProjectionMask, BaseDataArray.ProjectionMask> nestedMask) {
            this._trainingDataMask = nestedMask.apply(this._trainingDataMask == null ? BaseDataArray.createMask() : this._trainingDataMask);
            this.getDataMap().put("trainingData", this._trainingDataMask.getDataMap());
            return this;
        }

        public ProjectionMask withTrainingData() {
            this._trainingDataMask = null;
            this.getDataMap().put("trainingData", 1);
            return this;
        }

        public ProjectionMask withTrainingData(Function<BaseDataArray.ProjectionMask, BaseDataArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._trainingDataMask = nestedMask.apply(this._trainingDataMask == null ? BaseDataArray.createMask() : this._trainingDataMask);
            this.getDataMap().put("trainingData", this._trainingDataMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("trainingData").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("trainingData").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withTrainingData(Integer start, Integer count) {
            this._trainingDataMask = null;
            this.getDataMap().put("trainingData", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("trainingData").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("trainingData").put("$count", count);
            }
            return this;
        }
    }
}

