/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.ml.metadata.ResultsType;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class QuantitativeAnalyses
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**Quantitative analyses should be disaggregated, that is, broken down by the chosen factors. Quantitative analyses should provide the results of evaluating the MLModel according to the chosen metrics, providing confidence interval values when possible.*/@Aspect.name=\"mlModelQuantitativeAnalyses\"record QuantitativeAnalyses{/**Link to a dashboard with results showing how the MLModel performed with respect to each factor*/unitaryResults:optional/**A union of all supported metadata aspects for ResultsType*/typeref ResultsType=union[string]/**Link to a dashboard with results showing how the MLModel performed with respect to the intersection of evaluated factors?*/intersectionalResults:optional ResultsType}", SchemaFormatType.PDL);
    private ResultsType _unitaryResultsField = null;
    private ResultsType _intersectionalResultsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_UnitaryResults = SCHEMA.getField("unitaryResults");
    private static final RecordDataSchema.Field FIELD_IntersectionalResults = SCHEMA.getField("intersectionalResults");

    public QuantitativeAnalyses() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public QuantitativeAnalyses(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUnitaryResults() {
        if (this._unitaryResultsField != null) {
            return true;
        }
        return this._map.containsKey("unitaryResults");
    }

    public void removeUnitaryResults() {
        this._map.remove("unitaryResults");
    }

    @Nullable
    public ResultsType getUnitaryResults(GetMode mode) {
        return this.getUnitaryResults();
    }

    @Nullable
    public ResultsType getUnitaryResults() {
        if (this._unitaryResultsField != null) {
            return this._unitaryResultsField;
        }
        Object __rawValue = this._map.get("unitaryResults");
        this._unitaryResultsField = __rawValue == null ? null : new ResultsType(__rawValue);
        return this._unitaryResultsField;
    }

    public QuantitativeAnalyses setUnitaryResults(@Nullable ResultsType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUnitaryResults(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUnitaryResults();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "unitaryResults", value.data());
                this._unitaryResultsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "unitaryResults", value.data());
                this._unitaryResultsField = value;
            }
        }
        return this;
    }

    public QuantitativeAnalyses setUnitaryResults(@Nonnull ResultsType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field unitaryResults of com.linkedin.ml.metadata.QuantitativeAnalyses to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "unitaryResults", value.data());
        this._unitaryResultsField = value;
        return this;
    }

    public boolean hasIntersectionalResults() {
        if (this._intersectionalResultsField != null) {
            return true;
        }
        return this._map.containsKey("intersectionalResults");
    }

    public void removeIntersectionalResults() {
        this._map.remove("intersectionalResults");
    }

    @Nullable
    public ResultsType getIntersectionalResults(GetMode mode) {
        return this.getIntersectionalResults();
    }

    @Nullable
    public ResultsType getIntersectionalResults() {
        if (this._intersectionalResultsField != null) {
            return this._intersectionalResultsField;
        }
        Object __rawValue = this._map.get("intersectionalResults");
        this._intersectionalResultsField = __rawValue == null ? null : new ResultsType(__rawValue);
        return this._intersectionalResultsField;
    }

    public QuantitativeAnalyses setIntersectionalResults(@Nullable ResultsType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIntersectionalResults(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIntersectionalResults();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "intersectionalResults", value.data());
                this._intersectionalResultsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "intersectionalResults", value.data());
                this._intersectionalResultsField = value;
            }
        }
        return this;
    }

    public QuantitativeAnalyses setIntersectionalResults(@Nonnull ResultsType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field intersectionalResults of com.linkedin.ml.metadata.QuantitativeAnalyses to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "intersectionalResults", value.data());
        this._intersectionalResultsField = value;
        return this;
    }

    @Override
    public QuantitativeAnalyses clone() throws CloneNotSupportedException {
        QuantitativeAnalyses __clone = (QuantitativeAnalyses)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public QuantitativeAnalyses copy() throws CloneNotSupportedException {
        QuantitativeAnalyses __copy = (QuantitativeAnalyses)super.copy();
        __copy._unitaryResultsField = null;
        __copy._intersectionalResultsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final QuantitativeAnalyses __objectRef;

        private ChangeListener(QuantitativeAnalyses reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "unitaryResults": {
                    this.__objectRef._unitaryResultsField = null;
                    break;
                }
                case "intersectionalResults": {
                    this.__objectRef._intersectionalResultsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public ResultsType.Fields unitaryResults() {
            return new ResultsType.Fields(this.getPathComponents(), "unitaryResults");
        }

        public ResultsType.Fields intersectionalResults() {
            return new ResultsType.Fields(this.getPathComponents(), "intersectionalResults");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private ResultsType.ProjectionMask _unitaryResultsMask;
        private ResultsType.ProjectionMask _intersectionalResultsMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withUnitaryResults(Function<ResultsType.ProjectionMask, ResultsType.ProjectionMask> nestedMask) {
            this._unitaryResultsMask = nestedMask.apply(this._unitaryResultsMask == null ? ResultsType.createMask() : this._unitaryResultsMask);
            this.getDataMap().put("unitaryResults", this._unitaryResultsMask.getDataMap());
            return this;
        }

        public ProjectionMask withUnitaryResults() {
            this._unitaryResultsMask = null;
            this.getDataMap().put("unitaryResults", 1);
            return this;
        }

        public ProjectionMask withIntersectionalResults(Function<ResultsType.ProjectionMask, ResultsType.ProjectionMask> nestedMask) {
            this._intersectionalResultsMask = nestedMask.apply(this._intersectionalResultsMask == null ? ResultsType.createMask() : this._intersectionalResultsMask);
            this.getDataMap().put("intersectionalResults", this._intersectionalResultsMask.getDataMap());
            return this;
        }

        public ProjectionMask withIntersectionalResults() {
            this._intersectionalResultsMask = null;
            this.getDataMap().put("intersectionalResults", 1);
            return this;
        }
    }
}

