/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.common.UrnArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MLFeatureTableProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**Properties associated with a MLFeatureTable*/@Aspect.name=\"mlFeatureTableProperties\"record MLFeatureTableProperties includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{/**Documentation of the MLFeatureTable*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\"}description:optional string/**List of features contained in the feature table*/@Relationship.`/*`={\"entityTypes\":[\"mlFeature\"],\"name\":\"Contains\"}@Searchable.`/*`={\"fieldName\":\"features\",\"fieldType\":\"URN\"}mlFeatures:optional array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**List of primary keys in the feature table (if multiple, assumed to act as a composite key)*/@Relationship.`/*`={\"entityTypes\":[\"mlPrimaryKey\"],\"name\":\"KeyedBy\"}@Searchable.`/*`={\"fieldName\":\"primaryKeys\",\"fieldType\":\"URN\"}mlPrimaryKeys:optional array[com.linkedin.common.Urn]}", SchemaFormatType.PDL);
    private StringMap _customPropertiesField = null;
    private String _descriptionField = null;
    private UrnArray _mlFeaturesField = null;
    private UrnArray _mlPrimaryKeysField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CustomProperties = SCHEMA.getField("customProperties");
    private static final StringMap DEFAULT_CustomProperties;
    private static final RecordDataSchema.Field FIELD_Description;
    private static final RecordDataSchema.Field FIELD_MlFeatures;
    private static final RecordDataSchema.Field FIELD_MlPrimaryKeys;

    public MLFeatureTableProperties() {
        super(new DataMap(6, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public MLFeatureTableProperties(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCustomProperties();
            }
            case NULL: {
                if (this._customPropertiesField != null) {
                    return this._customPropertiesField;
                }
                Object __rawValue = this._map.get("customProperties");
                this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._customPropertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        if (__rawValue == null) {
            return DEFAULT_CustomProperties;
        }
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public MLFeatureTableProperties setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field customProperties of com.linkedin.ml.metadata.MLFeatureTableProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public MLFeatureTableProperties setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.ml.metadata.MLFeatureTableProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public MLFeatureTableProperties setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public MLFeatureTableProperties setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.ml.metadata.MLFeatureTableProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasMlFeatures() {
        if (this._mlFeaturesField != null) {
            return true;
        }
        return this._map.containsKey("mlFeatures");
    }

    public void removeMlFeatures() {
        this._map.remove("mlFeatures");
    }

    @Nullable
    public UrnArray getMlFeatures(GetMode mode) {
        return this.getMlFeatures();
    }

    @Nullable
    public UrnArray getMlFeatures() {
        if (this._mlFeaturesField != null) {
            return this._mlFeaturesField;
        }
        Object __rawValue = this._map.get("mlFeatures");
        this._mlFeaturesField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._mlFeaturesField;
    }

    public MLFeatureTableProperties setMlFeatures(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMlFeatures(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMlFeatures();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "mlFeatures", value.data());
                this._mlFeaturesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "mlFeatures", value.data());
                this._mlFeaturesField = value;
            }
        }
        return this;
    }

    public MLFeatureTableProperties setMlFeatures(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field mlFeatures of com.linkedin.ml.metadata.MLFeatureTableProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "mlFeatures", value.data());
        this._mlFeaturesField = value;
        return this;
    }

    public boolean hasMlPrimaryKeys() {
        if (this._mlPrimaryKeysField != null) {
            return true;
        }
        return this._map.containsKey("mlPrimaryKeys");
    }

    public void removeMlPrimaryKeys() {
        this._map.remove("mlPrimaryKeys");
    }

    @Nullable
    public UrnArray getMlPrimaryKeys(GetMode mode) {
        return this.getMlPrimaryKeys();
    }

    @Nullable
    public UrnArray getMlPrimaryKeys() {
        if (this._mlPrimaryKeysField != null) {
            return this._mlPrimaryKeysField;
        }
        Object __rawValue = this._map.get("mlPrimaryKeys");
        this._mlPrimaryKeysField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._mlPrimaryKeysField;
    }

    public MLFeatureTableProperties setMlPrimaryKeys(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMlPrimaryKeys(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMlPrimaryKeys();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "mlPrimaryKeys", value.data());
                this._mlPrimaryKeysField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "mlPrimaryKeys", value.data());
                this._mlPrimaryKeysField = value;
            }
        }
        return this;
    }

    public MLFeatureTableProperties setMlPrimaryKeys(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field mlPrimaryKeys of com.linkedin.ml.metadata.MLFeatureTableProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "mlPrimaryKeys", value.data());
        this._mlPrimaryKeysField = value;
        return this;
    }

    @Override
    public MLFeatureTableProperties clone() throws CloneNotSupportedException {
        MLFeatureTableProperties __clone = (MLFeatureTableProperties)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public MLFeatureTableProperties copy() throws CloneNotSupportedException {
        MLFeatureTableProperties __copy = (MLFeatureTableProperties)super.copy();
        __copy._customPropertiesField = null;
        __copy._mlFeaturesField = null;
        __copy._descriptionField = null;
        __copy._mlPrimaryKeysField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Description = SCHEMA.getField("description");
        FIELD_MlFeatures = SCHEMA.getField("mlFeatures");
        FIELD_MlPrimaryKeys = SCHEMA.getField("mlPrimaryKeys");
        DEFAULT_CustomProperties = FIELD_CustomProperties.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_CustomProperties.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final MLFeatureTableProperties __objectRef;

        private ChangeListener(MLFeatureTableProperties reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "mlFeatures": {
                    this.__objectRef._mlFeaturesField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "mlPrimaryKeys": {
                    this.__objectRef._mlPrimaryKeysField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public PathSpec mlFeatures() {
            return new PathSpec(this.getPathComponents(), "mlFeatures");
        }

        public PathSpec mlFeatures(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "mlFeatures");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec mlPrimaryKeys() {
            return new PathSpec(this.getPathComponents(), "mlPrimaryKeys");
        }

        public PathSpec mlPrimaryKeys(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "mlPrimaryKeys");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withMlFeatures() {
            this.getDataMap().put("mlFeatures", 1);
            return this;
        }

        public ProjectionMask withMlFeatures(Integer start, Integer count) {
            this.getDataMap().put("mlFeatures", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("mlFeatures").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("mlFeatures").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withMlPrimaryKeys() {
            this.getDataMap().put("mlPrimaryKeys", 1);
            return this;
        }

        public ProjectionMask withMlPrimaryKeys(Integer start, Integer count) {
            this.getDataMap().put("mlPrimaryKeys", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("mlPrimaryKeys").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("mlPrimaryKeys").put("$count", count);
            }
            return this;
        }
    }
}

