/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils.metrics;

import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.AtomicDouble;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricUtils.class);
    public static final String DROPWIZARD_METRIC = "dwizMetric";
    public static final String DROPWIZARD_NAME = "dwizName";
    public static final String KAFKA_MESSAGE_QUEUE_TIME = "kafka.message.queue.time";
    public static final String DATAHUB_REQUEST_HOOK_QUEUE_TIME = "datahub.request.hook.queue.time";
    public static final String CACHE_HIT_ATTR = "cache.hit";
    public static final String BATCH_SIZE_ATTR = "batch.size";
    public static final String QUEUE_ENQUEUED_AT_ATTR = "queue.enqueued_at";
    public static final String QUEUE_DURATION_MS_ATTR = "queue.duration_ms";
    public static final String MESSAGING_SYSTEM = "messaging.system";
    public static final String MESSAGING_DESTINATION = "messaging.destination";
    public static final String MESSAGING_DESTINATION_KIND = "messaging.destination_kind";
    public static final String MESSAGING_OPERATION = "messaging.operation";
    public static final String ERROR_TYPE = "error.type";
    public static final String CHANGE_TYPE = "aspect.change_type";
    public static final String ENTITY_TYPE = "aspect.entity_type";
    public static final String ASPECT_NAME = "aspect.name";
    @Deprecated
    public static final String DELIMITER = "_";
    private final MeterRegistry registry;
    private static final Map<String, Timer> legacyTimeCache = new ConcurrentHashMap<String, Timer>();
    private static final Map<String, Counter> legacyCounterCache = new ConcurrentHashMap<String, Counter>();
    private static final Map<String, DistributionSummary> legacyHistogramCache = new ConcurrentHashMap<String, DistributionSummary>();
    private static final Map<String, Gauge> legacyGaugeCache = new ConcurrentHashMap<String, Gauge>();
    private static final Map<String, AtomicDouble> gaugeStates = new ConcurrentHashMap<String, AtomicDouble>();

    public Optional<MeterRegistry> getRegistry() {
        return Optional.ofNullable(this.registry);
    }

    @Deprecated
    public void time(String dropWizardMetricName, long durationNanos) {
        this.getRegistry().ifPresent(meterRegistry -> {
            Timer timer = legacyTimeCache.computeIfAbsent(dropWizardMetricName, name -> Timer.builder((String)name).tags(new String[]{DROPWIZARD_METRIC, "true"}).register(meterRegistry));
            timer.record(durationNanos, TimeUnit.NANOSECONDS);
        });
    }

    @Deprecated
    public void increment(Class<?> klass, String metricName, double increment) {
        String name = MetricRegistry.name(klass, (String[])new String[]{metricName});
        this.increment(name, increment);
    }

    @Deprecated
    public void exceptionIncrement(Class<?> klass, String metricName, Throwable t2) {
        String[] splitClassName = t2.getClass().getName().split("[.]");
        String snakeCase = splitClassName[splitClassName.length - 1].replaceAll("([A-Z][a-z])", "_$1");
        this.increment(klass, metricName, 1.0);
        this.increment(klass, metricName + DELIMITER + snakeCase, 1.0);
    }

    @Deprecated
    public void increment(String metricName, double increment) {
        this.getRegistry().ifPresent(meterRegistry -> {
            Counter counter = legacyCounterCache.computeIfAbsent(metricName, name -> Counter.builder((String)MetricRegistry.name((String)name, (String[])new String[0])).tag(DROPWIZARD_METRIC, "true").register(meterRegistry));
            counter.increment(increment);
        });
    }

    @Deprecated
    public void setGaugeValue(Class<?> clazz, String metricName, double value) {
        String name = MetricRegistry.name(clazz, (String[])new String[]{metricName});
        this.getRegistry().ifPresent(meterRegistry -> {
            AtomicDouble state = gaugeStates.computeIfAbsent(name, k -> new AtomicDouble(0.0));
            legacyGaugeCache.computeIfAbsent(name, key -> Gauge.builder((String)key, (Object)state, AtomicDouble::get).tag(DROPWIZARD_METRIC, "true").register(meterRegistry));
            state.set(value);
        });
    }

    @Deprecated
    public void histogram(Class<?> clazz, String metricName, long value) {
        this.getRegistry().ifPresent(meterRegistry -> {
            String name = MetricRegistry.name((Class)clazz, (String[])new String[]{metricName});
            DistributionSummary summary = legacyHistogramCache.computeIfAbsent(name, key -> DistributionSummary.builder((String)key).tag(DROPWIZARD_METRIC, "true").register(meterRegistry));
            summary.record((double)value);
        });
    }

    @Deprecated
    public static String name(String name, String ... names) {
        return MetricRegistry.name((String)name, (String[])names);
    }

    @Deprecated
    public static String name(Class<?> clazz, String ... names) {
        return MetricRegistry.name((String)clazz.getName(), (String[])names);
    }

    public static double[] parsePercentiles(String percentilesConfig) {
        if (percentilesConfig == null || percentilesConfig.trim().isEmpty()) {
            return new double[]{0.5, 0.95, 0.99};
        }
        return MetricUtils.commaDelimitedDoubles(percentilesConfig);
    }

    public static double[] parseSLOSeconds(String sloConfig) {
        if (sloConfig == null || sloConfig.trim().isEmpty()) {
            return new double[]{60.0, 300.0, 900.0, 1800.0, 3600.0};
        }
        return MetricUtils.commaDelimitedDoubles(sloConfig);
    }

    private static double[] commaDelimitedDoubles(String value) {
        String[] parts = value.split(",");
        double[] result = new double[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            result[i] = Double.parseDouble(parts[i].trim());
        }
        return result;
    }

    @Generated
    MetricUtils(MeterRegistry registry) {
        this.registry = registry;
    }

    @Generated
    public static MetricUtilsBuilder builder() {
        return new MetricUtilsBuilder();
    }

    @Generated
    public static class MetricUtilsBuilder {
        @Generated
        private MeterRegistry registry;

        @Generated
        MetricUtilsBuilder() {
        }

        @Generated
        public MetricUtilsBuilder registry(MeterRegistry registry) {
            this.registry = registry;
            return this;
        }

        @Generated
        public MetricUtils build() {
            return new MetricUtils(this.registry);
        }

        @Generated
        public String toString() {
            return "MetricUtils.MetricUtilsBuilder(registry=" + String.valueOf(this.registry) + ")";
        }
    }
}

