/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils.log;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.filter.AbstractMatcherFilter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.ArrayList;
import java.util.List;

public class LogMessageFilter
extends AbstractMatcherFilter<ILoggingEvent> {
    private final List<String> excluded = new ArrayList<String>();

    public FilterReply decide(ILoggingEvent event) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        String formattedMessage = event.getFormattedMessage();
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        String throwableString = throwableProxy != null ? ThrowableProxyUtil.asString((IThrowableProxy)throwableProxy) : null;
        if (this.excluded.stream().anyMatch(message -> formattedMessage.contains((CharSequence)message) || throwableString != null && throwableString.contains((CharSequence)message))) {
            return FilterReply.DENY;
        }
        return FilterReply.ACCEPT;
    }

    public void addExcluded(String message) {
        this.excluded.add(message);
    }
}

