/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.metadata.aspect.batch.BatchItem;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.UrnValidationFieldSpec;
import com.linkedin.metadata.models.annotation.UrnValidationAnnotation;
import com.linkedin.metadata.models.registry.EntityRegistry;
import com.linkedin.metadata.utils.EntityApiUtils;
import com.linkedin.metadata.utils.EntityRegistryUrnValidator;
import com.linkedin.metadata.utils.RecordTemplateValidator;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrnValidationUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UrnValidationUtil.class);
    public static final int URN_NUM_BYTES_LIMIT = 512;
    public static final String URN_DELIMITER_SEPARATOR = "\u241f";
    public static final Set<String> ILLEGAL_URN_CHARACTERS_PARENTHESES = Set.of("(", ")");
    public static final Set<String> ILLEGAL_URN_COMPONENT_DELIMITER = Set.of(",");

    private UrnValidationUtil() {
    }

    public static void validateUrn(@Nonnull EntityRegistry entityRegistry, @Nonnull Urn urn, boolean strict) {
        List<String> illegalComponents;
        String part;
        EntityRegistryUrnValidator validator = new EntityRegistryUrnValidator(entityRegistry);
        validator.setCurrentEntitySpec(entityRegistry.getEntitySpec(urn.getEntityType()));
        RecordTemplateValidator.validate(EntityApiUtils.buildKeyAspect(entityRegistry, urn), validationResult -> {
            throw new IllegalArgumentException("Invalid urn: " + String.valueOf(urn) + "\n Cause: " + String.valueOf(validationResult.getMessages()));
        }, validator);
        if (urn.toString().trim().length() != urn.toString().length()) {
            throw new IllegalArgumentException("Error: cannot provide an URN with leading or trailing whitespace");
        }
        if (!"schemaField".equals(urn.getEntityType()) && URLEncoder.encode(urn.toString()).length() > 512) {
            throw new IllegalArgumentException("Error: cannot provide an URN longer than " + Integer.toString(512) + " bytes (when URL encoded)");
        }
        if (urn.toString().contains(URN_DELIMITER_SEPARATOR)) {
            throw new IllegalArgumentException("Error: URN cannot contain \u241f character");
        }
        if (urn.getEntityKey().getParts().size() == 1 && (part = urn.getEntityKey().getParts().get(0)).contains(",")) {
            if (strict) {
                throw new IllegalArgumentException(String.format("Simple URN %s contains comma character which is not allowed in non-tuple URNs", urn));
            }
            log.error("Simple URN {} contains comma character which is not allowed in non-tuple URNs", (Object)urn);
        }
        if (!(illegalComponents = UrnValidationUtil.validateUrnComponents(urn)).isEmpty()) {
            String message = String.format("Illegal characters detected in URN %s component(s): %s", urn, illegalComponents);
            if (strict) {
                throw new IllegalArgumentException(message);
            }
            log.error(message);
        }
        try {
            Urn.createFromString(urn.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static List<String> validateUrnComponents(Urn urn) {
        int totalParts = urn.getEntityKey().getParts().size();
        return urn.getEntityKey().getParts().stream().flatMap(part -> UrnValidationUtil.processUrnPartRecursively(part, totalParts)).collect(Collectors.toList());
    }

    private static Stream<String> processUrnPartRecursively(String urnPart, int totalParts) {
        if (urnPart.startsWith("urn:li:")) {
            return Stream.empty();
        }
        if (urnPart.contains("%28") || urnPart.contains("%29")) {
            return Stream.empty();
        }
        if (ILLEGAL_URN_CHARACTERS_PARENTHESES.stream().anyMatch(c -> urnPart.contains((CharSequence)c))) {
            return Stream.of(urnPart);
        }
        if (totalParts > 1 && ILLEGAL_URN_COMPONENT_DELIMITER.stream().anyMatch(c -> urnPart.contains((CharSequence)c))) {
            return Stream.of(urnPart);
        }
        return Stream.empty();
    }

    @Nonnull
    public static <T extends BatchItem> Set<UrnValidationEntry> findUrnValidationFields(@Nonnull T item, @Nonnull AspectSpec aspectSpec) {
        HashSet<UrnValidationEntry> result = new HashSet<UrnValidationEntry>();
        Map<String, UrnValidationFieldSpec> urnValidationSpecs = aspectSpec.getUrnValidationFieldSpecMap();
        if (item.getRecordTemplate() != null && item.getRecordTemplate().data() != null) {
            UrnValidationUtil.traverseDataMap(item.getRecordTemplate().data(), "", urnValidationSpecs, result);
        }
        return result;
    }

    public static <T extends BatchItem> Map<T, Set<UrnValidationEntry>> findUrnValidationFields(@Nonnull Collection<T> items, @Nonnull AspectSpec aspectSpec) {
        HashMap<BatchItem, Set<UrnValidationEntry>> result = new HashMap<BatchItem, Set<UrnValidationEntry>>();
        for (BatchItem item : items) {
            if (item == null) continue;
            result.put(item, UrnValidationUtil.findUrnValidationFields(item, aspectSpec));
        }
        return result;
    }

    private static void traverseDataMap(DataMap dataMap, String currentPath, Map<String, UrnValidationFieldSpec> urnValidationSpecs, Set<UrnValidationEntry> result) {
        for (String key : dataMap.keySet()) {
            String fieldPath = currentPath.isEmpty() ? "/" + key : currentPath + "/" + key;
            Object value = dataMap.get(key);
            UrnValidationFieldSpec spec = urnValidationSpecs.get(fieldPath);
            if (spec != null) {
                if (value instanceof String) {
                    result.add(new UrnValidationEntry(fieldPath, (String)value, spec.getUrnValidationAnnotation()));
                } else if (value instanceof DataList) {
                    DataList list = (DataList)value;
                    for (Object item : list) {
                        if (!(item instanceof String)) continue;
                        result.add(new UrnValidationEntry(fieldPath, (String)item, spec.getUrnValidationAnnotation()));
                    }
                }
            }
            if (!(value instanceof DataMap)) continue;
            UrnValidationUtil.traverseDataMap((DataMap)value, fieldPath, urnValidationSpecs, result);
        }
    }

    public static final class UrnValidationEntry {
        private final String fieldPath;
        private final String urn;
        private final UrnValidationAnnotation annotation;

        @Generated
        public UrnValidationEntry(String fieldPath, String urn, UrnValidationAnnotation annotation) {
            this.fieldPath = fieldPath;
            this.urn = urn;
            this.annotation = annotation;
        }

        @Generated
        public String getFieldPath() {
            return this.fieldPath;
        }

        @Generated
        public String getUrn() {
            return this.urn;
        }

        @Generated
        public UrnValidationAnnotation getAnnotation() {
            return this.annotation;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UrnValidationEntry)) {
                return false;
            }
            UrnValidationEntry other = (UrnValidationEntry)o;
            String this$fieldPath = this.getFieldPath();
            String other$fieldPath = other.getFieldPath();
            if (this$fieldPath == null ? other$fieldPath != null : !this$fieldPath.equals(other$fieldPath)) {
                return false;
            }
            String this$urn = this.getUrn();
            String other$urn = other.getUrn();
            if (this$urn == null ? other$urn != null : !this$urn.equals(other$urn)) {
                return false;
            }
            UrnValidationAnnotation this$annotation = this.getAnnotation();
            UrnValidationAnnotation other$annotation = other.getAnnotation();
            return !(this$annotation == null ? other$annotation != null : !((Object)this$annotation).equals(other$annotation));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fieldPath = this.getFieldPath();
            result = result * 59 + ($fieldPath == null ? 43 : $fieldPath.hashCode());
            String $urn = this.getUrn();
            result = result * 59 + ($urn == null ? 43 : $urn.hashCode());
            UrnValidationAnnotation $annotation = this.getAnnotation();
            result = result * 59 + ($annotation == null ? 43 : ((Object)$annotation).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UrnValidationUtil.UrnValidationEntry(fieldPath=" + this.getFieldPath() + ", urn=" + this.getUrn() + ", annotation=" + String.valueOf(this.getAnnotation()) + ")";
        }
    }
}

