/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils;

import com.datahub.util.RecordUtils;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.ByteString;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.BooleanDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.FloatDataSchema;
import com.linkedin.data.schema.IntegerDataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.StringDataSchema;
import com.linkedin.data.template.DynamicRecordTemplate;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.entity.Aspect;
import com.linkedin.entity.EntityResponse;
import com.linkedin.entity.EnvelopedAspect;
import com.linkedin.metadata.aspect.EnvelopedSystemAspect;
import com.linkedin.metadata.aspect.SystemAspect;
import com.linkedin.metadata.aspect.patch.GenericJsonPatch;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.registry.EntityRegistry;
import com.linkedin.mxe.GenericAspect;
import com.linkedin.mxe.GenericPayload;
import datahub.shaded.jackson.core.JsonProcessingException;
import datahub.shaded.jackson.databind.JsonNode;
import datahub.shaded.jackson.databind.ObjectMapper;
import jakarta.json.JsonPatch;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class GenericRecordUtils {
    public static final String JSON = "application/json";
    public static final String JSON_PATCH = "application/json-patch+json";

    private GenericRecordUtils() {
    }

    public static <T extends RecordTemplate> T copy(T input, Class<T> clazz) {
        try {
            if (input == null) {
                return null;
            }
            Constructor<T> constructor = clazz.getConstructor(DataMap.class);
            return (T)((RecordTemplate)constructor.newInstance(input.data().copy()));
        }
        catch (CloneNotSupportedException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static RecordTemplate deserializeAspect(@Nonnull ByteString aspectValue, @Nonnull String contentType, @Nonnull AspectSpec aspectSpec) {
        return GenericRecordUtils.deserializeAspect(aspectValue, contentType, aspectSpec.getDataTemplateClass());
    }

    @Nonnull
    public static <T extends RecordTemplate> T deserializeAspect(@Nonnull ByteString aspectValue, @Nonnull String contentType, @Nonnull Class<T> clazz) {
        if (!contentType.equals(JSON)) {
            throw new IllegalArgumentException(String.format("%s content type is not supported", contentType));
        }
        return RecordUtils.toRecordTemplate(clazz, aspectValue.asString(StandardCharsets.UTF_8));
    }

    @Nonnull
    public static <T extends RecordTemplate> T deserializePayload(@Nonnull ByteString payloadValue, @Nonnull String contentType, @Nonnull Class<T> clazz) {
        if (!contentType.equals(JSON)) {
            throw new IllegalArgumentException(String.format("%s content type is not supported", contentType));
        }
        return RecordUtils.toRecordTemplate(clazz, payloadValue.asString(StandardCharsets.UTF_8));
    }

    @Nonnull
    public static <T extends RecordTemplate> T deserializePayload(@Nonnull ByteString payloadValue, @Nonnull Class<T> clazz) {
        return GenericRecordUtils.deserializePayload(payloadValue, JSON, clazz);
    }

    @Nonnull
    public static GenericAspect serializeAspect(@Nonnull RecordTemplate aspect) {
        return GenericRecordUtils.serializeAspect(RecordUtils.toJsonString(aspect));
    }

    @Nonnull
    public static GenericAspect serializeAspect(@Nonnull String str) {
        GenericAspect genericAspect = new GenericAspect();
        genericAspect.setValue(ByteString.unsafeWrap(str.getBytes(StandardCharsets.UTF_8)));
        genericAspect.setContentType(JSON);
        return genericAspect;
    }

    @Nonnull
    public static GenericAspect serializeAspect(@Nonnull JsonNode json) {
        GenericAspect genericAspect = new GenericAspect();
        genericAspect.setValue(ByteString.unsafeWrap(json.toString().getBytes(StandardCharsets.UTF_8)));
        genericAspect.setContentType(JSON);
        return genericAspect;
    }

    @Nonnull
    public static GenericAspect serializePatch(@Nonnull JsonPatch jsonPatch) {
        GenericAspect genericAspect = new GenericAspect();
        genericAspect.setValue(ByteString.unsafeWrap(jsonPatch.toString().getBytes(StandardCharsets.UTF_8)));
        genericAspect.setContentType(JSON_PATCH);
        return genericAspect;
    }

    @Nonnull
    public static GenericAspect serializePatch(@Nonnull JsonNode jsonPatch) {
        GenericAspect genericAspect = new GenericAspect();
        genericAspect.setValue(ByteString.unsafeWrap(jsonPatch.toString().getBytes(StandardCharsets.UTF_8)));
        genericAspect.setContentType(JSON_PATCH);
        return genericAspect;
    }

    @Nonnull
    public static GenericAspect serializePatch(@Nonnull GenericJsonPatch jsonPatch, @Nonnull ObjectMapper objectMapper) {
        try {
            GenericAspect genericAspect = new GenericAspect();
            genericAspect.setValue(ByteString.unsafeWrap(objectMapper.writeValueAsString(jsonPatch).getBytes(StandardCharsets.UTF_8)));
            genericAspect.setContentType(JSON_PATCH);
            return genericAspect;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static GenericPayload serializePayload(@Nonnull RecordTemplate payload) {
        GenericPayload genericPayload = new GenericPayload();
        genericPayload.setValue(ByteString.unsafeWrap(RecordUtils.toJsonString(payload).getBytes(StandardCharsets.UTF_8)));
        genericPayload.setContentType(JSON);
        return genericPayload;
    }

    @Nonnull
    public static Map<Urn, Map<String, Aspect>> entityResponseToAspectMap(Map<Urn, EntityResponse> inputMap) {
        return inputMap.entrySet().stream().map(entry -> Map.entry((Urn)entry.getKey(), ((EntityResponse)entry.getValue()).getAspects().entrySet().stream().map(aspectEntry -> Map.entry((String)aspectEntry.getKey(), ((EnvelopedAspect)aspectEntry.getValue()).getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Nonnull
    public static Map<Urn, Map<String, SystemAspect>> entityResponseToSystemAspectMap(Map<Urn, EntityResponse> inputMap, @Nonnull EntityRegistry entityRegistry) {
        return inputMap.entrySet().stream().map(entry -> Map.entry((Urn)entry.getKey(), ((EntityResponse)entry.getValue()).getAspects().entrySet().stream().filter(aspectEntry -> aspectEntry.getValue() != null).map(aspectEntry -> Map.entry((String)aspectEntry.getKey(), EnvelopedSystemAspect.of((Urn)entry.getKey(), (EnvelopedAspect)aspectEntry.getValue(), entityRegistry.getEntitySpec(((Urn)entry.getKey()).getEntityType())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static DynamicRecordTemplate fromJson(JsonNode rootNode, String schemaName) {
        RecordDataSchema schema = GenericRecordUtils.inferSchemaFromJsonNode(rootNode, schemaName);
        DataMap dataMap = GenericRecordUtils.toDataMap(rootNode);
        return new DynamicRecordTemplate(dataMap, schema);
    }

    private static RecordDataSchema inferSchemaFromJsonNode(JsonNode rootNode, String schemaName) {
        Name name = new Name(schemaName);
        RecordDataSchema schema = new RecordDataSchema(name, RecordDataSchema.RecordType.RECORD);
        if (rootNode.isObject()) {
            ArrayList<RecordDataSchema.Field> fields = new ArrayList<RecordDataSchema.Field>();
            Iterator<Map.Entry<String, JsonNode>> fieldsIterator = rootNode.fields();
            while (fieldsIterator.hasNext()) {
                StringBuilder errorBuilder;
                Map.Entry<String, JsonNode> entry = fieldsIterator.next();
                String fieldName = entry.getKey();
                JsonNode fieldValue = entry.getValue();
                DataSchema fieldSchema = GenericRecordUtils.inferFieldSchema(fieldValue, fieldName);
                RecordDataSchema.Field field = new RecordDataSchema.Field(fieldSchema);
                boolean nameSetSuccessfully = field.setName(fieldName, errorBuilder = new StringBuilder());
                if (!nameSetSuccessfully) {
                    System.err.println("Warning: Field name issue: " + errorBuilder.toString());
                    continue;
                }
                if (fieldValue.isNull()) {
                    field.setOptional(true);
                }
                fields.add(field);
            }
            StringBuilder errorBuilder = new StringBuilder();
            boolean fieldsSetSuccessfully = schema.setFields(fields, errorBuilder);
            if (!fieldsSetSuccessfully) {
                System.err.println("Warning: Schema field issues: " + errorBuilder.toString());
            }
        }
        return schema;
    }

    private static DataSchema inferFieldSchema(JsonNode node, String baseName) {
        if (node.isTextual()) {
            return new StringDataSchema();
        }
        if (node.isNumber()) {
            if (node.isInt()) {
                return new IntegerDataSchema();
            }
            return new FloatDataSchema();
        }
        if (node.isBoolean()) {
            return new BooleanDataSchema();
        }
        if (node.isObject()) {
            return GenericRecordUtils.inferSchemaFromJsonNode(node, baseName + "Record");
        }
        if (node.isArray()) {
            if (node.size() > 0) {
                DataSchema itemSchema = GenericRecordUtils.inferFieldSchema(node.get(0), baseName + "Item");
                return new ArrayDataSchema(itemSchema);
            }
            return new ArrayDataSchema(new StringDataSchema());
        }
        if (node.isNull()) {
            return new StringDataSchema();
        }
        return new StringDataSchema();
    }

    private static DataMap toDataMap(JsonNode node) {
        if (node == null || !node.isObject()) {
            return new DataMap();
        }
        DataMap dataMap = new DataMap();
        Iterator<Map.Entry<String, JsonNode>> fields = node.fields();
        while (fields.hasNext()) {
            Object convertedValue;
            Map.Entry<String, JsonNode> entry = fields.next();
            String key = entry.getKey();
            JsonNode value = entry.getValue();
            if (value.isNull() || (convertedValue = GenericRecordUtils.convertJsonValue(value)) == null) continue;
            dataMap.put(key, convertedValue);
        }
        return dataMap;
    }

    private static Object convertJsonValue(JsonNode node) {
        if (node.isNull()) {
            return null;
        }
        if (node.isTextual()) {
            return node.textValue();
        }
        if (node.isInt()) {
            return node.intValue();
        }
        if (node.isLong()) {
            return node.longValue();
        }
        if (node.isDouble() || node.isFloat()) {
            return node.doubleValue();
        }
        if (node.isBoolean()) {
            return node.booleanValue();
        }
        if (node.isObject()) {
            return GenericRecordUtils.toDataMap(node);
        }
        if (node.isArray()) {
            DataList dataList = new DataList();
            for (JsonNode item : node) {
                Object convertedItem;
                if (item.isNull() || (convertedItem = GenericRecordUtils.convertJsonValue(item)) == null) continue;
                dataList.add(convertedItem);
            }
            return dataList;
        }
        return node.toString();
    }
}

