/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.snapshot;

import com.linkedin.common.urn.DataPlatformUrn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.aspect.DataPlatformAspectArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataPlatformSnapshot
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.snapshot/**A metadata snapshot for a specific dataplatform entity.*/@Entity={\"keyAspect\":\"dataPlatformKey\",\"name\":\"dataPlatform\"}record DataPlatformSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:{namespace com.linkedin.common/**Standardized data platforms available*/@java.class=\"com.linkedin.common.urn.DataPlatformUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized data platforms available\",\"entityType\":\"dataPlatform\",\"fields\":[{\"doc\":\"data platform name i.e. hdfs, oracle, espresso\",\"maxLength\":25,\"name\":\"platformName\",\"type\":\"string\"}],\"maxLength\":45,\"name\":\"DataPlatform\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:wherehows\"}typeref DataPlatformUrn=string}/**The list of metadata aspects associated with the data platform. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a Data Platform*/typeref DataPlatformAspect=union[{namespace com.linkedin.metadata.key/**Key for a Data Platform*/@Aspect.name=\"dataPlatformKey\"record DataPlatformKey{/**Data platform name i.e. hdfs, oracle, espresso*/platformName:string}}{namespace com.linkedin.dataplatform/**Information about a data platform*/@Aspect.name=\"dataPlatformInfo\"record DataPlatformInfo{/**Name of the data platform*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":false,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}@validate.strlen.max=15,name:string/**The name that will be used for displaying a platform type.*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\"}displayName:optional string/**Platform type this data platform describes*/type:/**Platform types available at LinkedIn*/enum PlatformType{/**Value for a file system, e.g. hdfs*/FILE_SYSTEM/**Value for a key value store, e.g. espresso, voldemort*/KEY_VALUE_STORE/**Value for a message broker, e.g. kafka*/MESSAGE_BROKER/**Value for an object store, e.g. ambry*/OBJECT_STORE/**Value for an OLAP datastore, e.g. pinot*/OLAP_DATASTORE/**Value for other platforms, e.g salesforce, dovetail*/OTHERS/**Value for a query engine, e.g. presto*/QUERY_ENGINE/**Value for a relational database, e.g. oracle, mysql*/RELATIONAL_DB/**Value for a search engine, e.g seas*/SEARCH_ENGINE}/**The delimiter in the dataset names on the data platform, e.g. '/' for HDFS and '.' for Oracle*/datasetNameDelimiter:string/**The URL for a logo associated with the platform*/logoUrl:optional{namespace com.linkedin.common@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}}]}]}", SchemaFormatType.PDL);
    private DataPlatformUrn _urnField = null;
    private DataPlatformAspectArray _aspectsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Urn = SCHEMA.getField("urn");
    private static final RecordDataSchema.Field FIELD_Aspects = SCHEMA.getField("aspects");

    public DataPlatformSnapshot() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public DataPlatformSnapshot(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUrn() {
        if (this._urnField != null) {
            return true;
        }
        return this._map.containsKey("urn");
    }

    public void removeUrn() {
        this._map.remove("urn");
    }

    @Nullable
    public DataPlatformUrn getUrn(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getUrn();
            }
            case DEFAULT: 
            case NULL: {
                if (this._urnField != null) {
                    return this._urnField;
                }
                Object __rawValue = this._map.get("urn");
                this._urnField = DataTemplateUtil.coerceCustomOutput(__rawValue, DataPlatformUrn.class);
                return this._urnField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DataPlatformUrn getUrn() {
        if (this._urnField != null) {
            return this._urnField;
        }
        Object __rawValue = this._map.get("urn");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("urn");
        }
        this._urnField = DataTemplateUtil.coerceCustomOutput(__rawValue, DataPlatformUrn.class);
        return this._urnField;
    }

    public DataPlatformSnapshot setUrn(@Nullable DataPlatformUrn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field urn of com.linkedin.metadata.snapshot.DataPlatformSnapshot");
                }
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, DataPlatformUrn.class));
                this._urnField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, DataPlatformUrn.class));
                this._urnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, DataPlatformUrn.class));
                this._urnField = value;
            }
        }
        return this;
    }

    public DataPlatformSnapshot setUrn(@Nonnull DataPlatformUrn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field urn of com.linkedin.metadata.snapshot.DataPlatformSnapshot to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, DataPlatformUrn.class));
        this._urnField = value;
        return this;
    }

    public boolean hasAspects() {
        if (this._aspectsField != null) {
            return true;
        }
        return this._map.containsKey("aspects");
    }

    public void removeAspects() {
        this._map.remove("aspects");
    }

    @Nullable
    public DataPlatformAspectArray getAspects(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAspects();
            }
            case DEFAULT: 
            case NULL: {
                if (this._aspectsField != null) {
                    return this._aspectsField;
                }
                Object __rawValue = this._map.get("aspects");
                this._aspectsField = __rawValue == null ? null : new DataPlatformAspectArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._aspectsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DataPlatformAspectArray getAspects() {
        if (this._aspectsField != null) {
            return this._aspectsField;
        }
        Object __rawValue = this._map.get("aspects");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("aspects");
        }
        this._aspectsField = __rawValue == null ? null : new DataPlatformAspectArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._aspectsField;
    }

    public DataPlatformSnapshot setAspects(@Nullable DataPlatformAspectArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAspects(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field aspects of com.linkedin.metadata.snapshot.DataPlatformSnapshot");
                }
                CheckedUtil.putWithoutChecking(this._map, "aspects", value.data());
                this._aspectsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAspects();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aspects", value.data());
                this._aspectsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aspects", value.data());
                this._aspectsField = value;
            }
        }
        return this;
    }

    public DataPlatformSnapshot setAspects(@Nonnull DataPlatformAspectArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aspects of com.linkedin.metadata.snapshot.DataPlatformSnapshot to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aspects", value.data());
        this._aspectsField = value;
        return this;
    }

    @Override
    public DataPlatformSnapshot clone() throws CloneNotSupportedException {
        DataPlatformSnapshot __clone = (DataPlatformSnapshot)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataPlatformSnapshot copy() throws CloneNotSupportedException {
        DataPlatformSnapshot __copy = (DataPlatformSnapshot)super.copy();
        __copy._urnField = null;
        __copy._aspectsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(DataPlatformUrn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataPlatformSnapshot __objectRef;

        private ChangeListener(DataPlatformSnapshot reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "urn": {
                    this.__objectRef._urnField = null;
                    break;
                }
                case "aspects": {
                    this.__objectRef._aspectsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec urn() {
            return new PathSpec(this.getPathComponents(), "urn");
        }

        public DataPlatformAspectArray.Fields aspects() {
            return new DataPlatformAspectArray.Fields(this.getPathComponents(), "aspects");
        }

        public PathSpec aspects(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "aspects");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private DataPlatformAspectArray.ProjectionMask _aspectsMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withUrn() {
            this.getDataMap().put("urn", 1);
            return this;
        }

        public ProjectionMask withAspects(Function<DataPlatformAspectArray.ProjectionMask, DataPlatformAspectArray.ProjectionMask> nestedMask) {
            this._aspectsMask = nestedMask.apply(this._aspectsMask == null ? DataPlatformAspectArray.createMask() : this._aspectsMask);
            this.getDataMap().put("aspects", this._aspectsMask.getDataMap());
            return this;
        }

        public ProjectionMask withAspects() {
            this._aspectsMask = null;
            this.getDataMap().put("aspects", 1);
            return this;
        }

        public ProjectionMask withAspects(Function<DataPlatformAspectArray.ProjectionMask, DataPlatformAspectArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._aspectsMask = nestedMask.apply(this._aspectsMask == null ? DataPlatformAspectArray.createMask() : this._aspectsMask);
            this.getDataMap().put("aspects", this._aspectsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("aspects").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("aspects").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withAspects(Integer start, Integer count) {
            this._aspectsMask = null;
            this.getDataMap().put("aspects", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("aspects").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("aspects").put("$count", count);
            }
            return this;
        }
    }
}

