/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.run;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.metadata.run.RelatedAspect;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class RelatedAspectArray
extends WrappingArrayTemplate<RelatedAspect> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.metadata.run/**Metadata about how an aspect is related to some urn*/record RelatedAspect{/** Urn of the entity that is referenced by the aspect.*/entity:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}aspect:string,relationship:string}}]", SchemaFormatType.PDL);

    public RelatedAspectArray() {
        this(new DataList());
    }

    public RelatedAspectArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public RelatedAspectArray(Collection<RelatedAspect> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public RelatedAspectArray(DataList data) {
        super(data, SCHEMA, RelatedAspect.class);
    }

    public RelatedAspectArray(RelatedAspect first, RelatedAspect ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public RelatedAspectArray clone() throws CloneNotSupportedException {
        RelatedAspectArray __clone = (RelatedAspectArray)super.clone();
        return __clone;
    }

    @Override
    public RelatedAspectArray copy() throws CloneNotSupportedException {
        RelatedAspectArray __copy = (RelatedAspectArray)super.copy();
        return __copy;
    }

    @Override
    protected RelatedAspect coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new RelatedAspect(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private RelatedAspect.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<RelatedAspect.ProjectionMask, RelatedAspect.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? RelatedAspect.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public RelatedAspect.Fields items() {
            return new RelatedAspect.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

