/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.query;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.query.GroupingCriterionArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GroupingSpec
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.query/**A set of directives to control how results are grouped.\nThe underlying generic groupings are nested to allow for further evolution of the grouping spec.*/record GroupingSpec{/**A list of generic directives to group results by.\n*/groupingCriteria:array[record GroupingCriterion{/**The type of the entity to be grouped.\ne.g. schemaField\nOmitting this field will result in all base entities being grouped.*/baseEntityType:optional string/**The type of the entity to be grouped into.\ne.g. dataset, domain, etc.*/groupingEntityType:string}]=[]}", SchemaFormatType.PDL);
    private GroupingCriterionArray _groupingCriteriaField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_GroupingCriteria = SCHEMA.getField("groupingCriteria");
    private static final GroupingCriterionArray DEFAULT_GroupingCriteria = FIELD_GroupingCriteria.getDefault() == null ? null : new GroupingCriterionArray(DataTemplateUtil.castOrThrow(FIELD_GroupingCriteria.getDefault(), DataList.class));

    public GroupingSpec() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public GroupingSpec(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasGroupingCriteria() {
        if (this._groupingCriteriaField != null) {
            return true;
        }
        return this._map.containsKey("groupingCriteria");
    }

    public void removeGroupingCriteria() {
        this._map.remove("groupingCriteria");
    }

    @Nullable
    public GroupingCriterionArray getGroupingCriteria(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getGroupingCriteria();
            }
            case NULL: {
                if (this._groupingCriteriaField != null) {
                    return this._groupingCriteriaField;
                }
                Object __rawValue = this._map.get("groupingCriteria");
                this._groupingCriteriaField = __rawValue == null ? null : new GroupingCriterionArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._groupingCriteriaField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public GroupingCriterionArray getGroupingCriteria() {
        if (this._groupingCriteriaField != null) {
            return this._groupingCriteriaField;
        }
        Object __rawValue = this._map.get("groupingCriteria");
        if (__rawValue == null) {
            return DEFAULT_GroupingCriteria;
        }
        this._groupingCriteriaField = __rawValue == null ? null : new GroupingCriterionArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._groupingCriteriaField;
    }

    public GroupingSpec setGroupingCriteria(@Nullable GroupingCriterionArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGroupingCriteria(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field groupingCriteria of com.linkedin.metadata.query.GroupingSpec");
                }
                CheckedUtil.putWithoutChecking(this._map, "groupingCriteria", value.data());
                this._groupingCriteriaField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGroupingCriteria();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "groupingCriteria", value.data());
                this._groupingCriteriaField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "groupingCriteria", value.data());
                this._groupingCriteriaField = value;
            }
        }
        return this;
    }

    public GroupingSpec setGroupingCriteria(@Nonnull GroupingCriterionArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field groupingCriteria of com.linkedin.metadata.query.GroupingSpec to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "groupingCriteria", value.data());
        this._groupingCriteriaField = value;
        return this;
    }

    @Override
    public GroupingSpec clone() throws CloneNotSupportedException {
        GroupingSpec __clone = (GroupingSpec)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public GroupingSpec copy() throws CloneNotSupportedException {
        GroupingSpec __copy = (GroupingSpec)super.copy();
        __copy._groupingCriteriaField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final GroupingSpec __objectRef;

        private ChangeListener(GroupingSpec reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "groupingCriteria": {
                    this.__objectRef._groupingCriteriaField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public GroupingCriterionArray.Fields groupingCriteria() {
            return new GroupingCriterionArray.Fields(this.getPathComponents(), "groupingCriteria");
        }

        public PathSpec groupingCriteria(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "groupingCriteria");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private GroupingCriterionArray.ProjectionMask _groupingCriteriaMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withGroupingCriteria(Function<GroupingCriterionArray.ProjectionMask, GroupingCriterionArray.ProjectionMask> nestedMask) {
            this._groupingCriteriaMask = nestedMask.apply(this._groupingCriteriaMask == null ? GroupingCriterionArray.createMask() : this._groupingCriteriaMask);
            this.getDataMap().put("groupingCriteria", this._groupingCriteriaMask.getDataMap());
            return this;
        }

        public ProjectionMask withGroupingCriteria() {
            this._groupingCriteriaMask = null;
            this.getDataMap().put("groupingCriteria", 1);
            return this;
        }

        public ProjectionMask withGroupingCriteria(Function<GroupingCriterionArray.ProjectionMask, GroupingCriterionArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._groupingCriteriaMask = nestedMask.apply(this._groupingCriteriaMask == null ? GroupingCriterionArray.createMask() : this._groupingCriteriaMask);
            this.getDataMap().put("groupingCriteria", this._groupingCriteriaMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("groupingCriteria").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("groupingCriteria").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withGroupingCriteria(Integer start, Integer count) {
            this._groupingCriteriaMask = null;
            this.getDataMap().put("groupingCriteria", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("groupingCriteria").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("groupingCriteria").put("$count", count);
            }
            return this;
        }
    }
}

