/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.registry;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.UnionTemplate;
import com.linkedin.metadata.aspect.patch.template.AspectTemplateEngine;
import com.linkedin.metadata.aspect.patch.template.Template;
import com.linkedin.metadata.aspect.patch.template.chart.ChartInfoTemplate;
import com.linkedin.metadata.aspect.patch.template.common.GlobalTagsTemplate;
import com.linkedin.metadata.aspect.patch.template.common.GlossaryTermsTemplate;
import com.linkedin.metadata.aspect.patch.template.common.OwnershipTemplate;
import com.linkedin.metadata.aspect.patch.template.common.SiblingsTemplate;
import com.linkedin.metadata.aspect.patch.template.common.StructuredPropertiesTemplate;
import com.linkedin.metadata.aspect.patch.template.common.VersionPropertiesTemplate;
import com.linkedin.metadata.aspect.patch.template.dashboard.DashboardInfoTemplate;
import com.linkedin.metadata.aspect.patch.template.dataflow.DataFlowInfoTemplate;
import com.linkedin.metadata.aspect.patch.template.datajob.DataJobInfoTemplate;
import com.linkedin.metadata.aspect.patch.template.datajob.DataJobInputOutputTemplate;
import com.linkedin.metadata.aspect.patch.template.dataproduct.DataProductPropertiesTemplate;
import com.linkedin.metadata.aspect.patch.template.dataset.DatasetPropertiesTemplate;
import com.linkedin.metadata.aspect.patch.template.dataset.EditableSchemaMetadataTemplate;
import com.linkedin.metadata.aspect.patch.template.dataset.UpstreamLineageTemplate;
import com.linkedin.metadata.aspect.patch.template.form.FormInfoTemplate;
import com.linkedin.metadata.aspect.patch.template.structuredproperty.StructuredPropertyDefinitionTemplate;
import com.linkedin.metadata.aspect.plugins.PluginFactory;
import com.linkedin.metadata.aspect.plugins.config.PluginConfiguration;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.models.EntitySpecBuilder;
import com.linkedin.metadata.models.EventSpec;
import com.linkedin.metadata.models.registry.EntityRegistry;
import com.linkedin.metadata.models.registry.EntityRegistryUtils;
import com.linkedin.metadata.snapshot.Snapshot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class SnapshotEntityRegistry
implements EntityRegistry {
    private final Map<String, EntitySpec> entityNameToSpec;
    private final List<EntitySpec> entitySpecs;
    private final AspectTemplateEngine _aspectTemplateEngine;
    private final Map<String, AspectSpec> _aspectNameToSpec;
    @Nullable
    private BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> pluginFactoryProvider;
    private static final SnapshotEntityRegistry INSTANCE = new SnapshotEntityRegistry();

    public SnapshotEntityRegistry() {
        this.entityNameToSpec = new EntitySpecBuilder().buildEntitySpecs(new Snapshot().schema()).stream().collect(Collectors.toMap(spec -> spec.getName().toLowerCase(), spec -> spec));
        this.entitySpecs = new ArrayList<EntitySpec>(this.entityNameToSpec.values());
        this._aspectNameToSpec = EntityRegistryUtils.populateAspectMap(this.entitySpecs);
        this._aspectTemplateEngine = this.populateTemplateEngine(this._aspectNameToSpec);
        this.pluginFactoryProvider = null;
    }

    public SnapshotEntityRegistry(BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> pluginFactoryProvider) {
        this.entityNameToSpec = new EntitySpecBuilder().buildEntitySpecs(new Snapshot().schema()).stream().collect(Collectors.toMap(spec -> spec.getName().toLowerCase(), spec -> spec));
        this.entitySpecs = new ArrayList<EntitySpec>(this.entityNameToSpec.values());
        this._aspectNameToSpec = EntityRegistryUtils.populateAspectMap(this.entitySpecs);
        this._aspectTemplateEngine = this.populateTemplateEngine(this._aspectNameToSpec);
        this.pluginFactoryProvider = pluginFactoryProvider;
    }

    public SnapshotEntityRegistry(UnionTemplate snapshot) {
        this.entityNameToSpec = new EntitySpecBuilder().buildEntitySpecs(snapshot.schema()).stream().collect(Collectors.toMap(spec -> spec.getName().toLowerCase(), spec -> spec));
        this.entitySpecs = new ArrayList<EntitySpec>(this.entityNameToSpec.values());
        this._aspectNameToSpec = EntityRegistryUtils.populateAspectMap(this.entitySpecs);
        this._aspectTemplateEngine = this.populateTemplateEngine(this._aspectNameToSpec);
    }

    private AspectTemplateEngine populateTemplateEngine(Map<String, AspectSpec> aspectSpecs) {
        HashMap<String, Template<? extends RecordTemplate>> aspectSpecTemplateMap = new HashMap<String, Template<? extends RecordTemplate>>();
        aspectSpecTemplateMap.put("ownership", new OwnershipTemplate());
        aspectSpecTemplateMap.put("datasetProperties", new DatasetPropertiesTemplate());
        aspectSpecTemplateMap.put("upstreamLineage", new UpstreamLineageTemplate());
        aspectSpecTemplateMap.put("globalTags", new GlobalTagsTemplate());
        aspectSpecTemplateMap.put("editableSchemaMetadata", new EditableSchemaMetadataTemplate());
        aspectSpecTemplateMap.put("glossaryTerms", new GlossaryTermsTemplate());
        aspectSpecTemplateMap.put("dataFlowInfo", new DataFlowInfoTemplate());
        aspectSpecTemplateMap.put("dataJobInfo", new DataJobInfoTemplate());
        aspectSpecTemplateMap.put("dataProductProperties", new DataProductPropertiesTemplate());
        aspectSpecTemplateMap.put("chartInfo", new ChartInfoTemplate());
        aspectSpecTemplateMap.put("dashboardInfo", new DashboardInfoTemplate());
        aspectSpecTemplateMap.put("dataJobInputOutput", new DataJobInputOutputTemplate());
        aspectSpecTemplateMap.put("structuredProperties", new StructuredPropertiesTemplate());
        aspectSpecTemplateMap.put("propertyDefinition", new StructuredPropertyDefinitionTemplate());
        aspectSpecTemplateMap.put("formInfo", new FormInfoTemplate());
        aspectSpecTemplateMap.put("versionProperties", new VersionPropertiesTemplate());
        aspectSpecTemplateMap.put("siblings", new SiblingsTemplate());
        return new AspectTemplateEngine(aspectSpecTemplateMap);
    }

    @Override
    @Nonnull
    public EntitySpec getEntitySpec(@Nonnull String entityName) {
        String lowercaseEntityName = entityName.toLowerCase();
        if (!this.entityNameToSpec.containsKey(lowercaseEntityName)) {
            throw new IllegalArgumentException(String.format("Failed to find entity with name %s in EntityRegistry", entityName));
        }
        return this.entityNameToSpec.get(lowercaseEntityName);
    }

    @Override
    @Nonnull
    public Map<String, EntitySpec> getEntitySpecs() {
        return this.entityNameToSpec;
    }

    @Override
    @Nonnull
    public Map<String, EventSpec> getEventSpecs() {
        return new HashMap<String, EventSpec>();
    }

    @Override
    @Nonnull
    public AspectTemplateEngine getAspectTemplateEngine() {
        return this._aspectTemplateEngine;
    }

    @Override
    public EventSpec getEventSpec(@Nonnull String ignored) {
        return null;
    }

    public static SnapshotEntityRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    @Nonnull
    public Map<String, AspectSpec> getAspectSpecs() {
        return this._aspectNameToSpec;
    }

    @Override
    @Nullable
    @Generated
    public BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> getPluginFactoryProvider() {
        return this.pluginFactoryProvider;
    }
}

