/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.extractor;

import com.datahub.util.ModelUtils;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.metadata.models.annotation.AspectAnnotation;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspectExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AspectExtractor.class);

    private AspectExtractor() {
    }

    public static Map<String, RecordTemplate> extractAspectRecords(RecordTemplate snapshot) {
        return ModelUtils.getAspectsFromSnapshot(snapshot).stream().collect(Collectors.toMap(record -> AspectExtractor.getAspectNameFromSchema(record.schema()), Function.identity()));
    }

    private static String getAspectNameFromSchema(RecordDataSchema aspectSchema) {
        Object aspectAnnotationObj = aspectSchema.getProperties().get("Aspect");
        if (aspectAnnotationObj != null) {
            return AspectAnnotation.fromSchemaProperty(aspectAnnotationObj, aspectSchema.getFullName()).getName();
        }
        log.error(String.format("Failed to extract aspect name from provided schema %s", aspectSchema.getName()));
        throw new IllegalArgumentException(String.format("Failed to extract aspect name from provided schema %s", aspectSchema.getName()));
    }
}

