/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models;

import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.RelationshipFieldSpec;
import com.linkedin.metadata.models.SearchScoreFieldSpec;
import com.linkedin.metadata.models.SearchableFieldSpec;
import com.linkedin.metadata.models.SearchableRefFieldSpec;
import com.linkedin.metadata.models.annotation.EntityAnnotation;
import com.linkedin.metadata.models.annotation.SearchableAnnotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public interface EntitySpec {
    public String getName();

    public EntityAnnotation getEntityAnnotation();

    public String getKeyAspectName();

    public AspectSpec getKeyAspectSpec();

    public List<AspectSpec> getAspectSpecs();

    public Map<String, AspectSpec> getAspectSpecMap();

    public Boolean hasAspect(String var1);

    public AspectSpec getAspectSpec(String var1);

    public RecordDataSchema getSnapshotSchema();

    public TyperefDataSchema getAspectTyperefSchema();

    default public List<SearchableFieldSpec> getSearchableFieldSpecs() {
        return this.getAspectSpecs().stream().map(AspectSpec::getSearchableFieldSpecs).flatMap(Collection::stream).collect(Collectors.toList());
    }

    default public Map<String, Set<SearchableAnnotation.FieldType>> getSearchableFieldTypes() {
        HashMap<String, Set<SearchableAnnotation.FieldType>> fieldSpecMap = new HashMap<String, Set<SearchableAnnotation.FieldType>>();
        for (SearchableFieldSpec fieldSpec : this.getSearchableFieldSpecs()) {
            HashSet<SearchableAnnotation.FieldType> fieldSet;
            String fieldName;
            SearchableAnnotation searchableAnnotation = fieldSpec.getSearchableAnnotation();
            if (searchableAnnotation.getNumValuesFieldName().isPresent()) {
                fieldName = searchableAnnotation.getNumValuesFieldName().get();
                fieldSet = new HashSet<SearchableAnnotation.FieldType>();
                fieldSet.add(SearchableAnnotation.FieldType.COUNT);
                fieldSpecMap.put(fieldName, fieldSet);
            }
            if (!searchableAnnotation.getHasValuesFieldName().isPresent()) continue;
            fieldName = searchableAnnotation.getHasValuesFieldName().get();
            fieldSet = new HashSet();
            fieldSet.add(SearchableAnnotation.FieldType.BOOLEAN);
            fieldSpecMap.put(fieldName, fieldSet);
        }
        fieldSpecMap.putAll(this.getSearchableFieldSpecs().stream().collect(Collectors.toMap(searchableFieldSpec -> searchableFieldSpec.getSearchableAnnotation().getFieldName(), searchableFieldSpec -> new HashSet<SearchableAnnotation.FieldType>(Collections.singleton(searchableFieldSpec.getSearchableAnnotation().getFieldType())), (set1, set2) -> {
            set1.addAll(set2);
            return set1;
        })));
        return fieldSpecMap;
    }

    default public List<SearchScoreFieldSpec> getSearchScoreFieldSpecs() {
        return this.getAspectSpecs().stream().map(AspectSpec::getSearchScoreFieldSpecs).flatMap(Collection::stream).collect(Collectors.toList());
    }

    default public List<RelationshipFieldSpec> getRelationshipFieldSpecs() {
        return this.getAspectSpecs().stream().map(AspectSpec::getRelationshipFieldSpecs).flatMap(Collection::stream).collect(Collectors.toList());
    }

    default public List<SearchableRefFieldSpec> getSearchableRefFieldSpecs() {
        return this.getAspectSpecs().stream().map(AspectSpec::getSearchableRefFieldSpecs).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

