/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.plugins.validation;

import com.datahub.authorization.AuthorizationSession;
import com.linkedin.metadata.aspect.RetrieverContext;
import com.linkedin.metadata.aspect.batch.BatchItem;
import com.linkedin.metadata.aspect.batch.ChangeMCP;
import com.linkedin.metadata.aspect.plugins.PluginSpec;
import com.linkedin.metadata.aspect.plugins.validation.AspectValidationException;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AspectPayloadValidator
extends PluginSpec {
    public final Stream<AspectValidationException> validateProposed(@Nonnull Collection<? extends BatchItem> mcpItems, @Nonnull RetrieverContext retrieverContext, @Nullable AuthorizationSession session) {
        return this.validateProposedAspects(mcpItems.stream().filter(i -> this.shouldApply(i.getChangeType(), i.getUrn(), i.getAspectName())).collect(Collectors.toList()), retrieverContext, session);
    }

    public final Stream<AspectValidationException> validatePreCommit(@Nonnull Collection<ChangeMCP> changeMCPs, @Nonnull RetrieverContext retrieverContext) {
        return this.validatePreCommitAspects(changeMCPs.stream().filter(i -> this.shouldApply(i.getChangeType(), i.getUrn(), i.getAspectName())).collect(Collectors.toList()), retrieverContext);
    }

    protected abstract Stream<AspectValidationException> validateProposedAspects(@Nonnull Collection<? extends BatchItem> var1, @Nonnull RetrieverContext var2);

    protected Stream<AspectValidationException> validateProposedAspectsWithAuth(@Nonnull Collection<? extends BatchItem> mcpItems, @Nonnull RetrieverContext retrieverContext, @Nullable AuthorizationSession session) {
        return Stream.empty();
    }

    private Stream<AspectValidationException> validateProposedAspects(@Nonnull Collection<? extends BatchItem> mcpItems, @Nonnull RetrieverContext retrieverContext, @Nullable AuthorizationSession session) {
        return Stream.concat(this.validateProposedAspects(mcpItems, retrieverContext), this.validateProposedAspectsWithAuth(mcpItems, retrieverContext, session));
    }

    protected abstract Stream<AspectValidationException> validatePreCommitAspects(@Nonnull Collection<ChangeMCP> var1, @Nonnull RetrieverContext var2);
}

