/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.builder;

import com.datahub.util.RecordUtils;
import com.linkedin.common.AuditStamp;
import com.linkedin.data.template.StringArrayMap;
import com.linkedin.metadata.aspect.patch.PatchOperationType;
import com.linkedin.metadata.aspect.patch.builder.AbstractMultiFieldPatchBuilder;
import com.linkedin.structured.PropertyCardinality;
import com.linkedin.structured.PropertyValue;
import datahub.shaded.jackson.core.JsonProcessingException;
import datahub.shaded.jackson.databind.ObjectMapper;
import datahub.shaded.jackson.databind.node.ArrayNode;
import datahub.shaded.jackson.databind.node.JsonNodeFactory;
import datahub.shaded.jackson.databind.node.ObjectNode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class StructuredPropertyDefinitionPatchBuilder
extends AbstractMultiFieldPatchBuilder<StructuredPropertyDefinitionPatchBuilder> {
    public static final String PATH_DELIM = "/";
    public static final String QUALIFIED_NAME_FIELD = "qualifiedName";
    public static final String DISPLAY_NAME_FIELD = "displayName";
    public static final String VALUE_TYPE_FIELD = "valueType";
    public static final String TYPE_QUALIFIER_FIELD = "typeQualifier";
    public static final String ALLOWED_VALUES_FIELD = "allowedValues";
    public static final String CARDINALITY_FIELD = "cardinality";
    public static final String ENTITY_TYPES_FIELD = "entityTypes";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String IMMUTABLE_FIELD = "immutable";
    private static final String LAST_MODIFIED_KEY = "lastModified";
    private static final String CREATED_KEY = "created";
    private static final String TIME_KEY = "time";
    private static final String ACTOR_KEY = "actor";

    public StructuredPropertyDefinitionPatchBuilder setQualifiedName(@Nonnull String name) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/qualifiedName", JsonNodeFactory.instance.textNode(name)));
        return this;
    }

    public StructuredPropertyDefinitionPatchBuilder setDisplayName(@Nonnull String displayName) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/displayName", JsonNodeFactory.instance.textNode(displayName)));
        return this;
    }

    public StructuredPropertyDefinitionPatchBuilder setValueType(@Nonnull String valueTypeUrn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/valueType", JsonNodeFactory.instance.textNode(valueTypeUrn)));
        return this;
    }

    public StructuredPropertyDefinitionPatchBuilder setTypeQualifier(@Nonnull StringArrayMap typeQualifier) {
        ObjectNode value = JsonNodeFactory.instance.objectNode();
        typeQualifier.forEach((key, values) -> {
            ArrayNode valuesNode = JsonNodeFactory.instance.arrayNode();
            values.forEach(valuesNode::add);
            value.set((String)key, valuesNode);
        });
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/typeQualifier", value));
        return this;
    }

    public StructuredPropertyDefinitionPatchBuilder addAllowedValue(@Nonnull PropertyValue propertyValue) {
        try {
            ObjectNode valueNode = (ObjectNode)new ObjectMapper().readTree(RecordUtils.toJsonString(propertyValue));
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/allowedValues/" + String.valueOf(propertyValue.getValue()), valueNode));
            return this;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to add allowed value, failed to parse provided aspect json.", e);
        }
    }

    public StructuredPropertyDefinitionPatchBuilder setCardinality(@Nonnull PropertyCardinality cardinality) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/cardinality", JsonNodeFactory.instance.textNode(cardinality.toString())));
        return this;
    }

    public StructuredPropertyDefinitionPatchBuilder addEntityType(@Nonnull String entityTypeUrn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/entityTypes/" + entityTypeUrn, JsonNodeFactory.instance.textNode(entityTypeUrn)));
        return this;
    }

    public StructuredPropertyDefinitionPatchBuilder setDescription(@Nullable String description) {
        if (description == null) {
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), "/description", null));
        } else {
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/description", JsonNodeFactory.instance.textNode(description)));
        }
        return this;
    }

    public StructuredPropertyDefinitionPatchBuilder setImmutable(boolean immutable) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/immutable", JsonNodeFactory.instance.booleanNode(immutable)));
        return this;
    }

    public StructuredPropertyDefinitionPatchBuilder setLastModified(@Nonnull AuditStamp lastModified) {
        ObjectNode lastModifiedValue = JsonNodeFactory.instance.objectNode();
        lastModifiedValue.put(TIME_KEY, lastModified.getTime());
        lastModifiedValue.put(ACTOR_KEY, lastModified.getActor().toString());
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/lastModified", lastModifiedValue));
        return this;
    }

    public StructuredPropertyDefinitionPatchBuilder setCreated(@Nonnull AuditStamp created) {
        ObjectNode createdValue = JsonNodeFactory.instance.objectNode();
        createdValue.put(TIME_KEY, created.getTime());
        createdValue.put(ACTOR_KEY, created.getActor().toString());
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/created", createdValue));
        return this;
    }

    @Override
    protected String getAspectName() {
        return "propertyDefinition";
    }

    @Override
    protected String getEntityType() {
        return "structuredProperty";
    }
}

