/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.builder;

import com.linkedin.common.Edge;
import com.linkedin.common.urn.ChartUrn;
import com.linkedin.common.urn.DashboardUrn;
import com.linkedin.common.urn.DatasetUrn;
import com.linkedin.common.urn.Urn;
import com.linkedin.metadata.aspect.patch.PatchOperationType;
import com.linkedin.metadata.aspect.patch.builder.AbstractMultiFieldPatchBuilder;
import com.linkedin.metadata.aspect.patch.builder.PatchUtil;
import datahub.shaded.jackson.databind.node.ObjectNode;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class DashboardInfoPatchBuilder
extends AbstractMultiFieldPatchBuilder<DashboardInfoPatchBuilder> {
    private static final String CHART_EDGES_PATH_START = "/chartEdges/";
    private static final String DATASET_EDGES_PATH_START = "/datasetEdges/";
    private static final String DASHBOARDS_PATH_START = "/dashboards/";

    public DashboardInfoPatchBuilder addChartEdge(@Nonnull ChartUrn urn) {
        ObjectNode value = PatchUtil.createEdgeValue(urn);
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), CHART_EDGES_PATH_START + String.valueOf(urn), value));
        return this;
    }

    public DashboardInfoPatchBuilder removeChartEdge(@Nonnull ChartUrn urn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), CHART_EDGES_PATH_START + String.valueOf(urn), null));
        return this;
    }

    public DashboardInfoPatchBuilder addDatasetEdge(@Nonnull DatasetUrn urn) {
        ObjectNode value = PatchUtil.createEdgeValue(urn);
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), DATASET_EDGES_PATH_START + String.valueOf(urn), value));
        return this;
    }

    public DashboardInfoPatchBuilder removeDatasetEdge(@Nonnull DatasetUrn urn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), DATASET_EDGES_PATH_START + String.valueOf(urn), null));
        return this;
    }

    public DashboardInfoPatchBuilder addDashboard(@Nonnull DashboardUrn urn) {
        ObjectNode value = PatchUtil.createEdgeValue(urn);
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), DASHBOARDS_PATH_START + String.valueOf(urn), value));
        return this;
    }

    public DashboardInfoPatchBuilder removeDashboard(@Nonnull DashboardUrn urn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), DASHBOARDS_PATH_START + String.valueOf(urn), null));
        return this;
    }

    public DashboardInfoPatchBuilder addEdge(@Nonnull Edge edge) {
        ObjectNode value = PatchUtil.createEdgeValue(edge);
        String path = this.getEdgePath(edge);
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), path, value));
        return this;
    }

    public DashboardInfoPatchBuilder removeEdge(@Nonnull Edge edge) {
        String path = this.getEdgePath(edge);
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), path, null));
        return this;
    }

    private String getEdgePath(@Nonnull Edge edge) {
        Urn destinationUrn = edge.getDestinationUrn();
        if ("dataset".equals(destinationUrn.getEntityType())) {
            return DATASET_EDGES_PATH_START + String.valueOf(destinationUrn);
        }
        if ("chart".equals(destinationUrn.getEntityType())) {
            return CHART_EDGES_PATH_START + String.valueOf(destinationUrn);
        }
        if ("dashboard".equals(destinationUrn.getEntityType())) {
            return DASHBOARDS_PATH_START + String.valueOf(destinationUrn);
        }
        throw new IllegalArgumentException(String.format("Unsupported entity type: %s", destinationUrn.getEntityType()));
    }

    @Override
    protected String getAspectName() {
        return "dashboardInfo";
    }

    @Override
    protected String getEntityType() {
        return "dashboard";
    }
}

