/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.batch;

import com.datahub.authorization.AuthorizationSession;
import com.linkedin.metadata.Constants;
import com.linkedin.metadata.aspect.ReadItem;
import com.linkedin.metadata.aspect.RetrieverContext;
import com.linkedin.metadata.aspect.SystemAspect;
import com.linkedin.metadata.aspect.batch.BatchItem;
import com.linkedin.metadata.aspect.batch.ChangeMCP;
import com.linkedin.metadata.aspect.batch.MCLItem;
import com.linkedin.metadata.aspect.batch.MCPItem;
import com.linkedin.metadata.aspect.plugins.hooks.MutationHook;
import com.linkedin.metadata.aspect.plugins.validation.ValidationExceptionCollection;
import com.linkedin.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public interface AspectsBatch {
    public Collection<? extends BatchItem> getItems();

    public Collection<? extends BatchItem> getInitialItems();

    public RetrieverContext getRetrieverContext();

    default public List<MCPItem> getMCPItems() {
        return this.getItems().stream().filter(item -> item instanceof MCPItem).map(item -> (MCPItem)item).collect(Collectors.toList());
    }

    public Pair<Map<String, Set<String>>, List<ChangeMCP>> toUpsertBatchItems(Map<String, Map<String, SystemAspect>> var1, Map<String, Map<String, Long>> var2, BiFunction<ChangeMCP, SystemAspect, SystemAspect> var3);

    default public void applyReadMutationHooks(Collection<ReadItem> items) {
        AspectsBatch.applyReadMutationHooks(items, this.getRetrieverContext());
    }

    public static void applyReadMutationHooks(Collection<ReadItem> items, @Nonnull RetrieverContext retrieverContext) {
        for (MutationHook mutationHook : retrieverContext.getAspectRetriever().getEntityRegistry().getAllMutationHooks()) {
            mutationHook.applyReadMutation(items, retrieverContext);
        }
    }

    default public void applyWriteMutationHooks(Collection<ChangeMCP> changeMCPS) {
        AspectsBatch.applyWriteMutationHooks(changeMCPS, this.getRetrieverContext());
    }

    public static void applyWriteMutationHooks(Collection<ChangeMCP> changeMCPS, @Nonnull RetrieverContext retrieverContext) {
        for (MutationHook mutationHook : retrieverContext.getAspectRetriever().getEntityRegistry().getAllMutationHooks()) {
            mutationHook.applyWriteMutation(changeMCPS, retrieverContext).count();
        }
    }

    default public Stream<MCPItem> applyProposalMutationHooks(Collection<MCPItem> proposedItems, @Nonnull RetrieverContext retrieverContext) {
        return retrieverContext.getAspectRetriever().getEntityRegistry().getAllMutationHooks().stream().flatMap(mutationHook -> mutationHook.applyProposalMutation(proposedItems, retrieverContext));
    }

    default public <T extends BatchItem> ValidationExceptionCollection validateProposed(Collection<T> mcpItems) {
        return AspectsBatch.validateProposed(mcpItems, this.getRetrieverContext(), null);
    }

    default public <T extends BatchItem> ValidationExceptionCollection validateProposed(Collection<T> mcpItems, @Nullable AuthorizationSession session) {
        return AspectsBatch.validateProposed(mcpItems, this.getRetrieverContext(), session);
    }

    public static <T extends BatchItem> ValidationExceptionCollection validateProposed(Collection<T> mcpItems, @Nonnull RetrieverContext retrieverContext, @Nullable AuthorizationSession session) {
        ValidationExceptionCollection exceptions = ValidationExceptionCollection.newCollection();
        retrieverContext.getAspectRetriever().getEntityRegistry().getAllAspectPayloadValidators().stream().flatMap(validator -> validator.validateProposed(mcpItems, retrieverContext, session)).forEach(exceptions::addException);
        return exceptions;
    }

    default public ValidationExceptionCollection validatePreCommit(Collection<ChangeMCP> changeMCPs) {
        return AspectsBatch.validatePreCommit(changeMCPs, this.getRetrieverContext());
    }

    public static ValidationExceptionCollection validatePreCommit(Collection<ChangeMCP> changeMCPs, @Nonnull RetrieverContext retrieverContext) {
        ValidationExceptionCollection exceptions = ValidationExceptionCollection.newCollection();
        retrieverContext.getAspectRetriever().getEntityRegistry().getAllAspectPayloadValidators().stream().flatMap(validator -> validator.validatePreCommit(changeMCPs, retrieverContext)).forEach(exceptions::addException);
        return exceptions;
    }

    default public Stream<ChangeMCP> applyMCPSideEffects(Collection<ChangeMCP> items) {
        return AspectsBatch.applyMCPSideEffects(items, this.getRetrieverContext());
    }

    public static Stream<ChangeMCP> applyMCPSideEffects(Collection<ChangeMCP> items, @Nonnull RetrieverContext retrieverContext) {
        return retrieverContext.getAspectRetriever().getEntityRegistry().getAllMCPSideEffects().stream().flatMap(mcpSideEffect -> mcpSideEffect.apply(items, retrieverContext));
    }

    default public Stream<MCPItem> applyPostMCPSideEffects(Collection<MCLItem> items) {
        return AspectsBatch.applyPostMCPSideEffects(items, this.getRetrieverContext());
    }

    public static Stream<MCPItem> applyPostMCPSideEffects(Collection<MCLItem> items, @Nonnull RetrieverContext retrieverContext) {
        return retrieverContext.getAspectRetriever().getEntityRegistry().getAllMCPSideEffects().stream().flatMap(mcpSideEffect -> mcpSideEffect.postApply(items, retrieverContext));
    }

    default public Stream<MCLItem> applyMCLSideEffects(Collection<MCLItem> items) {
        return AspectsBatch.applyMCLSideEffects(items, this.getRetrieverContext());
    }

    public static Stream<MCLItem> applyMCLSideEffects(Collection<MCLItem> items, @Nonnull RetrieverContext retrieverContext) {
        return retrieverContext.getAspectRetriever().getEntityRegistry().getAllMCLSideEffects().stream().flatMap(mclSideEffect -> mclSideEffect.apply(items, retrieverContext));
    }

    default public boolean containsDuplicateAspects() {
        return this.getInitialItems().stream().map(i -> String.format("%s_%s", i.getClass().getSimpleName(), i.hashCode())).distinct().count() != (long)this.getItems().size();
    }

    default public Map<String, List<? extends BatchItem>> duplicateAspects() {
        return this.getInitialItems().stream().collect(Collectors.groupingBy(i -> String.format("%s_%s", i.getClass().getSimpleName(), i.hashCode()))).entrySet().stream().filter(entry -> entry.getValue() != null && ((List)entry.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    default public Map<String, Set<String>> getUrnAspectsMap() {
        return this.getItems().stream().map(aspect -> Pair.of(aspect.getUrn().toString(), aspect.getAspectName())).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toSet())));
    }

    default public Map<String, Set<String>> getNewUrnAspectsMap(Map<String, Set<String>> existingMap, List<? extends BatchItem> items) {
        Map<String, HashSet> newItemsMap = items.stream().map(aspect -> Pair.of(aspect.getUrn().toString(), aspect.getAspectName())).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toCollection(HashSet::new))));
        return newItemsMap.entrySet().stream().filter(entry -> !existingMap.containsKey(entry.getKey()) || !((Set)existingMap.get(entry.getKey())).containsAll((Collection)entry.getValue())).peek(entry -> {
            if (existingMap.containsKey(entry.getKey())) {
                ((HashSet)entry.getValue()).removeAll((Collection)existingMap.get(entry.getKey()));
            }
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <T> Map<String, Map<String, T>> merge(@Nonnull Map<String, Map<String, T>> a, @Nonnull Map<String, Map<String, T>> b) {
        HashMap<String, Map<String, T>> mergedMap = new HashMap<String, Map<String, T>>();
        for (Map.Entry entry : Stream.concat(a.entrySet().stream(), b.entrySet().stream()).collect(Collectors.toList())) {
            mergedMap.computeIfAbsent((String)entry.getKey(), k -> new HashMap()).putAll((Map)entry.getValue());
        }
        return mergedMap;
    }

    default public String toAbbreviatedString(int maxWidth) {
        return AspectsBatch.toAbbreviatedString(this.getItems(), maxWidth);
    }

    public static String toAbbreviatedString(Collection<? extends BatchItem> items, int maxWidth) {
        ArrayList itemsAbbreviated = new ArrayList();
        items.forEach(item -> {
            if (item instanceof ChangeMCP) {
                itemsAbbreviated.add(((ChangeMCP)item).toAbbreviatedString());
            } else {
                itemsAbbreviated.add(item.toString());
            }
        });
        return "AspectsBatchImpl{items=" + StringUtils.abbreviate(((Object)itemsAbbreviated).toString(), maxWidth) + "}";
    }

    public static <T extends SystemAspect> ChangeMCP incrementBatchVersion(ChangeMCP changeMCP, Map<String, Map<String, T>> latestAspects, Map<String, Map<String, Long>> nextVersions, BiFunction<ChangeMCP, T, T> databaseUpsert) {
        long nextVersion = nextVersions.getOrDefault(changeMCP.getUrn().toString(), Collections.emptyMap()).getOrDefault(changeMCP.getAspectName(), Constants.ASPECT_LATEST_VERSION);
        SystemAspect currentSystemAspect = latestAspects.getOrDefault(changeMCP.getUrn().toString(), Collections.emptyMap()).getOrDefault(changeMCP.getAspectName(), null);
        changeMCP.setNextAspectVersion(nextVersion + 1L);
        latestAspects.computeIfAbsent(changeMCP.getUrn().toString(), key -> new HashMap()).put(changeMCP.getAspectName(), (SystemAspect)databaseUpsert.apply(changeMCP, (ChangeMCP)((Object)currentSystemAspect)));
        nextVersions.computeIfAbsent(changeMCP.getUrn().toString(), key -> new HashMap()).put(changeMCP.getAspectName(), changeMCP.getNextAspectVersion());
        return changeMCP;
    }
}

