/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect;

import com.linkedin.common.BrowsePaths;
import com.linkedin.common.BrowsePathsV2;
import com.linkedin.common.Cost;
import com.linkedin.common.DataPlatformInstance;
import com.linkedin.common.Deprecation;
import com.linkedin.common.GlobalTags;
import com.linkedin.common.InstitutionalMemory;
import com.linkedin.common.Ownership;
import com.linkedin.common.Status;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.HasTyperefInfo;
import com.linkedin.data.template.TyperefInfo;
import com.linkedin.data.template.UnionTemplate;
import com.linkedin.metadata.key.MLModelKey;
import com.linkedin.ml.metadata.CaveatsAndRecommendations;
import com.linkedin.ml.metadata.EthicalConsiderations;
import com.linkedin.ml.metadata.EvaluationData;
import com.linkedin.ml.metadata.IntendedUse;
import com.linkedin.ml.metadata.MLModelFactorPrompts;
import com.linkedin.ml.metadata.MLModelProperties;
import com.linkedin.ml.metadata.Metrics;
import com.linkedin.ml.metadata.QuantitativeAnalyses;
import com.linkedin.ml.metadata.SourceCode;
import com.linkedin.ml.metadata.TrainingData;
import java.util.List;
import java.util.function.Function;

public class MLModelAspect
extends UnionTemplate
implements HasTyperefInfo {
    private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema("union[{namespace com.linkedin.metadata.key/**Key for an ML model*/@Aspect.name=\"mlModelKey\"record MLModelKey{/**Standardized platform urn for the model*/platform:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Name of the MLModel*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}name:string/**Fabric type where model belongs to or where it was generated*/@Searchable={\"addToFilters\":true,\"fieldType\":\"TEXT_PARTIAL\",\"filterNameOverride\":\"Environment\",\"queryByDefault\":false}origin:{namespace com.linkedin.common/**Fabric group type*/enum FabricType{/**Designates development fabrics*/DEV/**Designates testing fabrics*/TEST/**Designates quality assurance fabrics*/QA/**Designates user acceptance testing fabrics*/UAT/**Designates early-integration fabrics*/EI/**Designates pre-production fabrics*/PRE/**Designates staging fabrics*/STG/**Designates non-production fabrics*/NON_PROD/**Designates production fabrics*/PROD/**Designates corporation fabrics*/CORP/**Designates review fabrics*/RVW/**Alternative Prod spelling*/PRD/**Alternative Test spelling*/TST/**System Integration Testing*/SIT/**Alternative spelling for sandbox*/SBX/**Designates sandbox fabrics*/SANDBOX}}}}{namespace com.linkedin.common/**Ownership information of an entity.*/@Aspect.name=\"ownership\"record Ownership{/**List of owners of the entity.*/owners:array[/**Ownership information*/record Owner{/**Owner URN, e.g. urn:li:corpuser:ldap, urn:li:corpGroup:group_name, and urn:li:multiProduct:mp_name\n(Caveat: only corpuser is currently supported in the frontend.)*/@Relationship={\"entityTypes\":[\"corpuser\",\"corpGroup\"],\"name\":\"OwnedBy\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"owners\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Owned By\",\"hasValuesFieldName\":\"hasOwners\",\"queryByDefault\":false}owner:Urn/**The type of the ownership*/@deprecated,type:/**Asset owner types*/enum OwnershipType{/**Set when ownership type is unknown or a when new one is specified as an ownership type entity for which we have no\nenum value for. This is used for backwards compatibility*/CUSTOM/**person or group who is responsible for technical aspects of the asset.*/TECHNICAL_OWNER/**A person or group who is responsible for logical, or business related, aspects of the asset.*/BUSINESS_OWNER/**A steward, expert, or delegate responsible for the asset.*/DATA_STEWARD/**No specific type associated to the owner.*/NONE/**A person or group that is in charge of developing the code\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DEVELOPER/**A person or group that is owning the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DATAOWNER/**A person or a group that overseas the operation, e.g. a DBA or SRE.\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DELEGATE/**A person, group, or service that produces/generates the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,PRODUCER/**A person, group, or service that consumes the data\nDeprecated! Use TECHNICAL_OWNER or BUSINESS_OWNER instead.*/@deprecated,CONSUMER/**A person or a group that has direct business interest\nDeprecated! Use TECHNICAL_OWNER, BUSINESS_OWNER, or STEWARD instead.*/@deprecated,STAKEHOLDER}/**The type of the ownership\nUrn of type O*/@Relationship={\"entityTypes\":[\"ownershipType\"],\"name\":\"ownershipType\"}typeUrn:optional Urn/**Source information for the ownership*/source:optional/**Source/provider of the ownership information*/record OwnershipSource{/**The type of the source*/type:enum OwnershipSourceType{/**Auditing system or audit logs*/AUDIT/**Database, e.g. GRANTS table*/DATABASE/**File system, e.g. file/directory owner*/FILE_SYSTEM/**Issue tracking system, e.g. Jira*/ISSUE_TRACKING_SYSTEM/**Manually provided by a user*/MANUAL/**Other ownership-like service, e.g. Nuage, ACL service etc*/SERVICE/**SCM system, e.g. GIT, SVN*/SOURCE_CONTROL/**Other sources*/OTHER}/**A reference URL for the source*/url:optional string}/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"ownerAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"ownerAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"ownerAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}]/**Ownership type to Owners map, populated via mutation hook.*/@Searchable.`/*`={\"fieldType\":\"MAP_ARRAY\",\"queryByDefault\":false}ownerTypes:optional map[string,array[Urn]]={}/**Audit stamp containing who last modified the record and when. A value of 0 in the time field indicates missing data.*/lastModified:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:Time/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}}}{namespace com.linkedin.ml.metadata/**Properties associated with a ML Model*/@Aspect.name=\"mlModelProperties\"record MLModelProperties includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{namespace com.linkedin.common/**A reference to an external platform.*/record ExternalReference{/**URL where the reference exist*/@Searchable.fieldType=\"KEYWORD\"externalUrl:optional@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}/**A set of re-usable fields used to capture lineage information for ML Models and ML Model Groups*/record MLModelLineageInfo{/**List of jobs or process instances (if any) used to train the model or group. Visible in Lineage. Note that ML Models can also be specified as the output of a specific Data Process Instances (runs) via the DataProcessInstanceOutputs aspect.*/@Relationship.`/*`={\"entityTypes\":[\"dataJob\",\"dataProcessInstance\"],\"isLineage\":true,\"name\":\"TrainedBy\"}trainingJobs:optional array[com.linkedin.common.Urn]/**List of jobs or process instances (if any) that use the model or group.*/@Relationship.`/*`={\"entityTypes\":[\"dataJob\",\"dataProcessInstance\"],\"isLineage\":true,\"isUpstream\":false,\"name\":\"UsedBy\"}downstreamJobs:optional array[com.linkedin.common.Urn]}{/**Display name of the MLModel*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true}name:optional string/**Documentation of the MLModel*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\"}description:optional string/**Date when the MLModel was developed*/@deprecated,date:optional com.linkedin.common.Time/**Audit stamp containing who created this and when*/created:optional{namespace com.linkedin.common/**A standard event timestamp*/record TimeStamp{/**When did the event occur*/time:Time/**Optional: The actor urn involved in the event.*/actor:optional Urn}}/**Date when the MLModel was last modified*/lastModified:optional com.linkedin.common.TimeStamp/**Version of the MLModel*/version:optional{namespace com.linkedin.common/**A resource-defined string representing the resource state for the purpose of concurrency control*/record VersionTag{versionTag:optional string,metadataAttribution:optional MetadataAttribution}}/**Type of Algorithm or MLModel such as whether it is a Naive Bayes classifier, Convolutional Neural Network, etc*/@Searchable.fieldType=\"TEXT_PARTIAL\"type:optional string/**Hyper Parameters of the MLModel\n\nNOTE: these are deprecated in favor of hyperParams*/hyperParameters:optional map[string/**A union of all supported metadata aspects for HyperParameter Value*/typeref HyperParameterValueType=union[string,int,float,double,boolean]]/**Hyperparameters of the MLModel*/hyperParams:optional array[/**Properties associated with an ML Hyper Param*/@Aspect.name=\"mlHyperParam\"record MLHyperParam{/**Name of the MLHyperParam*/name:string/**Documentation of the MLHyperParam*/description:optional string/**The value of the MLHyperParam*/value:optional string/**Date when the MLHyperParam was developed*/createdAt:optional com.linkedin.common.Time}]/**Metrics of the MLModel used in training*/trainingMetrics:optional array[/**Properties associated with an ML Metric*/@Aspect.name=\"mlMetric\"record MLMetric{/**Name of the mlMetric*/name:string/**Documentation of the mlMetric*/description:optional string/**The value of the mlMetric*/value:optional string/**Date when the mlMetric was developed*/createdAt:optional com.linkedin.common.Time}]/**Metrics of the MLModel used in production*/onlineMetrics:optional array[MLMetric]/**List of features used for MLModel training*/@Relationship.`/*`={\"entityTypes\":[\"mlFeature\"],\"isLineage\":true,\"name\":\"Consumes\"}mlFeatures:optional array[{namespace com.linkedin.common/**Standardized MLFeature identifier.*/@java.class=\"com.linkedin.common.urn.MLFeatureUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized MLFeature identifier.\",\"entityType\":\"mlFeature\",\"fields\":[{\"doc\":\"Namespace for the MLFeature\",\"name\":\"mlFeatureNamespace\",\"type\":\"string\"},{\"doc\":\"Name of the MLFeature\",\"maxLength\":210,\"name\":\"mlFeatureName\",\"type\":\"string\"}],\"maxLength\":284,\"name\":\"MLFeature\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref MLFeatureUrn=string}]/**Tags for the MLModel*/tags:array[string]=[]/**Deployments for the MLModel*/@Relationship.`/*`={\"entityTypes\":[\"mlModelDeployment\"],\"name\":\"DeployedTo\"}deployments:optional array[com.linkedin.common.Urn]/**Groups the model belongs to*/@Relationship.`/*`={\"entityTypes\":[\"mlModelGroup\"],\"isLineage\":true,\"isUpstream\":false,\"name\":\"MemberOf\"}groups:optional array[com.linkedin.common.Urn]}}{namespace com.linkedin.ml.metadata/**Intended Use for the ML Model*/@Aspect.name=\"intendedUse\"record IntendedUse{/**Primary Use cases for the MLModel.*/primaryUses:optional array[string]/**Primary Intended Users - For example, was the MLModel developed for entertainment purposes, for hobbyists, or enterprise solutions?*/primaryUsers:optional array[enum IntendedUserType{ENTERPRISE,HOBBY,ENTERTAINMENT}]/**Highlight technology that the MLModel might easily be confused with, or related contexts that users could try to apply the MLModel to.*/outOfScopeUses:optional array[string]}}{namespace com.linkedin.ml.metadata/**Prompts which affect the performance of the MLModel*/@Aspect.name=\"mlModelFactorPrompts\"record MLModelFactorPrompts{/**What are foreseeable salient factors for which MLModel performance may vary, and how were these determined?*/relevantFactors:optional array[/**Factors affecting the performance of the MLModel.*/record MLModelFactors{/**Groups refers to distinct categories with similar characteristics that are present in the evaluation data instances.\nFor human-centric machine learning MLModels, groups are people who share one or multiple characteristics.*/groups:optional array[string]/**The performance of a MLModel can vary depending on what instruments were used to capture the input to the MLModel.\nFor example, a face detection model may perform differently depending on the camera's hardware and software,\nincluding lens, image stabilization, high dynamic range techniques, and background blurring for portrait mode.*/instrumentation:optional array[string]/**A further factor affecting MLModel performance is the environment in which it is deployed.*/environment:optional array[string]}]/**Which factors are being reported, and why were these chosen?*/evaluationFactors:optional array[MLModelFactors]}}{namespace com.linkedin.ml.metadata/**Metrics to be featured for the MLModel.*/@Aspect.name=\"mlModelMetrics\"record Metrics{/**Measures of MLModel performance*/performanceMeasures:optional array[string]/**Decision Thresholds used (if any)?*/decisionThreshold:optional array[string]}}{namespace com.linkedin.ml.metadata/**All referenced datasets would ideally point to any set of documents that provide visibility into the source and composition of the dataset.*/@Aspect.name=\"mlModelEvaluationData\"record EvaluationData{/**Details on the dataset(s) used for the quantitative analyses in the MLModel*/evaluationData:array[/**BaseData record*/record BaseData{/**What dataset were used in the MLModel?*/dataset:{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}/**Why was this dataset chosen?*/motivation:optional string/**How was the data preprocessed (e.g., tokenization of sentences, cropping of images, any filtering such as dropping images without faces)?*/preProcessing:optional array[string]}]}}{namespace com.linkedin.ml.metadata/**Ideally, the MLModel card would contain as much information about the training data as the evaluation data. However, there might be cases where it is not feasible to provide this level of detailed information about the training data. For example, the data may be proprietary, or require a non-disclosure agreement. In these cases, we advocate for basic details about the distributions over groups in the data, as well as any other details that could inform stakeholders on the kinds of biases the model may have encoded.*/@Aspect.name=\"mlModelTrainingData\"record TrainingData{/**Details on the dataset(s) used for training the MLModel*/trainingData:array[BaseData]}}{namespace com.linkedin.ml.metadata/**Quantitative analyses should be disaggregated, that is, broken down by the chosen factors. Quantitative analyses should provide the results of evaluating the MLModel according to the chosen metrics, providing confidence interval values when possible.*/@Aspect.name=\"mlModelQuantitativeAnalyses\"record QuantitativeAnalyses{/**Link to a dashboard with results showing how the MLModel performed with respect to each factor*/unitaryResults:optional/**A union of all supported metadata aspects for ResultsType*/typeref ResultsType=union[string]/**Link to a dashboard with results showing how the MLModel performed with respect to the intersection of evaluated factors?*/intersectionalResults:optional ResultsType}}{namespace com.linkedin.ml.metadata/**This section is intended to demonstrate the ethical considerations that went into MLModel development, surfacing ethical challenges and solutions to stakeholders.*/@Aspect.name=\"mlModelEthicalConsiderations\"record EthicalConsiderations{/**Does the MLModel use any sensitive data (e.g., protected classes)?*/data:optional array[string]/** Is the MLModel intended to inform decisions about matters central to human life or flourishing - e.g., health or safety? Or could it be used in such a way?*/humanLife:optional array[string]/**What risk mitigation strategies were used during MLModel development?*/mitigations:optional array[string]/**What risks may be present in MLModel usage? Try to identify the potential recipients, likelihood, and magnitude of harms. If these cannot be determined, note that they were considered but remain unknown.*/risksAndHarms:optional array[string]/**Are there any known MLModel use cases that are especially fraught? This may connect directly to the intended use section*/useCases:optional array[string]}}{namespace com.linkedin.ml.metadata/**This section should list additional concerns that were not covered in the previous sections. For example, did the results suggest any further testing? Were there any relevant groups that were not represented in the evaluation dataset? Are there additional recommendations for model use?*/@Aspect.name=\"mlModelCaveatsAndRecommendations\"record CaveatsAndRecommendations{/**This section should list additional concerns that were not covered in the previous sections. For example, did the results suggest any further testing? Were there any relevant groups that were not represented in the evaluation dataset?*/caveats:optional/**This section should list additional concerns that were not covered in the previous sections. For example, did the results suggest any further testing? Were there any relevant groups that were not represented in the evaluation dataset? Are there additional recommendations for model use?*/record CaveatDetails{/**Did the results suggest any further testing?*/needsFurtherTesting:optional boolean/**Caveat Description\nFor ex: Given gender classes are binary (male/not male), which we include as male/female. Further work needed to evaluate across a spectrum of genders.*/caveatDescription:optional string/**Relevant groups that were not represented in the evaluation dataset?*/groupsNotRepresented:optional array[string]}/**Recommendations on where this MLModel should be used.*/recommendations:optional string/**Ideal characteristics of an evaluation dataset for this MLModel*/idealDatasetCharacteristics:optional array[string]}}{namespace com.linkedin.common/**Institutional memory of an entity. This is a way to link to relevant documentation and provide description of the documentation. Institutional or tribal knowledge is very important for users to leverage the entity.*/@Aspect.name=\"institutionalMemory\"record InstitutionalMemory{/**List of records that represent institutional memory of an entity. Each record consists of a link, description, creator and timestamps associated with that record.*/elements:array[/**Metadata corresponding to a record of institutional memory.*/record InstitutionalMemoryMetadata{/**Link to an engineering design document or a wiki page.*/url:Url/**Description of the link.*/description:string/**Audit stamp associated with creation of this record*/createStamp:AuditStamp/**Audit stamp associated with updation of this record*/updateStamp:optional AuditStamp}]}}{namespace com.linkedin.ml.metadata/**Source Code*/@Aspect.name=\"sourceCode\"record SourceCode{/**Source Code along with types*/sourceCode:array[/**Source Code Url Entity*/record SourceCodeUrl{/**Source Code Url Types*/type:enum SourceCodeUrlType{ML_MODEL_SOURCE_CODE,TRAINING_PIPELINE_SOURCE_CODE,EVALUATION_PIPELINE_SOURCE_CODE}/**Source Code Url*/sourceCodeUrl:com.linkedin.common.Url}]}}{namespace com.linkedin.common/**The lifecycle status metadata of an entity, e.g. dataset, metric, feature, etc.\nThis aspect is used to represent soft deletes conventionally.*/@Aspect.name=\"status\"record Status{/**Whether the entity has been removed (soft-deleted).*/@Searchable.fieldType=\"BOOLEAN\"removed:boolean=false}}{namespace com.linkedin.common@Aspect.name=\"cost\"record Cost{costType:/**Type of Cost Code*/enum CostType{/**Org Cost Type to which the Cost of this entity should be attributed to*/ORG_COST_TYPE}cost:/**A union of all supported Cost Value types*/typeref CostValue=union[costId:double,costCode:string]}}{namespace com.linkedin.common/**Deprecation status of an entity*/@Aspect.name=\"deprecation\"record Deprecation{/**Whether the entity is deprecated.*/@Searchable={\"addToFilters\":true,\"fieldType\":\"BOOLEAN\",\"filterNameOverride\":\"Deprecated\",\"weightsPerFieldValue\":{\"true\":0.5}}deprecated:boolean/**The time user plan to decommission this entity.*/decommissionTime:optional Time/**Additional information about the entity deprecation plan, such as the wiki, doc, RB.*/note:string/**The user URN which will be credited for modifying this deprecation content.*/actor:Urn,replacement:optional Urn}}{namespace com.linkedin.common/**Shared aspect containing Browse Paths to be indexed for an entity.*/@Aspect.name=\"browsePaths\"record BrowsePaths{/**A list of valid browse paths for the entity.\n\nBrowse paths are expected to be forward slash-separated strings. For example: 'prod/snowflake/datasetName'*/@Searchable.`/*`={\"fieldName\":\"browsePaths\",\"fieldType\":\"BROWSE_PATH\"}paths:array[string]}}{namespace com.linkedin.common/**Tag aspect used for applying tags to an entity*/@Aspect.name=\"globalTags\"record GlobalTags{/**Tags associated with a given entity*/@Relationship.`/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"TaggedWith\"}@Searchable.`/*/tag`={\"addToFilters\":true,\"boostScore\":0.5,\"fieldName\":\"tags\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Tag\",\"hasValuesFieldName\":\"hasTags\",\"queryByDefault\":true}tags:array[/**Properties of an applied tag. For now, just an Urn. In the future we can extend this with other properties, e.g.\npropagation parameters.*/record TagAssociation{/**Urn of the applied tag*/tag:/**Globally defined tag*/@java.class=\"com.linkedin.common.urn.TagUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Globally defined tags\",\"entityType\":\"tag\",\"fields\":[{\"doc\":\"tag name\",\"maxLength\":200,\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":220,\"name\":\"Tag\",\"namespace\":\"li\",\"owners\":[],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref TagUrn=string/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"tagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"tagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"tagAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional MetadataAttribution}]}}{namespace com.linkedin.common/**The specific instance of the data platform that this entity belongs to*/@Aspect.name=\"dataPlatformInstance\"record DataPlatformInstance{/**Data Platform*/@Searchable={\"addToFilters\":true,\"fieldType\":\"URN\",\"filterNameOverride\":\"Platform\"}platform:Urn/**Instance of the data platform (e.g. db instance)*/@Searchable={\"addToFilters\":true,\"fieldName\":\"platformInstance\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Platform Instance\"}instance:optional Urn}}{namespace com.linkedin.common/**Shared aspect containing a Browse Path to be indexed for an entity.*/@Aspect.name=\"browsePathsV2\"record BrowsePathsV2{/**A valid browse path for the entity. This field is provided by DataHub by default.\nThis aspect is a newer version of browsePaths where we can encode more information in the path.\nThis path is also based on containers for a given entity if it has containers.\n\nThis is stored in elasticsearch as unit-separator delimited strings and only includes platform specific folders or containers.\nThese paths should not include high level info captured elsewhere ie. Platform and Environment.*/@Searchable.`/*/id`={\"fieldName\":\"browsePathV2\",\"fieldType\":\"BROWSE_PATH_V2\"}path:array[/**Represents a single level in an entity's browsePathV2*/record BrowsePathEntry{/**The ID of the browse path entry. This is what gets stored in the index.\nIf there's an urn associated with this entry, id and urn will be the same*/id:string/**Optional urn pointing to some entity in DataHub*/urn:optional Urn}]}}]", SchemaFormatType.PDL);
    private MLModelKey _mLModelKeyMember = null;
    private Ownership _ownershipMember = null;
    private MLModelProperties _mLModelPropertiesMember = null;
    private IntendedUse _intendedUseMember = null;
    private MLModelFactorPrompts _mLModelFactorPromptsMember = null;
    private Metrics _metricsMember = null;
    private EvaluationData _evaluationDataMember = null;
    private TrainingData _trainingDataMember = null;
    private QuantitativeAnalyses _quantitativeAnalysesMember = null;
    private EthicalConsiderations _ethicalConsiderationsMember = null;
    private CaveatsAndRecommendations _caveatsAndRecommendationsMember = null;
    private InstitutionalMemory _institutionalMemoryMember = null;
    private SourceCode _sourceCodeMember = null;
    private Status _statusMember = null;
    private Cost _costMember = null;
    private Deprecation _deprecationMember = null;
    private BrowsePaths _browsePathsMember = null;
    private GlobalTags _globalTagsMember = null;
    private DataPlatformInstance _dataPlatformInstanceMember = null;
    private BrowsePathsV2 _browsePathsV2Member = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final DataSchema MEMBER_MLModelKey = SCHEMA.getTypeByMemberKey("com.linkedin.metadata.key.MLModelKey");
    public static final String MEMBERKEY_MLModelKey = "com.linkedin.metadata.key.MLModelKey";
    private static final DataSchema MEMBER_Ownership = SCHEMA.getTypeByMemberKey("com.linkedin.common.Ownership");
    public static final String MEMBERKEY_Ownership = "com.linkedin.common.Ownership";
    private static final DataSchema MEMBER_MLModelProperties = SCHEMA.getTypeByMemberKey("com.linkedin.ml.metadata.MLModelProperties");
    public static final String MEMBERKEY_MLModelProperties = "com.linkedin.ml.metadata.MLModelProperties";
    private static final DataSchema MEMBER_IntendedUse = SCHEMA.getTypeByMemberKey("com.linkedin.ml.metadata.IntendedUse");
    public static final String MEMBERKEY_IntendedUse = "com.linkedin.ml.metadata.IntendedUse";
    private static final DataSchema MEMBER_MLModelFactorPrompts = SCHEMA.getTypeByMemberKey("com.linkedin.ml.metadata.MLModelFactorPrompts");
    public static final String MEMBERKEY_MLModelFactorPrompts = "com.linkedin.ml.metadata.MLModelFactorPrompts";
    private static final DataSchema MEMBER_Metrics = SCHEMA.getTypeByMemberKey("com.linkedin.ml.metadata.Metrics");
    public static final String MEMBERKEY_Metrics = "com.linkedin.ml.metadata.Metrics";
    private static final DataSchema MEMBER_EvaluationData = SCHEMA.getTypeByMemberKey("com.linkedin.ml.metadata.EvaluationData");
    public static final String MEMBERKEY_EvaluationData = "com.linkedin.ml.metadata.EvaluationData";
    private static final DataSchema MEMBER_TrainingData = SCHEMA.getTypeByMemberKey("com.linkedin.ml.metadata.TrainingData");
    public static final String MEMBERKEY_TrainingData = "com.linkedin.ml.metadata.TrainingData";
    private static final DataSchema MEMBER_QuantitativeAnalyses = SCHEMA.getTypeByMemberKey("com.linkedin.ml.metadata.QuantitativeAnalyses");
    public static final String MEMBERKEY_QuantitativeAnalyses = "com.linkedin.ml.metadata.QuantitativeAnalyses";
    private static final DataSchema MEMBER_EthicalConsiderations = SCHEMA.getTypeByMemberKey("com.linkedin.ml.metadata.EthicalConsiderations");
    public static final String MEMBERKEY_EthicalConsiderations = "com.linkedin.ml.metadata.EthicalConsiderations";
    private static final DataSchema MEMBER_CaveatsAndRecommendations = SCHEMA.getTypeByMemberKey("com.linkedin.ml.metadata.CaveatsAndRecommendations");
    public static final String MEMBERKEY_CaveatsAndRecommendations = "com.linkedin.ml.metadata.CaveatsAndRecommendations";
    private static final DataSchema MEMBER_InstitutionalMemory = SCHEMA.getTypeByMemberKey("com.linkedin.common.InstitutionalMemory");
    public static final String MEMBERKEY_InstitutionalMemory = "com.linkedin.common.InstitutionalMemory";
    private static final DataSchema MEMBER_SourceCode = SCHEMA.getTypeByMemberKey("com.linkedin.ml.metadata.SourceCode");
    public static final String MEMBERKEY_SourceCode = "com.linkedin.ml.metadata.SourceCode";
    private static final DataSchema MEMBER_Status = SCHEMA.getTypeByMemberKey("com.linkedin.common.Status");
    public static final String MEMBERKEY_Status = "com.linkedin.common.Status";
    private static final DataSchema MEMBER_Cost = SCHEMA.getTypeByMemberKey("com.linkedin.common.Cost");
    public static final String MEMBERKEY_Cost = "com.linkedin.common.Cost";
    private static final DataSchema MEMBER_Deprecation = SCHEMA.getTypeByMemberKey("com.linkedin.common.Deprecation");
    public static final String MEMBERKEY_Deprecation = "com.linkedin.common.Deprecation";
    private static final DataSchema MEMBER_BrowsePaths = SCHEMA.getTypeByMemberKey("com.linkedin.common.BrowsePaths");
    public static final String MEMBERKEY_BrowsePaths = "com.linkedin.common.BrowsePaths";
    private static final DataSchema MEMBER_GlobalTags = SCHEMA.getTypeByMemberKey("com.linkedin.common.GlobalTags");
    public static final String MEMBERKEY_GlobalTags = "com.linkedin.common.GlobalTags";
    private static final DataSchema MEMBER_DataPlatformInstance = SCHEMA.getTypeByMemberKey("com.linkedin.common.DataPlatformInstance");
    public static final String MEMBERKEY_DataPlatformInstance = "com.linkedin.common.DataPlatformInstance";
    private static final DataSchema MEMBER_BrowsePathsV2 = SCHEMA.getTypeByMemberKey("com.linkedin.common.BrowsePathsV2");
    public static final String MEMBERKEY_BrowsePathsV2 = "com.linkedin.common.BrowsePathsV2";
    private static final TyperefInfo TYPEREFINFO = new UnionTyperefInfo();

    public MLModelAspect() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public MLModelAspect(Object data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static UnionDataSchema dataSchema() {
        return SCHEMA;
    }

    public static MLModelAspect create(MLModelKey value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setMLModelKey(value);
        return newUnion;
    }

    public boolean isMLModelKey() {
        return this.memberIs(MEMBERKEY_MLModelKey);
    }

    public MLModelKey getMLModelKey() {
        this.checkNotNull();
        if (this._mLModelKeyMember != null) {
            return this._mLModelKeyMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_MLModelKey);
        this._mLModelKeyMember = __rawValue == null ? null : new MLModelKey(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._mLModelKeyMember;
    }

    public void setMLModelKey(MLModelKey value) {
        this.checkNotNull();
        this._map.clear();
        this._mLModelKeyMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_MLModelKey, value.data());
    }

    public static MLModelAspect create(Ownership value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setOwnership(value);
        return newUnion;
    }

    public boolean isOwnership() {
        return this.memberIs(MEMBERKEY_Ownership);
    }

    public Ownership getOwnership() {
        this.checkNotNull();
        if (this._ownershipMember != null) {
            return this._ownershipMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_Ownership);
        this._ownershipMember = __rawValue == null ? null : new Ownership(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._ownershipMember;
    }

    public void setOwnership(Ownership value) {
        this.checkNotNull();
        this._map.clear();
        this._ownershipMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Ownership, value.data());
    }

    public static MLModelAspect create(MLModelProperties value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setMLModelProperties(value);
        return newUnion;
    }

    public boolean isMLModelProperties() {
        return this.memberIs(MEMBERKEY_MLModelProperties);
    }

    public MLModelProperties getMLModelProperties() {
        this.checkNotNull();
        if (this._mLModelPropertiesMember != null) {
            return this._mLModelPropertiesMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_MLModelProperties);
        this._mLModelPropertiesMember = __rawValue == null ? null : new MLModelProperties(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._mLModelPropertiesMember;
    }

    public void setMLModelProperties(MLModelProperties value) {
        this.checkNotNull();
        this._map.clear();
        this._mLModelPropertiesMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_MLModelProperties, value.data());
    }

    public static MLModelAspect create(IntendedUse value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setIntendedUse(value);
        return newUnion;
    }

    public boolean isIntendedUse() {
        return this.memberIs(MEMBERKEY_IntendedUse);
    }

    public IntendedUse getIntendedUse() {
        this.checkNotNull();
        if (this._intendedUseMember != null) {
            return this._intendedUseMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_IntendedUse);
        this._intendedUseMember = __rawValue == null ? null : new IntendedUse(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._intendedUseMember;
    }

    public void setIntendedUse(IntendedUse value) {
        this.checkNotNull();
        this._map.clear();
        this._intendedUseMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_IntendedUse, value.data());
    }

    public static MLModelAspect create(MLModelFactorPrompts value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setMLModelFactorPrompts(value);
        return newUnion;
    }

    public boolean isMLModelFactorPrompts() {
        return this.memberIs(MEMBERKEY_MLModelFactorPrompts);
    }

    public MLModelFactorPrompts getMLModelFactorPrompts() {
        this.checkNotNull();
        if (this._mLModelFactorPromptsMember != null) {
            return this._mLModelFactorPromptsMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_MLModelFactorPrompts);
        this._mLModelFactorPromptsMember = __rawValue == null ? null : new MLModelFactorPrompts(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._mLModelFactorPromptsMember;
    }

    public void setMLModelFactorPrompts(MLModelFactorPrompts value) {
        this.checkNotNull();
        this._map.clear();
        this._mLModelFactorPromptsMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_MLModelFactorPrompts, value.data());
    }

    public static MLModelAspect create(Metrics value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setMetrics(value);
        return newUnion;
    }

    public boolean isMetrics() {
        return this.memberIs(MEMBERKEY_Metrics);
    }

    public Metrics getMetrics() {
        this.checkNotNull();
        if (this._metricsMember != null) {
            return this._metricsMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_Metrics);
        this._metricsMember = __rawValue == null ? null : new Metrics(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._metricsMember;
    }

    public void setMetrics(Metrics value) {
        this.checkNotNull();
        this._map.clear();
        this._metricsMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Metrics, value.data());
    }

    public static MLModelAspect create(EvaluationData value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setEvaluationData(value);
        return newUnion;
    }

    public boolean isEvaluationData() {
        return this.memberIs(MEMBERKEY_EvaluationData);
    }

    public EvaluationData getEvaluationData() {
        this.checkNotNull();
        if (this._evaluationDataMember != null) {
            return this._evaluationDataMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_EvaluationData);
        this._evaluationDataMember = __rawValue == null ? null : new EvaluationData(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._evaluationDataMember;
    }

    public void setEvaluationData(EvaluationData value) {
        this.checkNotNull();
        this._map.clear();
        this._evaluationDataMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_EvaluationData, value.data());
    }

    public static MLModelAspect create(TrainingData value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setTrainingData(value);
        return newUnion;
    }

    public boolean isTrainingData() {
        return this.memberIs(MEMBERKEY_TrainingData);
    }

    public TrainingData getTrainingData() {
        this.checkNotNull();
        if (this._trainingDataMember != null) {
            return this._trainingDataMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_TrainingData);
        this._trainingDataMember = __rawValue == null ? null : new TrainingData(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._trainingDataMember;
    }

    public void setTrainingData(TrainingData value) {
        this.checkNotNull();
        this._map.clear();
        this._trainingDataMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_TrainingData, value.data());
    }

    public static MLModelAspect create(QuantitativeAnalyses value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setQuantitativeAnalyses(value);
        return newUnion;
    }

    public boolean isQuantitativeAnalyses() {
        return this.memberIs(MEMBERKEY_QuantitativeAnalyses);
    }

    public QuantitativeAnalyses getQuantitativeAnalyses() {
        this.checkNotNull();
        if (this._quantitativeAnalysesMember != null) {
            return this._quantitativeAnalysesMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_QuantitativeAnalyses);
        this._quantitativeAnalysesMember = __rawValue == null ? null : new QuantitativeAnalyses(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._quantitativeAnalysesMember;
    }

    public void setQuantitativeAnalyses(QuantitativeAnalyses value) {
        this.checkNotNull();
        this._map.clear();
        this._quantitativeAnalysesMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_QuantitativeAnalyses, value.data());
    }

    public static MLModelAspect create(EthicalConsiderations value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setEthicalConsiderations(value);
        return newUnion;
    }

    public boolean isEthicalConsiderations() {
        return this.memberIs(MEMBERKEY_EthicalConsiderations);
    }

    public EthicalConsiderations getEthicalConsiderations() {
        this.checkNotNull();
        if (this._ethicalConsiderationsMember != null) {
            return this._ethicalConsiderationsMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_EthicalConsiderations);
        this._ethicalConsiderationsMember = __rawValue == null ? null : new EthicalConsiderations(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._ethicalConsiderationsMember;
    }

    public void setEthicalConsiderations(EthicalConsiderations value) {
        this.checkNotNull();
        this._map.clear();
        this._ethicalConsiderationsMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_EthicalConsiderations, value.data());
    }

    public static MLModelAspect create(CaveatsAndRecommendations value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setCaveatsAndRecommendations(value);
        return newUnion;
    }

    public boolean isCaveatsAndRecommendations() {
        return this.memberIs(MEMBERKEY_CaveatsAndRecommendations);
    }

    public CaveatsAndRecommendations getCaveatsAndRecommendations() {
        this.checkNotNull();
        if (this._caveatsAndRecommendationsMember != null) {
            return this._caveatsAndRecommendationsMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_CaveatsAndRecommendations);
        this._caveatsAndRecommendationsMember = __rawValue == null ? null : new CaveatsAndRecommendations(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._caveatsAndRecommendationsMember;
    }

    public void setCaveatsAndRecommendations(CaveatsAndRecommendations value) {
        this.checkNotNull();
        this._map.clear();
        this._caveatsAndRecommendationsMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_CaveatsAndRecommendations, value.data());
    }

    public static MLModelAspect create(InstitutionalMemory value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setInstitutionalMemory(value);
        return newUnion;
    }

    public boolean isInstitutionalMemory() {
        return this.memberIs(MEMBERKEY_InstitutionalMemory);
    }

    public InstitutionalMemory getInstitutionalMemory() {
        this.checkNotNull();
        if (this._institutionalMemoryMember != null) {
            return this._institutionalMemoryMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_InstitutionalMemory);
        this._institutionalMemoryMember = __rawValue == null ? null : new InstitutionalMemory(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._institutionalMemoryMember;
    }

    public void setInstitutionalMemory(InstitutionalMemory value) {
        this.checkNotNull();
        this._map.clear();
        this._institutionalMemoryMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_InstitutionalMemory, value.data());
    }

    public static MLModelAspect create(SourceCode value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setSourceCode(value);
        return newUnion;
    }

    public boolean isSourceCode() {
        return this.memberIs(MEMBERKEY_SourceCode);
    }

    public SourceCode getSourceCode() {
        this.checkNotNull();
        if (this._sourceCodeMember != null) {
            return this._sourceCodeMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_SourceCode);
        this._sourceCodeMember = __rawValue == null ? null : new SourceCode(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._sourceCodeMember;
    }

    public void setSourceCode(SourceCode value) {
        this.checkNotNull();
        this._map.clear();
        this._sourceCodeMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_SourceCode, value.data());
    }

    public static MLModelAspect create(Status value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setStatus(value);
        return newUnion;
    }

    public boolean isStatus() {
        return this.memberIs(MEMBERKEY_Status);
    }

    public Status getStatus() {
        this.checkNotNull();
        if (this._statusMember != null) {
            return this._statusMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_Status);
        this._statusMember = __rawValue == null ? null : new Status(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._statusMember;
    }

    public void setStatus(Status value) {
        this.checkNotNull();
        this._map.clear();
        this._statusMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Status, value.data());
    }

    public static MLModelAspect create(Cost value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setCost(value);
        return newUnion;
    }

    public boolean isCost() {
        return this.memberIs(MEMBERKEY_Cost);
    }

    public Cost getCost() {
        this.checkNotNull();
        if (this._costMember != null) {
            return this._costMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_Cost);
        this._costMember = __rawValue == null ? null : new Cost(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._costMember;
    }

    public void setCost(Cost value) {
        this.checkNotNull();
        this._map.clear();
        this._costMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Cost, value.data());
    }

    public static MLModelAspect create(Deprecation value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setDeprecation(value);
        return newUnion;
    }

    public boolean isDeprecation() {
        return this.memberIs(MEMBERKEY_Deprecation);
    }

    public Deprecation getDeprecation() {
        this.checkNotNull();
        if (this._deprecationMember != null) {
            return this._deprecationMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_Deprecation);
        this._deprecationMember = __rawValue == null ? null : new Deprecation(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._deprecationMember;
    }

    public void setDeprecation(Deprecation value) {
        this.checkNotNull();
        this._map.clear();
        this._deprecationMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Deprecation, value.data());
    }

    public static MLModelAspect create(BrowsePaths value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setBrowsePaths(value);
        return newUnion;
    }

    public boolean isBrowsePaths() {
        return this.memberIs(MEMBERKEY_BrowsePaths);
    }

    public BrowsePaths getBrowsePaths() {
        this.checkNotNull();
        if (this._browsePathsMember != null) {
            return this._browsePathsMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_BrowsePaths);
        this._browsePathsMember = __rawValue == null ? null : new BrowsePaths(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._browsePathsMember;
    }

    public void setBrowsePaths(BrowsePaths value) {
        this.checkNotNull();
        this._map.clear();
        this._browsePathsMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_BrowsePaths, value.data());
    }

    public static MLModelAspect create(GlobalTags value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setGlobalTags(value);
        return newUnion;
    }

    public boolean isGlobalTags() {
        return this.memberIs(MEMBERKEY_GlobalTags);
    }

    public GlobalTags getGlobalTags() {
        this.checkNotNull();
        if (this._globalTagsMember != null) {
            return this._globalTagsMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_GlobalTags);
        this._globalTagsMember = __rawValue == null ? null : new GlobalTags(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._globalTagsMember;
    }

    public void setGlobalTags(GlobalTags value) {
        this.checkNotNull();
        this._map.clear();
        this._globalTagsMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_GlobalTags, value.data());
    }

    public static MLModelAspect create(DataPlatformInstance value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setDataPlatformInstance(value);
        return newUnion;
    }

    public boolean isDataPlatformInstance() {
        return this.memberIs(MEMBERKEY_DataPlatformInstance);
    }

    public DataPlatformInstance getDataPlatformInstance() {
        this.checkNotNull();
        if (this._dataPlatformInstanceMember != null) {
            return this._dataPlatformInstanceMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_DataPlatformInstance);
        this._dataPlatformInstanceMember = __rawValue == null ? null : new DataPlatformInstance(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._dataPlatformInstanceMember;
    }

    public void setDataPlatformInstance(DataPlatformInstance value) {
        this.checkNotNull();
        this._map.clear();
        this._dataPlatformInstanceMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_DataPlatformInstance, value.data());
    }

    public static MLModelAspect create(BrowsePathsV2 value) {
        MLModelAspect newUnion = new MLModelAspect();
        newUnion.setBrowsePathsV2(value);
        return newUnion;
    }

    public boolean isBrowsePathsV2() {
        return this.memberIs(MEMBERKEY_BrowsePathsV2);
    }

    public BrowsePathsV2 getBrowsePathsV2() {
        this.checkNotNull();
        if (this._browsePathsV2Member != null) {
            return this._browsePathsV2Member;
        }
        Object __rawValue = this._map.get(MEMBERKEY_BrowsePathsV2);
        this._browsePathsV2Member = __rawValue == null ? null : new BrowsePathsV2(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._browsePathsV2Member;
    }

    public void setBrowsePathsV2(BrowsePathsV2 value) {
        this.checkNotNull();
        this._map.clear();
        this._browsePathsV2Member = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_BrowsePathsV2, value.data());
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public MLModelAspect clone() throws CloneNotSupportedException {
        MLModelAspect __clone = (MLModelAspect)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public MLModelAspect copy() throws CloneNotSupportedException {
        MLModelAspect __copy = (MLModelAspect)super.copy();
        __copy._trainingDataMember = null;
        __copy._costMember = null;
        __copy._mLModelFactorPromptsMember = null;
        __copy._mLModelKeyMember = null;
        __copy._metricsMember = null;
        __copy._quantitativeAnalysesMember = null;
        __copy._mLModelPropertiesMember = null;
        __copy._intendedUseMember = null;
        __copy._browsePathsMember = null;
        __copy._globalTagsMember = null;
        __copy._dataPlatformInstanceMember = null;
        __copy._browsePathsV2Member = null;
        __copy._ownershipMember = null;
        __copy._sourceCodeMember = null;
        __copy._ethicalConsiderationsMember = null;
        __copy._caveatsAndRecommendationsMember = null;
        __copy._institutionalMemoryMember = null;
        __copy._deprecationMember = null;
        __copy._evaluationDataMember = null;
        __copy._statusMember = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    @Override
    public TyperefInfo typerefInfo() {
        return TYPEREFINFO;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final MLModelAspect __objectRef;

        private ChangeListener(MLModelAspect reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "com.linkedin.ml.metadata.TrainingData": {
                    this.__objectRef._trainingDataMember = null;
                    break;
                }
                case "com.linkedin.common.Cost": {
                    this.__objectRef._costMember = null;
                    break;
                }
                case "com.linkedin.ml.metadata.MLModelFactorPrompts": {
                    this.__objectRef._mLModelFactorPromptsMember = null;
                    break;
                }
                case "com.linkedin.metadata.key.MLModelKey": {
                    this.__objectRef._mLModelKeyMember = null;
                    break;
                }
                case "com.linkedin.ml.metadata.Metrics": {
                    this.__objectRef._metricsMember = null;
                    break;
                }
                case "com.linkedin.ml.metadata.QuantitativeAnalyses": {
                    this.__objectRef._quantitativeAnalysesMember = null;
                    break;
                }
                case "com.linkedin.ml.metadata.MLModelProperties": {
                    this.__objectRef._mLModelPropertiesMember = null;
                    break;
                }
                case "com.linkedin.ml.metadata.IntendedUse": {
                    this.__objectRef._intendedUseMember = null;
                    break;
                }
                case "com.linkedin.common.BrowsePaths": {
                    this.__objectRef._browsePathsMember = null;
                    break;
                }
                case "com.linkedin.common.GlobalTags": {
                    this.__objectRef._globalTagsMember = null;
                    break;
                }
                case "com.linkedin.common.DataPlatformInstance": {
                    this.__objectRef._dataPlatformInstanceMember = null;
                    break;
                }
                case "com.linkedin.common.BrowsePathsV2": {
                    this.__objectRef._browsePathsV2Member = null;
                    break;
                }
                case "com.linkedin.common.Ownership": {
                    this.__objectRef._ownershipMember = null;
                    break;
                }
                case "com.linkedin.ml.metadata.SourceCode": {
                    this.__objectRef._sourceCodeMember = null;
                    break;
                }
                case "com.linkedin.ml.metadata.EthicalConsiderations": {
                    this.__objectRef._ethicalConsiderationsMember = null;
                    break;
                }
                case "com.linkedin.ml.metadata.CaveatsAndRecommendations": {
                    this.__objectRef._caveatsAndRecommendationsMember = null;
                    break;
                }
                case "com.linkedin.common.InstitutionalMemory": {
                    this.__objectRef._institutionalMemoryMember = null;
                    break;
                }
                case "com.linkedin.common.Deprecation": {
                    this.__objectRef._deprecationMember = null;
                    break;
                }
                case "com.linkedin.ml.metadata.EvaluationData": {
                    this.__objectRef._evaluationDataMember = null;
                    break;
                }
                case "com.linkedin.common.Status": {
                    this.__objectRef._statusMember = null;
                }
            }
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private MLModelKey.ProjectionMask _MLModelKeyMask;
        private Ownership.ProjectionMask _OwnershipMask;
        private MLModelProperties.ProjectionMask _MLModelPropertiesMask;
        private IntendedUse.ProjectionMask _IntendedUseMask;
        private MLModelFactorPrompts.ProjectionMask _MLModelFactorPromptsMask;
        private Metrics.ProjectionMask _MetricsMask;
        private EvaluationData.ProjectionMask _EvaluationDataMask;
        private TrainingData.ProjectionMask _TrainingDataMask;
        private QuantitativeAnalyses.ProjectionMask _QuantitativeAnalysesMask;
        private EthicalConsiderations.ProjectionMask _EthicalConsiderationsMask;
        private CaveatsAndRecommendations.ProjectionMask _CaveatsAndRecommendationsMask;
        private InstitutionalMemory.ProjectionMask _InstitutionalMemoryMask;
        private SourceCode.ProjectionMask _SourceCodeMask;
        private Status.ProjectionMask _StatusMask;
        private Cost.ProjectionMask _CostMask;
        private Deprecation.ProjectionMask _DeprecationMask;
        private BrowsePaths.ProjectionMask _BrowsePathsMask;
        private GlobalTags.ProjectionMask _GlobalTagsMask;
        private DataPlatformInstance.ProjectionMask _DataPlatformInstanceMask;
        private BrowsePathsV2.ProjectionMask _BrowsePathsV2Mask;

        ProjectionMask() {
        }

        public ProjectionMask withMLModelKey(Function<MLModelKey.ProjectionMask, MLModelKey.ProjectionMask> nestedMask) {
            this._MLModelKeyMask = nestedMask.apply(this._MLModelKeyMask == null ? MLModelKey.createMask() : this._MLModelKeyMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_MLModelKey, this._MLModelKeyMask.getDataMap());
            return this;
        }

        public ProjectionMask withOwnership(Function<Ownership.ProjectionMask, Ownership.ProjectionMask> nestedMask) {
            this._OwnershipMask = nestedMask.apply(this._OwnershipMask == null ? Ownership.createMask() : this._OwnershipMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_Ownership, this._OwnershipMask.getDataMap());
            return this;
        }

        public ProjectionMask withMLModelProperties(Function<MLModelProperties.ProjectionMask, MLModelProperties.ProjectionMask> nestedMask) {
            this._MLModelPropertiesMask = nestedMask.apply(this._MLModelPropertiesMask == null ? MLModelProperties.createMask() : this._MLModelPropertiesMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_MLModelProperties, this._MLModelPropertiesMask.getDataMap());
            return this;
        }

        public ProjectionMask withIntendedUse(Function<IntendedUse.ProjectionMask, IntendedUse.ProjectionMask> nestedMask) {
            this._IntendedUseMask = nestedMask.apply(this._IntendedUseMask == null ? IntendedUse.createMask() : this._IntendedUseMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_IntendedUse, this._IntendedUseMask.getDataMap());
            return this;
        }

        public ProjectionMask withMLModelFactorPrompts(Function<MLModelFactorPrompts.ProjectionMask, MLModelFactorPrompts.ProjectionMask> nestedMask) {
            this._MLModelFactorPromptsMask = nestedMask.apply(this._MLModelFactorPromptsMask == null ? MLModelFactorPrompts.createMask() : this._MLModelFactorPromptsMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_MLModelFactorPrompts, this._MLModelFactorPromptsMask.getDataMap());
            return this;
        }

        public ProjectionMask withMetrics(Function<Metrics.ProjectionMask, Metrics.ProjectionMask> nestedMask) {
            this._MetricsMask = nestedMask.apply(this._MetricsMask == null ? Metrics.createMask() : this._MetricsMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_Metrics, this._MetricsMask.getDataMap());
            return this;
        }

        public ProjectionMask withEvaluationData(Function<EvaluationData.ProjectionMask, EvaluationData.ProjectionMask> nestedMask) {
            this._EvaluationDataMask = nestedMask.apply(this._EvaluationDataMask == null ? EvaluationData.createMask() : this._EvaluationDataMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_EvaluationData, this._EvaluationDataMask.getDataMap());
            return this;
        }

        public ProjectionMask withTrainingData(Function<TrainingData.ProjectionMask, TrainingData.ProjectionMask> nestedMask) {
            this._TrainingDataMask = nestedMask.apply(this._TrainingDataMask == null ? TrainingData.createMask() : this._TrainingDataMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_TrainingData, this._TrainingDataMask.getDataMap());
            return this;
        }

        public ProjectionMask withQuantitativeAnalyses(Function<QuantitativeAnalyses.ProjectionMask, QuantitativeAnalyses.ProjectionMask> nestedMask) {
            this._QuantitativeAnalysesMask = nestedMask.apply(this._QuantitativeAnalysesMask == null ? QuantitativeAnalyses.createMask() : this._QuantitativeAnalysesMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_QuantitativeAnalyses, this._QuantitativeAnalysesMask.getDataMap());
            return this;
        }

        public ProjectionMask withEthicalConsiderations(Function<EthicalConsiderations.ProjectionMask, EthicalConsiderations.ProjectionMask> nestedMask) {
            this._EthicalConsiderationsMask = nestedMask.apply(this._EthicalConsiderationsMask == null ? EthicalConsiderations.createMask() : this._EthicalConsiderationsMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_EthicalConsiderations, this._EthicalConsiderationsMask.getDataMap());
            return this;
        }

        public ProjectionMask withCaveatsAndRecommendations(Function<CaveatsAndRecommendations.ProjectionMask, CaveatsAndRecommendations.ProjectionMask> nestedMask) {
            this._CaveatsAndRecommendationsMask = nestedMask.apply(this._CaveatsAndRecommendationsMask == null ? CaveatsAndRecommendations.createMask() : this._CaveatsAndRecommendationsMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_CaveatsAndRecommendations, this._CaveatsAndRecommendationsMask.getDataMap());
            return this;
        }

        public ProjectionMask withInstitutionalMemory(Function<InstitutionalMemory.ProjectionMask, InstitutionalMemory.ProjectionMask> nestedMask) {
            this._InstitutionalMemoryMask = nestedMask.apply(this._InstitutionalMemoryMask == null ? InstitutionalMemory.createMask() : this._InstitutionalMemoryMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_InstitutionalMemory, this._InstitutionalMemoryMask.getDataMap());
            return this;
        }

        public ProjectionMask withSourceCode(Function<SourceCode.ProjectionMask, SourceCode.ProjectionMask> nestedMask) {
            this._SourceCodeMask = nestedMask.apply(this._SourceCodeMask == null ? SourceCode.createMask() : this._SourceCodeMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_SourceCode, this._SourceCodeMask.getDataMap());
            return this;
        }

        public ProjectionMask withStatus(Function<Status.ProjectionMask, Status.ProjectionMask> nestedMask) {
            this._StatusMask = nestedMask.apply(this._StatusMask == null ? Status.createMask() : this._StatusMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_Status, this._StatusMask.getDataMap());
            return this;
        }

        public ProjectionMask withCost(Function<Cost.ProjectionMask, Cost.ProjectionMask> nestedMask) {
            this._CostMask = nestedMask.apply(this._CostMask == null ? Cost.createMask() : this._CostMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_Cost, this._CostMask.getDataMap());
            return this;
        }

        public ProjectionMask withDeprecation(Function<Deprecation.ProjectionMask, Deprecation.ProjectionMask> nestedMask) {
            this._DeprecationMask = nestedMask.apply(this._DeprecationMask == null ? Deprecation.createMask() : this._DeprecationMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_Deprecation, this._DeprecationMask.getDataMap());
            return this;
        }

        public ProjectionMask withBrowsePaths(Function<BrowsePaths.ProjectionMask, BrowsePaths.ProjectionMask> nestedMask) {
            this._BrowsePathsMask = nestedMask.apply(this._BrowsePathsMask == null ? BrowsePaths.createMask() : this._BrowsePathsMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_BrowsePaths, this._BrowsePathsMask.getDataMap());
            return this;
        }

        public ProjectionMask withGlobalTags(Function<GlobalTags.ProjectionMask, GlobalTags.ProjectionMask> nestedMask) {
            this._GlobalTagsMask = nestedMask.apply(this._GlobalTagsMask == null ? GlobalTags.createMask() : this._GlobalTagsMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_GlobalTags, this._GlobalTagsMask.getDataMap());
            return this;
        }

        public ProjectionMask withDataPlatformInstance(Function<DataPlatformInstance.ProjectionMask, DataPlatformInstance.ProjectionMask> nestedMask) {
            this._DataPlatformInstanceMask = nestedMask.apply(this._DataPlatformInstanceMask == null ? DataPlatformInstance.createMask() : this._DataPlatformInstanceMask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_DataPlatformInstance, this._DataPlatformInstanceMask.getDataMap());
            return this;
        }

        public ProjectionMask withBrowsePathsV2(Function<BrowsePathsV2.ProjectionMask, BrowsePathsV2.ProjectionMask> nestedMask) {
            this._BrowsePathsV2Mask = nestedMask.apply(this._BrowsePathsV2Mask == null ? BrowsePathsV2.createMask() : this._BrowsePathsV2Mask);
            this.getDataMap().put(MLModelAspect.MEMBERKEY_BrowsePathsV2, this._BrowsePathsV2Mask.getDataMap());
            return this;
        }
    }

    private static final class UnionTyperefInfo
    extends TyperefInfo {
        private static final TyperefDataSchema SCHEMA = (TyperefDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a ML Model*/typeref MLModelAspect=union[{namespace com.linkedin.metadata.key/**Key for an ML model*/@Aspect.name=\"mlModelKey\"record MLModelKey{/**Standardized platform urn for the model*/platform:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Name of the MLModel*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}name:string/**Fabric type where model belongs to or where it was generated*/@Searchable={\"addToFilters\":true,\"fieldType\":\"TEXT_PARTIAL\",\"filterNameOverride\":\"Environment\",\"queryByDefault\":false}origin:{namespace com.linkedin.common/**Fabric group type*/enum FabricType{/**Designates development fabrics*/DEV/**Designates testing fabrics*/TEST/**Designates quality assurance fabrics*/QA/**Designates user acceptance testing fabrics*/UAT/**Designates early-integration fabrics*/EI/**Designates pre-production fabrics*/PRE/**Designates staging fabrics*/STG/**Designates non-production fabrics*/NON_PROD/**Designates production fabrics*/PROD/**Designates corporation fabrics*/CORP/**Designates review fabrics*/RVW/**Alternative Prod spelling*/PRD/**Alternative Test spelling*/TST/**System Integration Testing*/SIT/**Alternative spelling for sandbox*/SBX/**Designates sandbox fabrics*/SANDBOX}}}}{namespace com.linkedin.common/**Ownership information of an entity.*/@Aspect.name=\"ownership\"record Ownership{/**List of owners of the entity.*/owners:array[/**Ownership information*/record Owner{/**Owner URN, e.g. urn:li:corpuser:ldap, urn:li:corpGroup:group_name, and urn:li:multiProduct:mp_name\n(Caveat: only corpuser is currently supported in the frontend.)*/@Relationship={\"entityTypes\":[\"corpuser\",\"corpGroup\"],\"name\":\"OwnedBy\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"owners\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Owned By\",\"hasValuesFieldName\":\"hasOwners\",\"queryByDefault\":false}owner:Urn/**The type of the ownership*/@deprecated,type:/**Asset owner types*/enum OwnershipType{/**Set when ownership type is unknown or a when new one is specified as an ownership type entity for which we have no\nenum value for. This is used for backwards compatibility*/CUSTOM/**person or group who is responsible for technical aspects of the asset.*/TECHNICAL_OWNER/**A person or group who is responsible for logical, or business related, aspects of the asset.*/BUSINESS_OWNER/**A steward, expert, or delegate responsible for the asset.*/DATA_STEWARD/**No specific type associated to the owner.*/NONE/**A person or group that is in charge of developing the code\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DEVELOPER/**A person or group that is owning the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DATAOWNER/**A person or a group that overseas the operation, e.g. a DBA or SRE.\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DELEGATE/**A person, group, or service that produces/generates the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,PRODUCER/**A person, group, or service that consumes the data\nDeprecated! Use TECHNICAL_OWNER or BUSINESS_OWNER instead.*/@deprecated,CONSUMER/**A person or a group that has direct business interest\nDeprecated! Use TECHNICAL_OWNER, BUSINESS_OWNER, or STEWARD instead.*/@deprecated,STAKEHOLDER}/**The type of the ownership\nUrn of type O*/@Relationship={\"entityTypes\":[\"ownershipType\"],\"name\":\"ownershipType\"}typeUrn:optional Urn/**Source information for the ownership*/source:optional/**Source/provider of the ownership information*/record OwnershipSource{/**The type of the source*/type:enum OwnershipSourceType{/**Auditing system or audit logs*/AUDIT/**Database, e.g. GRANTS table*/DATABASE/**File system, e.g. file/directory owner*/FILE_SYSTEM/**Issue tracking system, e.g. Jira*/ISSUE_TRACKING_SYSTEM/**Manually provided by a user*/MANUAL/**Other ownership-like service, e.g. Nuage, ACL service etc*/SERVICE/**SCM system, e.g. GIT, SVN*/SOURCE_CONTROL/**Other sources*/OTHER}/**A reference URL for the source*/url:optional string}/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"ownerAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"ownerAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"ownerAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}]/**Ownership type to Owners map, populated via mutation hook.*/@Searchable.`/*`={\"fieldType\":\"MAP_ARRAY\",\"queryByDefault\":false}ownerTypes:optional map[string,array[Urn]]={}/**Audit stamp containing who last modified the record and when. A value of 0 in the time field indicates missing data.*/lastModified:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:Time/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}}}{namespace com.linkedin.ml.metadata/**Properties associated with a ML Model*/@Aspect.name=\"mlModelProperties\"record MLModelProperties includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{namespace com.linkedin.common/**A reference to an external platform.*/record ExternalReference{/**URL where the reference exist*/@Searchable.fieldType=\"KEYWORD\"externalUrl:optional@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}/**A set of re-usable fields used to capture lineage information for ML Models and ML Model Groups*/record MLModelLineageInfo{/**List of jobs or process instances (if any) used to train the model or group. Visible in Lineage. Note that ML Models can also be specified as the output of a specific Data Process Instances (runs) via the DataProcessInstanceOutputs aspect.*/@Relationship.`/*`={\"entityTypes\":[\"dataJob\",\"dataProcessInstance\"],\"isLineage\":true,\"name\":\"TrainedBy\"}trainingJobs:optional array[com.linkedin.common.Urn]/**List of jobs or process instances (if any) that use the model or group.*/@Relationship.`/*`={\"entityTypes\":[\"dataJob\",\"dataProcessInstance\"],\"isLineage\":true,\"isUpstream\":false,\"name\":\"UsedBy\"}downstreamJobs:optional array[com.linkedin.common.Urn]}{/**Display name of the MLModel*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true}name:optional string/**Documentation of the MLModel*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\"}description:optional string/**Date when the MLModel was developed*/@deprecated,date:optional com.linkedin.common.Time/**Audit stamp containing who created this and when*/created:optional{namespace com.linkedin.common/**A standard event timestamp*/record TimeStamp{/**When did the event occur*/time:Time/**Optional: The actor urn involved in the event.*/actor:optional Urn}}/**Date when the MLModel was last modified*/lastModified:optional com.linkedin.common.TimeStamp/**Version of the MLModel*/version:optional{namespace com.linkedin.common/**A resource-defined string representing the resource state for the purpose of concurrency control*/record VersionTag{versionTag:optional string,metadataAttribution:optional MetadataAttribution}}/**Type of Algorithm or MLModel such as whether it is a Naive Bayes classifier, Convolutional Neural Network, etc*/@Searchable.fieldType=\"TEXT_PARTIAL\"type:optional string/**Hyper Parameters of the MLModel\n\nNOTE: these are deprecated in favor of hyperParams*/hyperParameters:optional map[string/**A union of all supported metadata aspects for HyperParameter Value*/typeref HyperParameterValueType=union[string,int,float,double,boolean]]/**Hyperparameters of the MLModel*/hyperParams:optional array[/**Properties associated with an ML Hyper Param*/@Aspect.name=\"mlHyperParam\"record MLHyperParam{/**Name of the MLHyperParam*/name:string/**Documentation of the MLHyperParam*/description:optional string/**The value of the MLHyperParam*/value:optional string/**Date when the MLHyperParam was developed*/createdAt:optional com.linkedin.common.Time}]/**Metrics of the MLModel used in training*/trainingMetrics:optional array[/**Properties associated with an ML Metric*/@Aspect.name=\"mlMetric\"record MLMetric{/**Name of the mlMetric*/name:string/**Documentation of the mlMetric*/description:optional string/**The value of the mlMetric*/value:optional string/**Date when the mlMetric was developed*/createdAt:optional com.linkedin.common.Time}]/**Metrics of the MLModel used in production*/onlineMetrics:optional array[MLMetric]/**List of features used for MLModel training*/@Relationship.`/*`={\"entityTypes\":[\"mlFeature\"],\"isLineage\":true,\"name\":\"Consumes\"}mlFeatures:optional array[{namespace com.linkedin.common/**Standardized MLFeature identifier.*/@java.class=\"com.linkedin.common.urn.MLFeatureUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized MLFeature identifier.\",\"entityType\":\"mlFeature\",\"fields\":[{\"doc\":\"Namespace for the MLFeature\",\"name\":\"mlFeatureNamespace\",\"type\":\"string\"},{\"doc\":\"Name of the MLFeature\",\"maxLength\":210,\"name\":\"mlFeatureName\",\"type\":\"string\"}],\"maxLength\":284,\"name\":\"MLFeature\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref MLFeatureUrn=string}]/**Tags for the MLModel*/tags:array[string]=[]/**Deployments for the MLModel*/@Relationship.`/*`={\"entityTypes\":[\"mlModelDeployment\"],\"name\":\"DeployedTo\"}deployments:optional array[com.linkedin.common.Urn]/**Groups the model belongs to*/@Relationship.`/*`={\"entityTypes\":[\"mlModelGroup\"],\"isLineage\":true,\"isUpstream\":false,\"name\":\"MemberOf\"}groups:optional array[com.linkedin.common.Urn]}}{namespace com.linkedin.ml.metadata/**Intended Use for the ML Model*/@Aspect.name=\"intendedUse\"record IntendedUse{/**Primary Use cases for the MLModel.*/primaryUses:optional array[string]/**Primary Intended Users - For example, was the MLModel developed for entertainment purposes, for hobbyists, or enterprise solutions?*/primaryUsers:optional array[enum IntendedUserType{ENTERPRISE,HOBBY,ENTERTAINMENT}]/**Highlight technology that the MLModel might easily be confused with, or related contexts that users could try to apply the MLModel to.*/outOfScopeUses:optional array[string]}}{namespace com.linkedin.ml.metadata/**Prompts which affect the performance of the MLModel*/@Aspect.name=\"mlModelFactorPrompts\"record MLModelFactorPrompts{/**What are foreseeable salient factors for which MLModel performance may vary, and how were these determined?*/relevantFactors:optional array[/**Factors affecting the performance of the MLModel.*/record MLModelFactors{/**Groups refers to distinct categories with similar characteristics that are present in the evaluation data instances.\nFor human-centric machine learning MLModels, groups are people who share one or multiple characteristics.*/groups:optional array[string]/**The performance of a MLModel can vary depending on what instruments were used to capture the input to the MLModel.\nFor example, a face detection model may perform differently depending on the camera's hardware and software,\nincluding lens, image stabilization, high dynamic range techniques, and background blurring for portrait mode.*/instrumentation:optional array[string]/**A further factor affecting MLModel performance is the environment in which it is deployed.*/environment:optional array[string]}]/**Which factors are being reported, and why were these chosen?*/evaluationFactors:optional array[MLModelFactors]}}{namespace com.linkedin.ml.metadata/**Metrics to be featured for the MLModel.*/@Aspect.name=\"mlModelMetrics\"record Metrics{/**Measures of MLModel performance*/performanceMeasures:optional array[string]/**Decision Thresholds used (if any)?*/decisionThreshold:optional array[string]}}{namespace com.linkedin.ml.metadata/**All referenced datasets would ideally point to any set of documents that provide visibility into the source and composition of the dataset.*/@Aspect.name=\"mlModelEvaluationData\"record EvaluationData{/**Details on the dataset(s) used for the quantitative analyses in the MLModel*/evaluationData:array[/**BaseData record*/record BaseData{/**What dataset were used in the MLModel?*/dataset:{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}/**Why was this dataset chosen?*/motivation:optional string/**How was the data preprocessed (e.g., tokenization of sentences, cropping of images, any filtering such as dropping images without faces)?*/preProcessing:optional array[string]}]}}{namespace com.linkedin.ml.metadata/**Ideally, the MLModel card would contain as much information about the training data as the evaluation data. However, there might be cases where it is not feasible to provide this level of detailed information about the training data. For example, the data may be proprietary, or require a non-disclosure agreement. In these cases, we advocate for basic details about the distributions over groups in the data, as well as any other details that could inform stakeholders on the kinds of biases the model may have encoded.*/@Aspect.name=\"mlModelTrainingData\"record TrainingData{/**Details on the dataset(s) used for training the MLModel*/trainingData:array[BaseData]}}{namespace com.linkedin.ml.metadata/**Quantitative analyses should be disaggregated, that is, broken down by the chosen factors. Quantitative analyses should provide the results of evaluating the MLModel according to the chosen metrics, providing confidence interval values when possible.*/@Aspect.name=\"mlModelQuantitativeAnalyses\"record QuantitativeAnalyses{/**Link to a dashboard with results showing how the MLModel performed with respect to each factor*/unitaryResults:optional/**A union of all supported metadata aspects for ResultsType*/typeref ResultsType=union[string]/**Link to a dashboard with results showing how the MLModel performed with respect to the intersection of evaluated factors?*/intersectionalResults:optional ResultsType}}{namespace com.linkedin.ml.metadata/**This section is intended to demonstrate the ethical considerations that went into MLModel development, surfacing ethical challenges and solutions to stakeholders.*/@Aspect.name=\"mlModelEthicalConsiderations\"record EthicalConsiderations{/**Does the MLModel use any sensitive data (e.g., protected classes)?*/data:optional array[string]/** Is the MLModel intended to inform decisions about matters central to human life or flourishing - e.g., health or safety? Or could it be used in such a way?*/humanLife:optional array[string]/**What risk mitigation strategies were used during MLModel development?*/mitigations:optional array[string]/**What risks may be present in MLModel usage? Try to identify the potential recipients, likelihood, and magnitude of harms. If these cannot be determined, note that they were considered but remain unknown.*/risksAndHarms:optional array[string]/**Are there any known MLModel use cases that are especially fraught? This may connect directly to the intended use section*/useCases:optional array[string]}}{namespace com.linkedin.ml.metadata/**This section should list additional concerns that were not covered in the previous sections. For example, did the results suggest any further testing? Were there any relevant groups that were not represented in the evaluation dataset? Are there additional recommendations for model use?*/@Aspect.name=\"mlModelCaveatsAndRecommendations\"record CaveatsAndRecommendations{/**This section should list additional concerns that were not covered in the previous sections. For example, did the results suggest any further testing? Were there any relevant groups that were not represented in the evaluation dataset?*/caveats:optional/**This section should list additional concerns that were not covered in the previous sections. For example, did the results suggest any further testing? Were there any relevant groups that were not represented in the evaluation dataset? Are there additional recommendations for model use?*/record CaveatDetails{/**Did the results suggest any further testing?*/needsFurtherTesting:optional boolean/**Caveat Description\nFor ex: Given gender classes are binary (male/not male), which we include as male/female. Further work needed to evaluate across a spectrum of genders.*/caveatDescription:optional string/**Relevant groups that were not represented in the evaluation dataset?*/groupsNotRepresented:optional array[string]}/**Recommendations on where this MLModel should be used.*/recommendations:optional string/**Ideal characteristics of an evaluation dataset for this MLModel*/idealDatasetCharacteristics:optional array[string]}}{namespace com.linkedin.common/**Institutional memory of an entity. This is a way to link to relevant documentation and provide description of the documentation. Institutional or tribal knowledge is very important for users to leverage the entity.*/@Aspect.name=\"institutionalMemory\"record InstitutionalMemory{/**List of records that represent institutional memory of an entity. Each record consists of a link, description, creator and timestamps associated with that record.*/elements:array[/**Metadata corresponding to a record of institutional memory.*/record InstitutionalMemoryMetadata{/**Link to an engineering design document or a wiki page.*/url:Url/**Description of the link.*/description:string/**Audit stamp associated with creation of this record*/createStamp:AuditStamp/**Audit stamp associated with updation of this record*/updateStamp:optional AuditStamp}]}}{namespace com.linkedin.ml.metadata/**Source Code*/@Aspect.name=\"sourceCode\"record SourceCode{/**Source Code along with types*/sourceCode:array[/**Source Code Url Entity*/record SourceCodeUrl{/**Source Code Url Types*/type:enum SourceCodeUrlType{ML_MODEL_SOURCE_CODE,TRAINING_PIPELINE_SOURCE_CODE,EVALUATION_PIPELINE_SOURCE_CODE}/**Source Code Url*/sourceCodeUrl:com.linkedin.common.Url}]}}{namespace com.linkedin.common/**The lifecycle status metadata of an entity, e.g. dataset, metric, feature, etc.\nThis aspect is used to represent soft deletes conventionally.*/@Aspect.name=\"status\"record Status{/**Whether the entity has been removed (soft-deleted).*/@Searchable.fieldType=\"BOOLEAN\"removed:boolean=false}}{namespace com.linkedin.common@Aspect.name=\"cost\"record Cost{costType:/**Type of Cost Code*/enum CostType{/**Org Cost Type to which the Cost of this entity should be attributed to*/ORG_COST_TYPE}cost:/**A union of all supported Cost Value types*/typeref CostValue=union[costId:double,costCode:string]}}{namespace com.linkedin.common/**Deprecation status of an entity*/@Aspect.name=\"deprecation\"record Deprecation{/**Whether the entity is deprecated.*/@Searchable={\"addToFilters\":true,\"fieldType\":\"BOOLEAN\",\"filterNameOverride\":\"Deprecated\",\"weightsPerFieldValue\":{\"true\":0.5}}deprecated:boolean/**The time user plan to decommission this entity.*/decommissionTime:optional Time/**Additional information about the entity deprecation plan, such as the wiki, doc, RB.*/note:string/**The user URN which will be credited for modifying this deprecation content.*/actor:Urn,replacement:optional Urn}}{namespace com.linkedin.common/**Shared aspect containing Browse Paths to be indexed for an entity.*/@Aspect.name=\"browsePaths\"record BrowsePaths{/**A list of valid browse paths for the entity.\n\nBrowse paths are expected to be forward slash-separated strings. For example: 'prod/snowflake/datasetName'*/@Searchable.`/*`={\"fieldName\":\"browsePaths\",\"fieldType\":\"BROWSE_PATH\"}paths:array[string]}}{namespace com.linkedin.common/**Tag aspect used for applying tags to an entity*/@Aspect.name=\"globalTags\"record GlobalTags{/**Tags associated with a given entity*/@Relationship.`/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"TaggedWith\"}@Searchable.`/*/tag`={\"addToFilters\":true,\"boostScore\":0.5,\"fieldName\":\"tags\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Tag\",\"hasValuesFieldName\":\"hasTags\",\"queryByDefault\":true}tags:array[/**Properties of an applied tag. For now, just an Urn. In the future we can extend this with other properties, e.g.\npropagation parameters.*/record TagAssociation{/**Urn of the applied tag*/tag:/**Globally defined tag*/@java.class=\"com.linkedin.common.urn.TagUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Globally defined tags\",\"entityType\":\"tag\",\"fields\":[{\"doc\":\"tag name\",\"maxLength\":200,\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":220,\"name\":\"Tag\",\"namespace\":\"li\",\"owners\":[],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref TagUrn=string/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"tagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"tagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"tagAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional MetadataAttribution}]}}{namespace com.linkedin.common/**The specific instance of the data platform that this entity belongs to*/@Aspect.name=\"dataPlatformInstance\"record DataPlatformInstance{/**Data Platform*/@Searchable={\"addToFilters\":true,\"fieldType\":\"URN\",\"filterNameOverride\":\"Platform\"}platform:Urn/**Instance of the data platform (e.g. db instance)*/@Searchable={\"addToFilters\":true,\"fieldName\":\"platformInstance\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Platform Instance\"}instance:optional Urn}}{namespace com.linkedin.common/**Shared aspect containing a Browse Path to be indexed for an entity.*/@Aspect.name=\"browsePathsV2\"record BrowsePathsV2{/**A valid browse path for the entity. This field is provided by DataHub by default.\nThis aspect is a newer version of browsePaths where we can encode more information in the path.\nThis path is also based on containers for a given entity if it has containers.\n\nThis is stored in elasticsearch as unit-separator delimited strings and only includes platform specific folders or containers.\nThese paths should not include high level info captured elsewhere ie. Platform and Environment.*/@Searchable.`/*/id`={\"fieldName\":\"browsePathV2\",\"fieldType\":\"BROWSE_PATH_V2\"}path:array[/**Represents a single level in an entity's browsePathV2*/record BrowsePathEntry{/**The ID of the browse path entry. This is what gets stored in the index.\nIf there's an urn associated with this entry, id and urn will be the same*/id:string/**Optional urn pointing to some entity in DataHub*/urn:optional Urn}]}}]", SchemaFormatType.PDL);

        public UnionTyperefInfo() {
            super(SCHEMA);
        }

        public static TyperefDataSchema dataSchema() {
            return SCHEMA;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public MLModelKey.Fields MLModelKey() {
            return new MLModelKey.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_MLModelKey);
        }

        public Ownership.Fields Ownership() {
            return new Ownership.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_Ownership);
        }

        public MLModelProperties.Fields MLModelProperties() {
            return new MLModelProperties.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_MLModelProperties);
        }

        public IntendedUse.Fields IntendedUse() {
            return new IntendedUse.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_IntendedUse);
        }

        public MLModelFactorPrompts.Fields MLModelFactorPrompts() {
            return new MLModelFactorPrompts.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_MLModelFactorPrompts);
        }

        public Metrics.Fields Metrics() {
            return new Metrics.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_Metrics);
        }

        public EvaluationData.Fields EvaluationData() {
            return new EvaluationData.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_EvaluationData);
        }

        public TrainingData.Fields TrainingData() {
            return new TrainingData.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_TrainingData);
        }

        public QuantitativeAnalyses.Fields QuantitativeAnalyses() {
            return new QuantitativeAnalyses.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_QuantitativeAnalyses);
        }

        public EthicalConsiderations.Fields EthicalConsiderations() {
            return new EthicalConsiderations.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_EthicalConsiderations);
        }

        public CaveatsAndRecommendations.Fields CaveatsAndRecommendations() {
            return new CaveatsAndRecommendations.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_CaveatsAndRecommendations);
        }

        public InstitutionalMemory.Fields InstitutionalMemory() {
            return new InstitutionalMemory.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_InstitutionalMemory);
        }

        public SourceCode.Fields SourceCode() {
            return new SourceCode.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_SourceCode);
        }

        public Status.Fields Status() {
            return new Status.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_Status);
        }

        public Cost.Fields Cost() {
            return new Cost.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_Cost);
        }

        public Deprecation.Fields Deprecation() {
            return new Deprecation.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_Deprecation);
        }

        public BrowsePaths.Fields BrowsePaths() {
            return new BrowsePaths.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_BrowsePaths);
        }

        public GlobalTags.Fields GlobalTags() {
            return new GlobalTags.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_GlobalTags);
        }

        public DataPlatformInstance.Fields DataPlatformInstance() {
            return new DataPlatformInstance.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_DataPlatformInstance);
        }

        public BrowsePathsV2.Fields BrowsePathsV2() {
            return new BrowsePathsV2.Fields(this.getPathComponents(), MLModelAspect.MEMBERKEY_BrowsePathsV2);
        }
    }
}

