/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.entitystream;

import com.linkedin.entitystream.ReadHandle;
import com.linkedin.entitystream.Reader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collector;

public class CollectingReader<T, A, R>
implements Reader<T> {
    private final Collector<? super T, A, ? extends R> _collector;
    private ReadHandle _readHandle;
    private CompletableFuture<R> _completable;
    private A _intermediateResult;

    public CollectingReader(Collector<? super T, A, ? extends R> collector) {
        this._collector = collector;
    }

    @Override
    public void onInit(ReadHandle rh) {
        this._readHandle = rh;
        this._completable = new CompletableFuture();
        try {
            this._intermediateResult = this._collector.supplier().get();
        }
        catch (Throwable e) {
            this.handleException(e);
        }
        rh.request(1);
    }

    @Override
    public void onDataAvailable(T data) {
        try {
            this._collector.accumulator().accept(this._intermediateResult, data);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
        this._readHandle.request(1);
    }

    @Override
    public void onDone() {
        R result;
        try {
            result = this._collector.finisher().apply(this._intermediateResult);
        }
        catch (Throwable e) {
            this.handleException(e);
            return;
        }
        this._completable.complete(result);
    }

    @Override
    public void onError(Throwable e) {
        this._completable.completeExceptionally(e);
    }

    private void handleException(Throwable e) {
        this._readHandle.cancel();
        this._completable.completeExceptionally(e);
    }

    public CompletionStage<R> getResult() {
        return this._completable;
    }
}

