/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.dataset.UpstreamArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UpstreamLineageDelta
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataset/**Describes a delta change to a dataset upstream lineage*/record UpstreamLineageDelta{/**The list of upstream lineages to be updated for a dataset*/upstreamsToUpdate:array[/**Upstream lineage information about a dataset including the source reporting the lineage*/record Upstream{/**Audit stamp containing who reported the lineage and when.*/auditStamp:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**Audit stamp containing who created the lineage and when.*/created:optional com.linkedin.common.AuditStamp/**The upstream dataset the lineage points to*/@Relationship={\"createdActor\":\"upstreams/*/created/actor\",\"createdOn\":\"upstreams/*/created/time\",\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"DownstreamOf\",\"properties\":\"upstreams/*/properties\",\"updatedActor\":\"upstreams/*/auditStamp/actor\",\"updatedOn\":\"upstreams/*/auditStamp/time\",\"via\":\"upstreams/*/query\"}@Searchable={\"fieldName\":\"upstreams\",\"fieldType\":\"URN\",\"hasValuesFieldName\":\"hasUpstreams\",\"queryByDefault\":false}dataset:{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}/**The type of the lineage*/type:/**The various types of supported dataset lineage*/enum DatasetLineageType{/**Direct copy without modification*/COPY/**Transformed data with modification (format or content change)*/TRANSFORMED/**Represents a view defined on the sources e.g. Hive view defined on underlying hive tables or a Hive table pointing to a HDFS dataset or DALI view defined on multiple sources*/VIEW}/**A generic properties bag that allows us to store specific information on this graph edge.*/properties:optional map[string,string]/**If the lineage is generated by a query, a reference to the query*/query:optional com.linkedin.common.Urn}]}", SchemaFormatType.PDL);
    private UpstreamArray _upstreamsToUpdateField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_UpstreamsToUpdate = SCHEMA.getField("upstreamsToUpdate");

    public UpstreamLineageDelta() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public UpstreamLineageDelta(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUpstreamsToUpdate() {
        if (this._upstreamsToUpdateField != null) {
            return true;
        }
        return this._map.containsKey("upstreamsToUpdate");
    }

    public void removeUpstreamsToUpdate() {
        this._map.remove("upstreamsToUpdate");
    }

    @Nullable
    public UpstreamArray getUpstreamsToUpdate(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getUpstreamsToUpdate();
            }
            case DEFAULT: 
            case NULL: {
                if (this._upstreamsToUpdateField != null) {
                    return this._upstreamsToUpdateField;
                }
                Object __rawValue = this._map.get("upstreamsToUpdate");
                this._upstreamsToUpdateField = __rawValue == null ? null : new UpstreamArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._upstreamsToUpdateField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UpstreamArray getUpstreamsToUpdate() {
        if (this._upstreamsToUpdateField != null) {
            return this._upstreamsToUpdateField;
        }
        Object __rawValue = this._map.get("upstreamsToUpdate");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("upstreamsToUpdate");
        }
        this._upstreamsToUpdateField = __rawValue == null ? null : new UpstreamArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._upstreamsToUpdateField;
    }

    public UpstreamLineageDelta setUpstreamsToUpdate(@Nullable UpstreamArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUpstreamsToUpdate(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field upstreamsToUpdate of com.linkedin.dataset.UpstreamLineageDelta");
                }
                CheckedUtil.putWithoutChecking(this._map, "upstreamsToUpdate", value.data());
                this._upstreamsToUpdateField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUpstreamsToUpdate();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "upstreamsToUpdate", value.data());
                this._upstreamsToUpdateField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "upstreamsToUpdate", value.data());
                this._upstreamsToUpdateField = value;
            }
        }
        return this;
    }

    public UpstreamLineageDelta setUpstreamsToUpdate(@Nonnull UpstreamArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field upstreamsToUpdate of com.linkedin.dataset.UpstreamLineageDelta to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "upstreamsToUpdate", value.data());
        this._upstreamsToUpdateField = value;
        return this;
    }

    @Override
    public UpstreamLineageDelta clone() throws CloneNotSupportedException {
        UpstreamLineageDelta __clone = (UpstreamLineageDelta)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public UpstreamLineageDelta copy() throws CloneNotSupportedException {
        UpstreamLineageDelta __copy = (UpstreamLineageDelta)super.copy();
        __copy._upstreamsToUpdateField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final UpstreamLineageDelta __objectRef;

        private ChangeListener(UpstreamLineageDelta reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "upstreamsToUpdate": {
                    this.__objectRef._upstreamsToUpdateField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public UpstreamArray.Fields upstreamsToUpdate() {
            return new UpstreamArray.Fields(this.getPathComponents(), "upstreamsToUpdate");
        }

        public PathSpec upstreamsToUpdate(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "upstreamsToUpdate");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private UpstreamArray.ProjectionMask _upstreamsToUpdateMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withUpstreamsToUpdate(Function<UpstreamArray.ProjectionMask, UpstreamArray.ProjectionMask> nestedMask) {
            this._upstreamsToUpdateMask = nestedMask.apply(this._upstreamsToUpdateMask == null ? UpstreamArray.createMask() : this._upstreamsToUpdateMask);
            this.getDataMap().put("upstreamsToUpdate", this._upstreamsToUpdateMask.getDataMap());
            return this;
        }

        public ProjectionMask withUpstreamsToUpdate() {
            this._upstreamsToUpdateMask = null;
            this.getDataMap().put("upstreamsToUpdate", 1);
            return this;
        }

        public ProjectionMask withUpstreamsToUpdate(Function<UpstreamArray.ProjectionMask, UpstreamArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._upstreamsToUpdateMask = nestedMask.apply(this._upstreamsToUpdateMask == null ? UpstreamArray.createMask() : this._upstreamsToUpdateMask);
            this.getDataMap().put("upstreamsToUpdate", this._upstreamsToUpdateMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("upstreamsToUpdate").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("upstreamsToUpdate").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withUpstreamsToUpdate(Integer start, Integer count) {
            this._upstreamsToUpdateMask = null;
            this.getDataMap().put("upstreamsToUpdate", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("upstreamsToUpdate").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("upstreamsToUpdate").put("$count", count);
            }
            return this;
        }
    }
}

