/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.dataset.PartitionSummary;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PartitionsSummary
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataset/**Defines how the data is partitioned for Data Lake tables (e.g. Hive, S3, Iceberg, Delta, Hudi, etc).*/@Aspect.name=\"partitionsSummary\"record PartitionsSummary{/**The minimum partition as ordered*/minPartition:optional/**Defines how the data is partitioned*/record PartitionSummary{/**A unique id / value for the partition for which statistics were collected,\ngenerated by applying the key definition to a given row.*/partition:string/**The created time for a given partition.*/createdTime:optional long/**The last modified / touched time for a given partition.*/lastModifiedTime:optional long}/**The maximum partition as ordered*/maxPartition:optional PartitionSummary}", SchemaFormatType.PDL);
    private PartitionSummary _minPartitionField = null;
    private PartitionSummary _maxPartitionField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_MinPartition = SCHEMA.getField("minPartition");
    private static final RecordDataSchema.Field FIELD_MaxPartition = SCHEMA.getField("maxPartition");

    public PartitionsSummary() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public PartitionsSummary(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasMinPartition() {
        if (this._minPartitionField != null) {
            return true;
        }
        return this._map.containsKey("minPartition");
    }

    public void removeMinPartition() {
        this._map.remove("minPartition");
    }

    @Nullable
    public PartitionSummary getMinPartition(GetMode mode) {
        return this.getMinPartition();
    }

    @Nullable
    public PartitionSummary getMinPartition() {
        if (this._minPartitionField != null) {
            return this._minPartitionField;
        }
        Object __rawValue = this._map.get("minPartition");
        this._minPartitionField = __rawValue == null ? null : new PartitionSummary(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._minPartitionField;
    }

    public PartitionsSummary setMinPartition(@Nullable PartitionSummary value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMinPartition(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMinPartition();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "minPartition", value.data());
                this._minPartitionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "minPartition", value.data());
                this._minPartitionField = value;
            }
        }
        return this;
    }

    public PartitionsSummary setMinPartition(@Nonnull PartitionSummary value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field minPartition of com.linkedin.dataset.PartitionsSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "minPartition", value.data());
        this._minPartitionField = value;
        return this;
    }

    public boolean hasMaxPartition() {
        if (this._maxPartitionField != null) {
            return true;
        }
        return this._map.containsKey("maxPartition");
    }

    public void removeMaxPartition() {
        this._map.remove("maxPartition");
    }

    @Nullable
    public PartitionSummary getMaxPartition(GetMode mode) {
        return this.getMaxPartition();
    }

    @Nullable
    public PartitionSummary getMaxPartition() {
        if (this._maxPartitionField != null) {
            return this._maxPartitionField;
        }
        Object __rawValue = this._map.get("maxPartition");
        this._maxPartitionField = __rawValue == null ? null : new PartitionSummary(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._maxPartitionField;
    }

    public PartitionsSummary setMaxPartition(@Nullable PartitionSummary value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMaxPartition(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMaxPartition();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "maxPartition", value.data());
                this._maxPartitionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "maxPartition", value.data());
                this._maxPartitionField = value;
            }
        }
        return this;
    }

    public PartitionsSummary setMaxPartition(@Nonnull PartitionSummary value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field maxPartition of com.linkedin.dataset.PartitionsSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "maxPartition", value.data());
        this._maxPartitionField = value;
        return this;
    }

    @Override
    public PartitionsSummary clone() throws CloneNotSupportedException {
        PartitionsSummary __clone = (PartitionsSummary)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public PartitionsSummary copy() throws CloneNotSupportedException {
        PartitionsSummary __copy = (PartitionsSummary)super.copy();
        __copy._minPartitionField = null;
        __copy._maxPartitionField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final PartitionsSummary __objectRef;

        private ChangeListener(PartitionsSummary reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "minPartition": {
                    this.__objectRef._minPartitionField = null;
                    break;
                }
                case "maxPartition": {
                    this.__objectRef._maxPartitionField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PartitionSummary.Fields minPartition() {
            return new PartitionSummary.Fields(this.getPathComponents(), "minPartition");
        }

        public PartitionSummary.Fields maxPartition() {
            return new PartitionSummary.Fields(this.getPathComponents(), "maxPartition");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private PartitionSummary.ProjectionMask _minPartitionMask;
        private PartitionSummary.ProjectionMask _maxPartitionMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withMinPartition(Function<PartitionSummary.ProjectionMask, PartitionSummary.ProjectionMask> nestedMask) {
            this._minPartitionMask = nestedMask.apply(this._minPartitionMask == null ? PartitionSummary.createMask() : this._minPartitionMask);
            this.getDataMap().put("minPartition", this._minPartitionMask.getDataMap());
            return this;
        }

        public ProjectionMask withMinPartition() {
            this._minPartitionMask = null;
            this.getDataMap().put("minPartition", 1);
            return this;
        }

        public ProjectionMask withMaxPartition(Function<PartitionSummary.ProjectionMask, PartitionSummary.ProjectionMask> nestedMask) {
            this._maxPartitionMask = nestedMask.apply(this._maxPartitionMask == null ? PartitionSummary.createMask() : this._maxPartitionMask);
            this.getDataMap().put("maxPartition", this._maxPartitionMask.getDataMap());
            return this;
        }

        public ProjectionMask withMaxPartition() {
            this._maxPartitionMask = null;
            this.getDataMap().put("maxPartition", 1);
            return this;
        }
    }
}

