/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataprocess;

import com.linkedin.common.EdgeArray;
import com.linkedin.common.UrnArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataProcessInstanceOutput
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataprocess/**Information about the outputs of a Data process*/@Aspect.name=\"dataProcessInstanceOutput\"record DataProcessInstanceOutput{/**Output assets produced*/@Relationship.`/*`={\"entityTypes\":[\"dataset\",\"mlModel\"],\"name\":\"Produces\"}@Searchable.`/*`={\"addToFilters\":true,\"fieldName\":\"outputs\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numOutputs\",\"queryByDefault\":false}outputs:array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**Output assets produced by the data process instance during processing, with additional metadata.\nCounts as lineage.\nWill eventually deprecate the outputs field.*/@Relationship.`/*/destinationUrn`={\"createdActor\":\"outputEdges/*/created/actor\",\"createdOn\":\"outputEdges/*/created/time\",\"entityTypes\":[\"dataset\",\"mlModel\",\"dataProcessInstance\"],\"isLineage\":true,\"isUpstream\":false,\"name\":\"DataProcessInstanceProduces\",\"properties\":\"outputEdges/*/properties\",\"updatedActor\":\"outputEdges/*/lastModified/actor\",\"updatedOn\":\"outputEdges/*/lastModified/time\"}outputEdges:optional array[{namespace com.linkedin.common/**A common structure to represent all edges to entities when used inside aspects as collections\nThis ensures that all edges have common structure around audit-stamps and will support PATCH, time-travel automatically.\n*/record Edge{/**Urn of the source of this relationship edge.\nIf not specified, assumed to be the entity that this aspect belongs to.*/sourceUrn:optional Urn/**Urn of the destination of this relationship edge.*/destinationUrn:Urn/**Audit stamp containing who created this relationship edge and when*/created:optional/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}/**Audit stamp containing who last modified this relationship edge and when*/lastModified:optional AuditStamp/**A generic properties bag that allows us to store specific information on this graph edge.*/properties:optional map[string,string]}}]}", SchemaFormatType.PDL);
    private UrnArray _outputsField = null;
    private EdgeArray _outputEdgesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Outputs = SCHEMA.getField("outputs");
    private static final RecordDataSchema.Field FIELD_OutputEdges = SCHEMA.getField("outputEdges");

    public DataProcessInstanceOutput() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public DataProcessInstanceOutput(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasOutputs() {
        if (this._outputsField != null) {
            return true;
        }
        return this._map.containsKey("outputs");
    }

    public void removeOutputs() {
        this._map.remove("outputs");
    }

    @Nullable
    public UrnArray getOutputs(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getOutputs();
            }
            case DEFAULT: 
            case NULL: {
                if (this._outputsField != null) {
                    return this._outputsField;
                }
                Object __rawValue = this._map.get("outputs");
                this._outputsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._outputsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UrnArray getOutputs() {
        if (this._outputsField != null) {
            return this._outputsField;
        }
        Object __rawValue = this._map.get("outputs");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("outputs");
        }
        this._outputsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._outputsField;
    }

    public DataProcessInstanceOutput setOutputs(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOutputs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field outputs of com.linkedin.dataprocess.DataProcessInstanceOutput");
                }
                CheckedUtil.putWithoutChecking(this._map, "outputs", value.data());
                this._outputsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOutputs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "outputs", value.data());
                this._outputsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "outputs", value.data());
                this._outputsField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceOutput setOutputs(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field outputs of com.linkedin.dataprocess.DataProcessInstanceOutput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "outputs", value.data());
        this._outputsField = value;
        return this;
    }

    public boolean hasOutputEdges() {
        if (this._outputEdgesField != null) {
            return true;
        }
        return this._map.containsKey("outputEdges");
    }

    public void removeOutputEdges() {
        this._map.remove("outputEdges");
    }

    @Nullable
    public EdgeArray getOutputEdges(GetMode mode) {
        return this.getOutputEdges();
    }

    @Nullable
    public EdgeArray getOutputEdges() {
        if (this._outputEdgesField != null) {
            return this._outputEdgesField;
        }
        Object __rawValue = this._map.get("outputEdges");
        this._outputEdgesField = __rawValue == null ? null : new EdgeArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._outputEdgesField;
    }

    public DataProcessInstanceOutput setOutputEdges(@Nullable EdgeArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOutputEdges(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOutputEdges();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "outputEdges", value.data());
                this._outputEdgesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "outputEdges", value.data());
                this._outputEdgesField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceOutput setOutputEdges(@Nonnull EdgeArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field outputEdges of com.linkedin.dataprocess.DataProcessInstanceOutput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "outputEdges", value.data());
        this._outputEdgesField = value;
        return this;
    }

    @Override
    public DataProcessInstanceOutput clone() throws CloneNotSupportedException {
        DataProcessInstanceOutput __clone = (DataProcessInstanceOutput)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataProcessInstanceOutput copy() throws CloneNotSupportedException {
        DataProcessInstanceOutput __copy = (DataProcessInstanceOutput)super.copy();
        __copy._outputsField = null;
        __copy._outputEdgesField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataProcessInstanceOutput __objectRef;

        private ChangeListener(DataProcessInstanceOutput reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "outputs": {
                    this.__objectRef._outputsField = null;
                    break;
                }
                case "outputEdges": {
                    this.__objectRef._outputEdgesField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec outputs() {
            return new PathSpec(this.getPathComponents(), "outputs");
        }

        public PathSpec outputs(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "outputs");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public EdgeArray.Fields outputEdges() {
            return new EdgeArray.Fields(this.getPathComponents(), "outputEdges");
        }

        public PathSpec outputEdges(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "outputEdges");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private EdgeArray.ProjectionMask _outputEdgesMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withOutputs() {
            this.getDataMap().put("outputs", 1);
            return this;
        }

        public ProjectionMask withOutputs(Integer start, Integer count) {
            this.getDataMap().put("outputs", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("outputs").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("outputs").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withOutputEdges(Function<EdgeArray.ProjectionMask, EdgeArray.ProjectionMask> nestedMask) {
            this._outputEdgesMask = nestedMask.apply(this._outputEdgesMask == null ? EdgeArray.createMask() : this._outputEdgesMask);
            this.getDataMap().put("outputEdges", this._outputEdgesMask.getDataMap());
            return this;
        }

        public ProjectionMask withOutputEdges() {
            this._outputEdgesMask = null;
            this.getDataMap().put("outputEdges", 1);
            return this;
        }

        public ProjectionMask withOutputEdges(Function<EdgeArray.ProjectionMask, EdgeArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._outputEdgesMask = nestedMask.apply(this._outputEdgesMask == null ? EdgeArray.createMask() : this._outputEdgesMask);
            this.getDataMap().put("outputEdges", this._outputEdgesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("outputEdges").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("outputEdges").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withOutputEdges(Integer start, Integer count) {
            this._outputEdgesMask = null;
            this.getDataMap().put("outputEdges", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("outputEdges").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("outputEdges").put("$count", count);
            }
            return this;
        }
    }
}

