/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.compatibility;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.annotation.AnnotationCheckResolvedPropertiesVisitor;
import com.linkedin.data.schema.annotation.DataSchemaRichContextTraverser;
import com.linkedin.data.schema.annotation.SchemaAnnotationHandler;
import com.linkedin.data.schema.annotation.SchemaAnnotationProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationCompatibilityChecker {
    private static final Logger _log = LoggerFactory.getLogger(AnnotationCompatibilityChecker.class);

    public static List<SchemaAnnotationHandler.AnnotationCompatibilityResult> checkPegasusSchemaAnnotation(DataSchema prevSchema, DataSchema currSchema, List<SchemaAnnotationHandler> handlers) {
        handlers = handlers.stream().filter(h2 -> h2.implementsCheckCompatibility()).collect(Collectors.toList());
        SchemaAnnotationProcessor.SchemaAnnotationProcessResult prevSchemaResult = AnnotationCompatibilityChecker.processSchemaAnnotation(prevSchema, handlers);
        SchemaAnnotationProcessor.SchemaAnnotationProcessResult currSchemaResult = AnnotationCompatibilityChecker.processSchemaAnnotation(currSchema, handlers);
        Map<PathSpec, Pair<SchemaAnnotationHandler.CompatibilityCheckContext, Map<String, Object>>> prevResolvedPropertiesMap = AnnotationCompatibilityChecker.getNodeToResolvedProperties(prevSchemaResult);
        Map<PathSpec, Pair<SchemaAnnotationHandler.CompatibilityCheckContext, Map<String, Object>>> currResolvedPropertiesMap = AnnotationCompatibilityChecker.getNodeToResolvedProperties(currSchemaResult);
        return AnnotationCompatibilityChecker.getCompatibilityResult(prevResolvedPropertiesMap, currResolvedPropertiesMap, handlers);
    }

    private static List<SchemaAnnotationHandler.AnnotationCompatibilityResult> getCompatibilityResult(Map<PathSpec, Pair<SchemaAnnotationHandler.CompatibilityCheckContext, Map<String, Object>>> prevResolvedPropertiesMap, Map<PathSpec, Pair<SchemaAnnotationHandler.CompatibilityCheckContext, Map<String, Object>>> currResolvedPropertiesMap, List<SchemaAnnotationHandler> handlers) {
        ArrayList<SchemaAnnotationHandler.AnnotationCompatibilityResult> results = new ArrayList<SchemaAnnotationHandler.AnnotationCompatibilityResult>();
        prevResolvedPropertiesMap.forEach((pathSpec, prevCheckContextAndResolvedProperty) -> {
            Map prevResolvedProperties = (Map)prevCheckContextAndResolvedProperty.getValue();
            handlers.forEach(handler -> {
                String annotationNamespace = handler.getAnnotationNamespace();
                if (currResolvedPropertiesMap.containsKey(pathSpec)) {
                    Pair currCheckContextAndResolvedProperty = (Pair)currResolvedPropertiesMap.get(pathSpec);
                    Map currResolvedProperties = (Map)currCheckContextAndResolvedProperty.getValue();
                    if (prevResolvedProperties.containsKey(annotationNamespace) || currResolvedProperties.containsKey(annotationNamespace)) {
                        SchemaAnnotationHandler.AnnotationCompatibilityResult result = handler.checkCompatibility(prevResolvedProperties, currResolvedProperties, (SchemaAnnotationHandler.CompatibilityCheckContext)prevCheckContextAndResolvedProperty.getKey(), (SchemaAnnotationHandler.CompatibilityCheckContext)currCheckContextAndResolvedProperty.getKey());
                        results.add(result);
                    }
                } else if (prevResolvedProperties.containsKey(annotationNamespace)) {
                    SchemaAnnotationHandler.AnnotationCompatibilityResult result = handler.checkCompatibility(prevResolvedProperties, new HashMap<String, Object>(), (SchemaAnnotationHandler.CompatibilityCheckContext)prevCheckContextAndResolvedProperty.getKey(), new SchemaAnnotationHandler.CompatibilityCheckContext());
                    results.add(result);
                }
            });
            if (currResolvedPropertiesMap.containsKey(pathSpec)) {
                currResolvedPropertiesMap.remove(pathSpec);
            }
        });
        currResolvedPropertiesMap.forEach((pathSpec, currCheckContextAndResolvedProperty) -> handlers.forEach(handler -> {
            String annotationNamespace = handler.getAnnotationNamespace();
            Map currResolvedProperties = (Map)currCheckContextAndResolvedProperty.getValue();
            if (currResolvedProperties.containsKey(annotationNamespace)) {
                SchemaAnnotationHandler.AnnotationCompatibilityResult result = handler.checkCompatibility(new HashMap<String, Object>(), currResolvedProperties, new SchemaAnnotationHandler.CompatibilityCheckContext(), (SchemaAnnotationHandler.CompatibilityCheckContext)currCheckContextAndResolvedProperty.getKey());
                results.add(result);
            }
        }));
        return results;
    }

    private static Map<PathSpec, Pair<SchemaAnnotationHandler.CompatibilityCheckContext, Map<String, Object>>> getNodeToResolvedProperties(SchemaAnnotationProcessor.SchemaAnnotationProcessResult result) {
        AnnotationCheckResolvedPropertiesVisitor visitor = new AnnotationCheckResolvedPropertiesVisitor();
        DataSchemaRichContextTraverser traverser = new DataSchemaRichContextTraverser(visitor);
        traverser.traverse(result.getResultSchema());
        return visitor.getNodeToResolvedPropertiesMap();
    }

    private static SchemaAnnotationProcessor.SchemaAnnotationProcessResult processSchemaAnnotation(DataSchema dataSchema, List<SchemaAnnotationHandler> handlers) {
        SchemaAnnotationProcessor.SchemaAnnotationProcessResult result = SchemaAnnotationProcessor.process(handlers, dataSchema, new SchemaAnnotationProcessor.AnnotationProcessOption(), false);
        if (result.hasError()) {
            String schemaName = ((NamedDataSchema)dataSchema).getFullName();
            _log.error("Annotation processing for data schema [{}] failed, detailed error: \n", (Object)schemaName);
            _log.error(result.getErrorMsgs());
            throw new RuntimeException("Could not process annotation of data schema: " + schemaName + " while processing annotation compatibility check.");
        }
        return result;
    }
}

