/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.annotation;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.annotation.IdentitySchemaVisitor;
import com.linkedin.data.schema.annotation.SchemaAnnotationHandler;
import com.linkedin.data.schema.annotation.SchemaVisitor;
import com.linkedin.data.schema.compatibility.CompatibilityMessage;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class ExtensionSchemaAnnotationHandler
implements SchemaAnnotationHandler {
    public static final String EXTENSION_ANNOTATION_NAMESPACE = "extension";

    @Override
    public SchemaAnnotationHandler.ResolutionResult resolve(List<Pair<String, Object>> propertiesOverrides, SchemaAnnotationHandler.ResolutionMetaData resolutionMetadata) {
        return new SchemaAnnotationHandler.ResolutionResult();
    }

    @Override
    public String getAnnotationNamespace() {
        return EXTENSION_ANNOTATION_NAMESPACE;
    }

    @Override
    public SchemaAnnotationHandler.AnnotationValidationResult validate(Map<String, Object> resolvedProperties, SchemaAnnotationHandler.ValidationMetaData metaData) {
        return new SchemaAnnotationHandler.AnnotationValidationResult();
    }

    @Override
    public SchemaVisitor getVisitor() {
        return new IdentitySchemaVisitor();
    }

    @Override
    public boolean implementsCheckCompatibility() {
        return true;
    }

    @Override
    public SchemaAnnotationHandler.AnnotationCompatibilityResult checkCompatibility(Map<String, Object> prevResolvedProperties, Map<String, Object> currResolvedProperties, SchemaAnnotationHandler.CompatibilityCheckContext prevContext, SchemaAnnotationHandler.CompatibilityCheckContext currContext) {
        SchemaAnnotationHandler.AnnotationCompatibilityResult result = new SchemaAnnotationHandler.AnnotationCompatibilityResult();
        if (prevResolvedProperties.containsKey(EXTENSION_ANNOTATION_NAMESPACE) && currResolvedProperties.containsKey(EXTENSION_ANNOTATION_NAMESPACE)) {
            DataMap prevAnnotations = (DataMap)prevResolvedProperties.get(EXTENSION_ANNOTATION_NAMESPACE);
            DataMap currAnnotations = (DataMap)currResolvedProperties.get(EXTENSION_ANNOTATION_NAMESPACE);
            prevAnnotations.forEach((key, value) -> {
                if (currAnnotations.containsKey(key)) {
                    if (!prevAnnotations.get(key).equals(currAnnotations.get(key))) {
                        this.appendCompatibilityMessage(result, CompatibilityMessage.Impact.ANNOTATION_INCOMPATIBLE_CHANGE, "Updating extension annotation field: \"%s\" value is considering as a backward incompatible change.", (String)key, currContext.getPathSpecToSchema());
                    }
                    currAnnotations.remove(key);
                } else {
                    this.appendCompatibilityMessage(result, CompatibilityMessage.Impact.ANNOTATION_INCOMPATIBLE_CHANGE, "Removing extension annotation field: \"%s\" is considering as a backward incompatible change.", (String)key, currContext.getPathSpecToSchema());
                }
            });
            currAnnotations.forEach((key, value) -> this.appendCompatibilityMessage(result, CompatibilityMessage.Impact.ANNOTATION_INCOMPATIBLE_CHANGE, "Adding extension annotation field: \"%s\" is a backward incompatible change.", (String)key, currContext.getPathSpecToSchema()));
        } else if (prevResolvedProperties.containsKey(EXTENSION_ANNOTATION_NAMESPACE)) {
            if (currContext.getPathSpecToSchema() != null) {
                this.appendCompatibilityMessage(result, CompatibilityMessage.Impact.ANNOTATION_INCOMPATIBLE_CHANGE, "Removing extension annotation is a backward incompatible change.", null, prevContext.getPathSpecToSchema());
            } else {
                this.appendCompatibilityMessage(result, CompatibilityMessage.Impact.ANNOTATION_INCOMPATIBLE_CHANGE, "Removing field: \"%s\" with extension annotation is a backward incompatible change.", prevContext.getSchemaField().getName(), prevContext.getPathSpecToSchema());
            }
        } else if (prevContext.getPathSpecToSchema() != null) {
            this.appendCompatibilityMessage(result, CompatibilityMessage.Impact.ANNOTATION_INCOMPATIBLE_CHANGE, "Adding extension annotation on an existing field: \"%s\" is backward incompatible change", prevContext.getSchemaField().getName(), currContext.getPathSpecToSchema());
        } else {
            this.appendCompatibilityMessage(result, CompatibilityMessage.Impact.ANNOTATION_COMPATIBLE_CHANGE, "Adding extension annotation on new field: \"%s\" is backward compatible change", currContext.getSchemaField().getName(), currContext.getPathSpecToSchema());
        }
        return result;
    }

    private void appendCompatibilityMessage(SchemaAnnotationHandler.AnnotationCompatibilityResult result, CompatibilityMessage.Impact impact, String message, String context, PathSpec pathSpec) {
        CompatibilityMessage compatibilityMessage = new CompatibilityMessage(pathSpec, impact, message, context);
        result.addMessage(compatibilityMessage);
    }
}

