/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.JacksonDataTemplateCodec;
import datahub.shaded.jackson.core.JsonFactory;
import datahub.shaded.jackson.core.JsonGenerator;
import datahub.shaded.jackson.core.PrettyPrinter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JsonBuilder
implements AutoCloseable {
    private final Writer _writer;
    private final JsonGenerator _jsonGenerator;
    private static final JsonFactory _jsonFactory = new JsonFactory();
    private static final JacksonDataCodec _jacksonDataCodec = new JacksonDataCodec(_jsonFactory);
    private static final JacksonDataTemplateCodec _jacksonDataTemplateCodec = new JacksonDataTemplateCodec(_jsonFactory);
    private static final PrettyPrinter _spacesPrettyPrinter = new SpacesPrettyPrinter();

    public JsonBuilder(Pretty pretty) throws IOException {
        this(pretty, new StringWriter());
    }

    public JsonBuilder(Pretty pretty, Writer writer) throws IOException {
        this._writer = writer;
        this._jsonGenerator = _jsonFactory.createGenerator(this._writer);
        switch (pretty) {
            case SPACES: {
                this._jsonGenerator.setPrettyPrinter(_spacesPrettyPrinter);
                break;
            }
            case INDENTED: {
                this._jsonGenerator.useDefaultPrettyPrinter();
                break;
            }
        }
    }

    public String result() throws IOException {
        this._jsonGenerator.flush();
        if (this._writer instanceof StringWriter) {
            return this._writer.toString();
        }
        throw new IOException("Cannot get string result from non string writer: " + this._writer.getClass());
    }

    public void flush() throws IOException {
        this._jsonGenerator.flush();
    }

    @Override
    public void close() throws IOException {
        this._jsonGenerator.close();
        this._writer.close();
    }

    public void closeQuietly() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeBoolean(boolean value) throws IOException {
        this._jsonGenerator.writeBoolean(value);
    }

    public void writeString(String value) throws IOException {
        this._jsonGenerator.writeString(value);
    }

    public void writeStartObject() throws IOException {
        this._jsonGenerator.writeStartObject();
    }

    public void writeEndObject() throws IOException {
        this._jsonGenerator.writeEndObject();
    }

    public void writeFieldName(String fieldName) throws IOException {
        this._jsonGenerator.writeFieldName(fieldName);
    }

    public void writeStartArray() throws IOException {
        this._jsonGenerator.writeStartArray();
    }

    public void writeEndArray() throws IOException {
        this._jsonGenerator.writeEndArray();
    }

    public void writeStringArray(List<String> value) throws IOException {
        this.writeStartArray();
        for (String s2 : value) {
            this.writeString(s2);
        }
        this.writeEndArray();
    }

    public void writeMap(Map<String, ?> value) throws IOException {
        this.writeStartObject();
        this.writeProperties(value);
        this.writeEndObject();
    }

    public void writeBooleanField(String fieldName, boolean value) throws IOException {
        this._jsonGenerator.writeBooleanField(fieldName, value);
    }

    public void writeIntField(String fieldName, int value) throws IOException {
        this._jsonGenerator.writeNumberField(fieldName, value);
    }

    public void writeStringField(String fieldName, String value, boolean required) throws IOException {
        if (required || !value.isEmpty()) {
            this._jsonGenerator.writeStringField(fieldName, value);
        }
    }

    public void writeStringArrayField(String fieldName, List<String> value, boolean required) throws IOException {
        if (required || !value.isEmpty()) {
            this.writeFieldName(fieldName);
            this.writeStringArray(value);
        }
    }

    public void writeMapField(String fieldName, Map<String, ?> value, boolean required) throws IOException {
        if (required || !value.isEmpty()) {
            this.writeFieldName(fieldName);
            this.writeMap(value);
        }
    }

    public void writeData(Object object) throws IOException {
        _jacksonDataCodec.objectToJsonGenerator(object, this._jsonGenerator);
    }

    public void writeDataWithMapEntriesSorted(Object object) throws IOException {
        _jacksonDataCodec.objectToJsonGenerator(object, this._jsonGenerator, true);
    }

    public void writeProperties(Map<String, ?> value) throws IOException {
        if (!value.isEmpty()) {
            List orderedProperties = value.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
            for (Map.Entry entry : orderedProperties) {
                this._jsonGenerator.writeFieldName((String)entry.getKey());
                this.writeDataWithMapEntriesSorted(entry.getValue());
            }
        }
    }

    public void writeDataTemplate(DataTemplate<?> template, Boolean order) throws IOException {
        _jacksonDataTemplateCodec.dataTemplateToJsonGenerator(template, this._jsonGenerator, order);
    }

    private static class SpacesPrettyPrinter
    implements PrettyPrinter {
        private SpacesPrettyPrinter() {
        }

        @Override
        public void beforeArrayValues(JsonGenerator generator) throws IOException {
        }

        @Override
        public void beforeObjectEntries(JsonGenerator generator) throws IOException {
        }

        @Override
        public void writeArrayValueSeparator(JsonGenerator generator) throws IOException {
            generator.writeRaw(", ");
        }

        @Override
        public void writeEndArray(JsonGenerator generator, int arg1) throws IOException {
            generator.writeRaw(" ]");
        }

        @Override
        public void writeEndObject(JsonGenerator generator, int arg1) throws IOException {
            generator.writeRaw(" }");
        }

        @Override
        public void writeObjectEntrySeparator(JsonGenerator generator) throws IOException {
            generator.writeRaw(", ");
        }

        @Override
        public void writeObjectFieldValueSeparator(JsonGenerator generator) throws IOException {
            generator.writeRaw(" : ");
        }

        @Override
        public void writeRootValueSeparator(JsonGenerator generator) throws IOException {
        }

        @Override
        public void writeStartArray(JsonGenerator generator) throws IOException {
            generator.writeRaw("[ ");
        }

        @Override
        public void writeStartObject(JsonGenerator generator) throws IOException {
            generator.writeRaw("{ ");
        }
    }

    public static enum Pretty {
        COMPACT,
        SPACES,
        INDENTED;

    }
}

