/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.PdlBuilder;
import com.linkedin.data.template.JacksonDataTemplateCodec;
import datahub.shaded.jackson.core.PrettyPrinter;
import datahub.shaded.jackson.core.util.DefaultIndenter;
import datahub.shaded.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;

class IndentedPdlBuilder
extends PdlBuilder {
    private static final int DEFAULT_INDENT_WIDTH = 2;
    private int _indentDepth = 0;

    private IndentedPdlBuilder(Writer writer) {
        super(writer);
    }

    @Override
    PdlBuilder newline() throws IOException {
        this.write(System.lineSeparator());
        return this;
    }

    @Override
    PdlBuilder indent() throws IOException {
        this.write(this.getIndentSpaces(this._indentDepth));
        return this;
    }

    @Override
    PdlBuilder increaseIndent() {
        ++this._indentDepth;
        return this;
    }

    @Override
    PdlBuilder decreaseIndent() {
        --this._indentDepth;
        return this;
    }

    @Override
    boolean writeDoc(String doc) throws IOException {
        if (StringUtils.isNotBlank(doc)) {
            this.writeLine("/**");
            for (String line : doc.split("\n")) {
                String commentPrefix = StringUtils.isNotBlank(line) ? " * " : " *";
                this.indent().write(commentPrefix).write(line).newline();
            }
            this.writeLine(" */");
            return true;
        }
        return false;
    }

    @Override
    PdlBuilder writeJson(Object value, DataSchema schema) throws IOException {
        if (schema != null) {
            JacksonDataTemplateCodec jsonCodec = new JacksonDataTemplateCodec();
            jsonCodec.setPrettyPrinter(this.getPrettyPrinter());
            this.write(this.toJson(value, jsonCodec, schema));
        } else {
            JacksonDataCodec jsonCodec = new JacksonDataCodec();
            jsonCodec.setPrettyPrinter(this.getPrettyPrinter());
            jsonCodec.setSortKeys(true);
            this.write(this.toJson(value, jsonCodec));
        }
        return this;
    }

    private PrettyPrinter getPrettyPrinter() {
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
        prettyPrinter.indentObjectsWith(new DefaultIndenter(this.getIndentSpaces(1), DefaultIndenter.SYS_LF + this.getIndentSpaces(this._indentDepth)));
        return prettyPrinter;
    }

    private void writeLine(String code) throws IOException {
        this.indent().write(code).newline();
    }

    private String getIndentSpaces(int indentDepth) {
        int numSpaces = indentDepth * 2;
        StringBuilder sb = new StringBuilder(numSpaces);
        for (int i = 0; i < numSpaces; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    static class Provider
    implements PdlBuilder.Provider {
        Provider() {
        }

        @Override
        public PdlBuilder newInstance(Writer writer) {
            return new IndentedPdlBuilder(writer);
        }
    }
}

