/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.urn;

import com.linkedin.common.urn.TupleKey;
import com.linkedin.common.urn.UrnCoercer;
import com.linkedin.data.template.Custom;
import com.linkedin.util.ArgumentUtil;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class Urn {
    @Deprecated
    public static final String URN_PREFIX = "urn:li:";
    private static final String URN_START = "urn:";
    private static final String DEFAULT_NAMESPACE = "li";
    private final String _entityType;
    private final TupleKey _entityKey;
    private final String _namespace;
    @Nullable
    private String _cachedStringUrn;
    private static final Map<String, String> ENTITY_TYPE_INTERNER;

    public Urn(String rawUrn) throws URISyntaxException {
        ArgumentUtil.notNull(rawUrn, "rawUrn");
        this._cachedStringUrn = rawUrn;
        if (!rawUrn.startsWith(URN_START)) {
            throw new URISyntaxException(rawUrn, "Urn doesn't start with 'urn:'. Urn: " + rawUrn, 0);
        }
        int secondColonIndex = rawUrn.indexOf(58, URN_START.length() + 1);
        this._namespace = Urn.validateAndExtractNamespace(rawUrn, secondColonIndex);
        if (!Urn.charIsLowerCaseAlphabet(rawUrn, secondColonIndex + 1)) {
            throw new URISyntaxException(rawUrn, "First char of entityType must be [a-z]! Urn: " + rawUrn, secondColonIndex + 1);
        }
        int thirdColonIndex = rawUrn.indexOf(58, secondColonIndex + 2);
        if (thirdColonIndex == -1) {
            this._entityType = rawUrn.substring(secondColonIndex + 1);
            if (!Urn.charsAreWordClass(this._entityType)) {
                throw new URISyntaxException(rawUrn, "entityType must have only [a-zA-Z0-9] chars. Urn: " + rawUrn);
            }
            this._entityKey = new TupleKey(new String[0]);
            return;
        }
        String entityType = rawUrn.substring(secondColonIndex + 1, thirdColonIndex);
        if (!Urn.charsAreWordClass(entityType)) {
            throw new URISyntaxException(rawUrn, "entityType must have only [a-zA-Z_0-9] chars. Urn: " + rawUrn);
        }
        int numEntityKeyChars = rawUrn.length() - (thirdColonIndex + 1);
        if (numEntityKeyChars <= 0) {
            throw new URISyntaxException(rawUrn, "Urns with empty entityKey are not allowed. Urn: " + rawUrn);
        }
        this._entityType = Urn.internEntityType(entityType);
        this._entityKey = TupleKey.fromString(rawUrn, thirdColonIndex + 1);
        if (this._entityKey.size() == 1 && rawUrn.charAt(thirdColonIndex + 1) == '(') {
            this._cachedStringUrn = null;
        }
    }

    public Urn(String entityType, String typeSpecificString) throws URISyntaxException {
        this(DEFAULT_NAMESPACE, entityType, TupleKey.fromString(typeSpecificString));
    }

    public Urn(String entityType, TupleKey entityKey) {
        this(DEFAULT_NAMESPACE, entityType, entityKey);
    }

    public Urn(String namespace, String entityType, TupleKey entityKey) {
        this._namespace = namespace;
        this._entityType = entityType;
        this._entityKey = entityKey;
        this._cachedStringUrn = null;
    }

    @Deprecated
    public static Urn create(String entityType, Object ... tupleParts) {
        return new Urn(entityType, TupleKey.create(tupleParts));
    }

    @Deprecated
    public static Urn create(String entityType, Collection<?> tupleParts) {
        return new Urn(entityType, TupleKey.create(tupleParts));
    }

    public static Urn createFromTuple(String entityType, Object ... tupleParts) {
        return new Urn(entityType, TupleKey.create(tupleParts));
    }

    public static Urn createFromTupleWithNamespace(String namespace, String entityType, Object ... tupleParts) {
        return new Urn(namespace, entityType, TupleKey.create(tupleParts));
    }

    public static Urn createFromTuple(String entityType, Collection<?> tupleParts) {
        return new Urn(entityType, TupleKey.create(tupleParts));
    }

    public static Urn createFromString(String rawUrn) throws URISyntaxException {
        return new Urn(rawUrn);
    }

    public static Urn createFromCharSequence(CharSequence rawUrn) throws URISyntaxException {
        ArgumentUtil.notNull(rawUrn, "rawUrn");
        return new Urn(rawUrn.toString());
    }

    public static Urn createFromTypeSpecificString(String entityType, String typeSpecificString) throws URISyntaxException {
        return new Urn(entityType, typeSpecificString);
    }

    public String getEntityType() {
        return this._entityType;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public TupleKey getEntityKey() {
        return this._entityKey;
    }

    public String getId() {
        return this._entityKey.getAs(0, String.class);
    }

    public Integer getIdAsInt() {
        return this._entityKey.getAs(0, Integer.class);
    }

    public Long getIdAsLong() {
        return this._entityKey.getAs(0, Long.class);
    }

    public Urn getIdAsUrn() {
        return this._entityKey.getAs(0, Urn.class);
    }

    public String getNSS() {
        return this._entityType + (this._entityKey.size() > 0 ? ':' + this._entityKey.toString() : "");
    }

    public String toString() {
        if (this._cachedStringUrn != null) {
            return this._cachedStringUrn;
        }
        this._cachedStringUrn = URN_START + this._namespace + ':' + this.getNSS();
        return this._cachedStringUrn;
    }

    public boolean equals(Object obj) {
        if (obj == null || !Urn.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        Urn other = (Urn)obj;
        return this._entityType.equals(other._entityType) && this._entityKey.equals(other._entityKey) && this._namespace.equals(other._namespace);
    }

    public int hashCode() {
        int prime = 31;
        int result = this._entityType.hashCode();
        result = 31 * result + this._entityKey.hashCode();
        return result;
    }

    private static String validateAndExtractNamespace(String rawUrn, int secondColonIndex) throws URISyntaxException {
        if (!Urn.charIsLowerCaseAlphabet(rawUrn, URN_START.length())) {
            throw new URISyntaxException(rawUrn, "First char of Urn namespace must be [a-z]! Urn: " + rawUrn, URN_START.length());
        }
        if (secondColonIndex == -1) {
            throw new URISyntaxException(rawUrn, "Missing second ':' char. Urn: " + rawUrn);
        }
        int namespaceLen = secondColonIndex - URN_START.length();
        if (namespaceLen > 32) {
            throw new URISyntaxException(rawUrn, "Namespace length > 32 chars. Urn: " + rawUrn, secondColonIndex);
        }
        if (namespaceLen == 2 && rawUrn.charAt(URN_START.length()) == 'l' && rawUrn.charAt(URN_START.length() + 1) == 'i') {
            return DEFAULT_NAMESPACE;
        }
        String namespace = rawUrn.substring(URN_START.length(), secondColonIndex);
        if (!Urn.charsAreValidNamespace(namespace)) {
            throw new URISyntaxException(rawUrn, "Chars in namespace must be [a-z0-9-]!. Urn: " + rawUrn);
        }
        return namespace;
    }

    private static boolean charIsLowerCaseAlphabet(String input, int index) {
        if (index >= input.length()) {
            return false;
        }
        char c = input.charAt(index);
        return c >= 'a' && c <= 'z';
    }

    private static boolean charsAreValidNamespace(String input) {
        for (int index = 0; index < input.length(); ++index) {
            char c = input.charAt(index);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-') continue;
            return false;
        }
        return true;
    }

    private static boolean charsAreWordClass(String input) {
        for (int index = 0; index < input.length(); ++index) {
            char c = input.charAt(index);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') continue;
            return false;
        }
        return true;
    }

    private static String internEntityType(String et) {
        String canonicalET = ENTITY_TYPE_INTERNER.get(et);
        if (canonicalET != null) {
            return canonicalET;
        }
        canonicalET = ENTITY_TYPE_INTERNER.putIfAbsent(et, et);
        return canonicalET != null ? canonicalET : et;
    }

    static {
        Custom.registerCoercer(new UrnCoercer(), Urn.class);
        ENTITY_TYPE_INTERNER = new ConcurrentHashMap<String, String>();
    }
}

