/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.urn;

import com.linkedin.common.urn.TupleKey;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DirectCoercer;
import com.linkedin.data.template.TemplateOutputCastException;
import java.net.URISyntaxException;

public class ERModelRelationshipUrn
extends Urn {
    public static final String ENTITY_TYPE = "erModelRelationship";
    private final String _ermodelrelationId;

    public ERModelRelationshipUrn(String ermodelrelationId) {
        super(ENTITY_TYPE, TupleKey.create(ermodelrelationId));
        this._ermodelrelationId = ermodelrelationId;
    }

    public String getERModelRelationIdEntity() {
        return this._ermodelrelationId;
    }

    public static ERModelRelationshipUrn createFromString(String rawUrn) throws URISyntaxException {
        return ERModelRelationshipUrn.createFromUrn(Urn.createFromString(rawUrn));
    }

    public static ERModelRelationshipUrn createFromUrn(Urn urn) throws URISyntaxException {
        if (!"li".equals(urn.getNamespace())) {
            throw new URISyntaxException(urn.toString(), "Urn namespace type should be 'li'.");
        }
        if (!ENTITY_TYPE.equals(urn.getEntityType())) {
            throw new URISyntaxException(urn.toString(), "Urn entity type should be 'erModelRelationship'.");
        }
        TupleKey key = urn.getEntityKey();
        if (key.size() != 1) {
            throw new URISyntaxException(urn.toString(), "Invalid number of keys.");
        }
        try {
            return new ERModelRelationshipUrn(key.getAs(0, String.class));
        }
        catch (Exception var3) {
            throw new URISyntaxException(urn.toString(), "Invalid URN Parameter: '" + var3.getMessage());
        }
    }

    public static ERModelRelationshipUrn deserialize(String rawUrn) throws URISyntaxException {
        return ERModelRelationshipUrn.createFromString(rawUrn);
    }

    static {
        Custom.initializeCustomClass(ERModelRelationshipUrn.class);
        Custom.registerCoercer(new DirectCoercer<ERModelRelationshipUrn>(){

            @Override
            public Object coerceInput(ERModelRelationshipUrn object) throws ClassCastException {
                return object.toString();
            }

            @Override
            public ERModelRelationshipUrn coerceOutput(Object object) throws TemplateOutputCastException {
                try {
                    return ERModelRelationshipUrn.createFromString((String)object);
                }
                catch (URISyntaxException e) {
                    throw new TemplateOutputCastException("Invalid URN syntax: " + e.getMessage(), e);
                }
            }
        }, ERModelRelationshipUrn.class);
    }
}

