/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.urn;

import com.linkedin.common.urn.DataFlowUrn;
import com.linkedin.common.urn.TupleKey;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DirectCoercer;
import com.linkedin.data.template.TemplateOutputCastException;
import java.net.URISyntaxException;

public final class DataJobUrn
extends Urn {
    public static final String ENTITY_TYPE = "dataJob";
    private final DataFlowUrn _flow;
    private final String _jobId;

    public DataJobUrn(DataFlowUrn flow, String jobId) {
        super(ENTITY_TYPE, TupleKey.create(flow, jobId));
        this._flow = flow;
        this._jobId = jobId;
    }

    public DataFlowUrn getFlowEntity() {
        return this._flow;
    }

    public String getJobIdEntity() {
        return this._jobId;
    }

    public static DataJobUrn createFromString(String rawUrn) throws URISyntaxException {
        return DataJobUrn.createFromUrn(Urn.createFromString(rawUrn));
    }

    public static DataJobUrn createFromUrn(Urn urn) throws URISyntaxException {
        if (!"li".equals(urn.getNamespace())) {
            throw new URISyntaxException(urn.toString(), "Urn namespace type should be 'li'.");
        }
        if (!ENTITY_TYPE.equals(urn.getEntityType())) {
            throw new URISyntaxException(urn.toString(), "Urn entity type should be 'dataJob'.");
        }
        TupleKey key = urn.getEntityKey();
        if (key.size() != 2) {
            throw new URISyntaxException(urn.toString(), "Invalid number of keys.");
        }
        try {
            return new DataJobUrn(key.getAs(0, DataFlowUrn.class), key.getAs(1, String.class));
        }
        catch (Exception e) {
            throw new URISyntaxException(urn.toString(), "Invalid URN Parameter: '" + e.getMessage());
        }
    }

    public static DataJobUrn deserialize(String rawUrn) throws URISyntaxException {
        return DataJobUrn.createFromString(rawUrn);
    }

    static {
        Custom.initializeCustomClass(DataFlowUrn.class);
        Custom.registerCoercer(new DirectCoercer<DataJobUrn>(){

            @Override
            public Object coerceInput(DataJobUrn object) throws ClassCastException {
                return object.toString();
            }

            @Override
            public DataJobUrn coerceOutput(Object object) throws TemplateOutputCastException {
                try {
                    return DataJobUrn.createFromString((String)object);
                }
                catch (URISyntaxException e) {
                    throw new TemplateOutputCastException("Invalid URN syntax: " + e.getMessage(), e);
                }
            }
        }, DataJobUrn.class);
    }
}

