/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.urn;

import com.linkedin.common.urn.TupleKey;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DirectCoercer;
import com.linkedin.data.template.TemplateOutputCastException;
import java.net.URISyntaxException;

public final class AzkabanFlowUrn
extends Urn {
    public static final String ENTITY_TYPE = "azkabanFlow";
    private final String _cluster;
    private final String _project;
    private final String _flowId;

    public AzkabanFlowUrn(String cluster, String project, String flowId) {
        super(ENTITY_TYPE, TupleKey.create(cluster, project, flowId));
        this._cluster = cluster;
        this._project = project;
        this._flowId = flowId;
    }

    public String getClusterEntity() {
        return this._cluster;
    }

    public String getProjectEntity() {
        return this._project;
    }

    public String getFlowIdEntity() {
        return this._flowId;
    }

    public static AzkabanFlowUrn createFromString(String rawUrn) throws URISyntaxException {
        return AzkabanFlowUrn.createFromUrn(Urn.createFromString(rawUrn));
    }

    public static AzkabanFlowUrn createFromUrn(Urn urn) throws URISyntaxException {
        if (!"li".equals(urn.getNamespace())) {
            throw new URISyntaxException(urn.toString(), "Urn namespace type should be 'li'.");
        }
        if (!ENTITY_TYPE.equals(urn.getEntityType())) {
            throw new URISyntaxException(urn.toString(), "Urn entity type should be 'azkabanFlow'.");
        }
        TupleKey key = urn.getEntityKey();
        if (key.size() != 3) {
            throw new URISyntaxException(urn.toString(), "Invalid number of keys.");
        }
        try {
            return new AzkabanFlowUrn(key.getAs(0, String.class), key.getAs(1, String.class), key.getAs(2, String.class));
        }
        catch (Exception e) {
            throw new URISyntaxException(urn.toString(), "Invalid URN Parameter: '" + e.getMessage());
        }
    }

    public static AzkabanFlowUrn deserialize(String rawUrn) throws URISyntaxException {
        return AzkabanFlowUrn.createFromString(rawUrn);
    }

    static {
        Custom.registerCoercer(new DirectCoercer<AzkabanFlowUrn>(){

            @Override
            public Object coerceInput(AzkabanFlowUrn object) throws ClassCastException {
                return object.toString();
            }

            @Override
            public AzkabanFlowUrn coerceOutput(Object object) throws TemplateOutputCastException {
                try {
                    return AzkabanFlowUrn.createFromString((String)object);
                }
                catch (URISyntaxException e) {
                    throw new TemplateOutputCastException("Invalid URN syntax: " + e.getMessage(), e);
                }
            }
        }, AzkabanFlowUrn.class);
    }
}

