/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.FieldFormPromptAssociationArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FormPromptFieldAssociations
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Information about the field-level prompt associations on a top-level prompt association.*/record FormPromptFieldAssociations{/**A list of field-level prompt associations that are not yet complete for this form.*/completedFieldPrompts:optional array[/**Information about the status of a particular prompt for a specific schema field\non an entity.*/record FieldFormPromptAssociation{/**The field path on a schema field.*/fieldPath:string/**The last time this prompt was touched for the field on the entity (set, unset)*/lastModified:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}]/**A list of field-level prompt associations that are complete for this form.*/incompleteFieldPrompts:optional array[FieldFormPromptAssociation]}", SchemaFormatType.PDL);
    private FieldFormPromptAssociationArray _completedFieldPromptsField = null;
    private FieldFormPromptAssociationArray _incompleteFieldPromptsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CompletedFieldPrompts = SCHEMA.getField("completedFieldPrompts");
    private static final RecordDataSchema.Field FIELD_IncompleteFieldPrompts = SCHEMA.getField("incompleteFieldPrompts");

    public FormPromptFieldAssociations() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public FormPromptFieldAssociations(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCompletedFieldPrompts() {
        if (this._completedFieldPromptsField != null) {
            return true;
        }
        return this._map.containsKey("completedFieldPrompts");
    }

    public void removeCompletedFieldPrompts() {
        this._map.remove("completedFieldPrompts");
    }

    @Nullable
    public FieldFormPromptAssociationArray getCompletedFieldPrompts(GetMode mode) {
        return this.getCompletedFieldPrompts();
    }

    @Nullable
    public FieldFormPromptAssociationArray getCompletedFieldPrompts() {
        if (this._completedFieldPromptsField != null) {
            return this._completedFieldPromptsField;
        }
        Object __rawValue = this._map.get("completedFieldPrompts");
        this._completedFieldPromptsField = __rawValue == null ? null : new FieldFormPromptAssociationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._completedFieldPromptsField;
    }

    public FormPromptFieldAssociations setCompletedFieldPrompts(@Nullable FieldFormPromptAssociationArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCompletedFieldPrompts(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCompletedFieldPrompts();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "completedFieldPrompts", value.data());
                this._completedFieldPromptsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "completedFieldPrompts", value.data());
                this._completedFieldPromptsField = value;
            }
        }
        return this;
    }

    public FormPromptFieldAssociations setCompletedFieldPrompts(@Nonnull FieldFormPromptAssociationArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field completedFieldPrompts of com.linkedin.common.FormPromptFieldAssociations to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "completedFieldPrompts", value.data());
        this._completedFieldPromptsField = value;
        return this;
    }

    public boolean hasIncompleteFieldPrompts() {
        if (this._incompleteFieldPromptsField != null) {
            return true;
        }
        return this._map.containsKey("incompleteFieldPrompts");
    }

    public void removeIncompleteFieldPrompts() {
        this._map.remove("incompleteFieldPrompts");
    }

    @Nullable
    public FieldFormPromptAssociationArray getIncompleteFieldPrompts(GetMode mode) {
        return this.getIncompleteFieldPrompts();
    }

    @Nullable
    public FieldFormPromptAssociationArray getIncompleteFieldPrompts() {
        if (this._incompleteFieldPromptsField != null) {
            return this._incompleteFieldPromptsField;
        }
        Object __rawValue = this._map.get("incompleteFieldPrompts");
        this._incompleteFieldPromptsField = __rawValue == null ? null : new FieldFormPromptAssociationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._incompleteFieldPromptsField;
    }

    public FormPromptFieldAssociations setIncompleteFieldPrompts(@Nullable FieldFormPromptAssociationArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIncompleteFieldPrompts(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIncompleteFieldPrompts();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "incompleteFieldPrompts", value.data());
                this._incompleteFieldPromptsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "incompleteFieldPrompts", value.data());
                this._incompleteFieldPromptsField = value;
            }
        }
        return this;
    }

    public FormPromptFieldAssociations setIncompleteFieldPrompts(@Nonnull FieldFormPromptAssociationArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field incompleteFieldPrompts of com.linkedin.common.FormPromptFieldAssociations to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "incompleteFieldPrompts", value.data());
        this._incompleteFieldPromptsField = value;
        return this;
    }

    @Override
    public FormPromptFieldAssociations clone() throws CloneNotSupportedException {
        FormPromptFieldAssociations __clone = (FormPromptFieldAssociations)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public FormPromptFieldAssociations copy() throws CloneNotSupportedException {
        FormPromptFieldAssociations __copy = (FormPromptFieldAssociations)super.copy();
        __copy._completedFieldPromptsField = null;
        __copy._incompleteFieldPromptsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final FormPromptFieldAssociations __objectRef;

        private ChangeListener(FormPromptFieldAssociations reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "completedFieldPrompts": {
                    this.__objectRef._completedFieldPromptsField = null;
                    break;
                }
                case "incompleteFieldPrompts": {
                    this.__objectRef._incompleteFieldPromptsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public FieldFormPromptAssociationArray.Fields completedFieldPrompts() {
            return new FieldFormPromptAssociationArray.Fields(this.getPathComponents(), "completedFieldPrompts");
        }

        public PathSpec completedFieldPrompts(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "completedFieldPrompts");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public FieldFormPromptAssociationArray.Fields incompleteFieldPrompts() {
            return new FieldFormPromptAssociationArray.Fields(this.getPathComponents(), "incompleteFieldPrompts");
        }

        public PathSpec incompleteFieldPrompts(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "incompleteFieldPrompts");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private FieldFormPromptAssociationArray.ProjectionMask _completedFieldPromptsMask;
        private FieldFormPromptAssociationArray.ProjectionMask _incompleteFieldPromptsMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withCompletedFieldPrompts(Function<FieldFormPromptAssociationArray.ProjectionMask, FieldFormPromptAssociationArray.ProjectionMask> nestedMask) {
            this._completedFieldPromptsMask = nestedMask.apply(this._completedFieldPromptsMask == null ? FieldFormPromptAssociationArray.createMask() : this._completedFieldPromptsMask);
            this.getDataMap().put("completedFieldPrompts", this._completedFieldPromptsMask.getDataMap());
            return this;
        }

        public ProjectionMask withCompletedFieldPrompts() {
            this._completedFieldPromptsMask = null;
            this.getDataMap().put("completedFieldPrompts", 1);
            return this;
        }

        public ProjectionMask withCompletedFieldPrompts(Function<FieldFormPromptAssociationArray.ProjectionMask, FieldFormPromptAssociationArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._completedFieldPromptsMask = nestedMask.apply(this._completedFieldPromptsMask == null ? FieldFormPromptAssociationArray.createMask() : this._completedFieldPromptsMask);
            this.getDataMap().put("completedFieldPrompts", this._completedFieldPromptsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("completedFieldPrompts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("completedFieldPrompts").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withCompletedFieldPrompts(Integer start, Integer count) {
            this._completedFieldPromptsMask = null;
            this.getDataMap().put("completedFieldPrompts", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("completedFieldPrompts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("completedFieldPrompts").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withIncompleteFieldPrompts(Function<FieldFormPromptAssociationArray.ProjectionMask, FieldFormPromptAssociationArray.ProjectionMask> nestedMask) {
            this._incompleteFieldPromptsMask = nestedMask.apply(this._incompleteFieldPromptsMask == null ? FieldFormPromptAssociationArray.createMask() : this._incompleteFieldPromptsMask);
            this.getDataMap().put("incompleteFieldPrompts", this._incompleteFieldPromptsMask.getDataMap());
            return this;
        }

        public ProjectionMask withIncompleteFieldPrompts() {
            this._incompleteFieldPromptsMask = null;
            this.getDataMap().put("incompleteFieldPrompts", 1);
            return this;
        }

        public ProjectionMask withIncompleteFieldPrompts(Function<FieldFormPromptAssociationArray.ProjectionMask, FieldFormPromptAssociationArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._incompleteFieldPromptsMask = nestedMask.apply(this._incompleteFieldPromptsMask == null ? FieldFormPromptAssociationArray.createMask() : this._incompleteFieldPromptsMask);
            this.getDataMap().put("incompleteFieldPrompts", this._incompleteFieldPromptsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("incompleteFieldPrompts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("incompleteFieldPrompts").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withIncompleteFieldPrompts(Integer start, Integer count) {
            this._incompleteFieldPromptsMask = null;
            this.getDataMap().put("incompleteFieldPrompts", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("incompleteFieldPrompts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("incompleteFieldPrompts").put("$count", count);
            }
            return this;
        }
    }
}

