/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.FormPromptAssociationArray;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FormAssociation
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Properties of an applied form.*/record FormAssociation{/**Urn of the applied form*/urn:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**A list of prompts that are not yet complete for this form.*/incompletePrompts:array[/**Information about the status of a particular prompt.\nNote that this is where we can add additional information about individual responses:\nactor, timestamp, and the response itself.*/record FormPromptAssociation{/**The id for the prompt. This must be GLOBALLY UNIQUE.*/id:string/**The last time this prompt was touched for the entity (set, unset)*/lastModified:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}/**Optional information about the field-level prompt associations.*/fieldAssociations:optional/**Information about the field-level prompt associations on a top-level prompt association.*/record FormPromptFieldAssociations{/**A list of field-level prompt associations that are not yet complete for this form.*/completedFieldPrompts:optional array[/**Information about the status of a particular prompt for a specific schema field\non an entity.*/record FieldFormPromptAssociation{/**The field path on a schema field.*/fieldPath:string/**The last time this prompt was touched for the field on the entity (set, unset)*/lastModified:AuditStamp}]/**A list of field-level prompt associations that are complete for this form.*/incompleteFieldPrompts:optional array[FieldFormPromptAssociation]}}]=[]/**A list of prompts that have been completed for this form.*/completedPrompts:array[FormPromptAssociation]=[]}", SchemaFormatType.PDL);
    private Urn _urnField = null;
    private FormPromptAssociationArray _incompletePromptsField = null;
    private FormPromptAssociationArray _completedPromptsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Urn = SCHEMA.getField("urn");
    private static final RecordDataSchema.Field FIELD_IncompletePrompts = SCHEMA.getField("incompletePrompts");
    private static final FormPromptAssociationArray DEFAULT_IncompletePrompts;
    private static final RecordDataSchema.Field FIELD_CompletedPrompts;
    private static final FormPromptAssociationArray DEFAULT_CompletedPrompts;

    public FormAssociation() {
        super(new DataMap(4, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public FormAssociation(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUrn() {
        if (this._urnField != null) {
            return true;
        }
        return this._map.containsKey("urn");
    }

    public void removeUrn() {
        this._map.remove("urn");
    }

    @Nullable
    public Urn getUrn(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getUrn();
            }
            case DEFAULT: 
            case NULL: {
                if (this._urnField != null) {
                    return this._urnField;
                }
                Object __rawValue = this._map.get("urn");
                this._urnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._urnField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getUrn() {
        if (this._urnField != null) {
            return this._urnField;
        }
        Object __rawValue = this._map.get("urn");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("urn");
        }
        this._urnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._urnField;
    }

    public FormAssociation setUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field urn of com.linkedin.common.FormAssociation");
                }
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._urnField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._urnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._urnField = value;
            }
        }
        return this;
    }

    public FormAssociation setUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field urn of com.linkedin.common.FormAssociation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._urnField = value;
        return this;
    }

    public boolean hasIncompletePrompts() {
        if (this._incompletePromptsField != null) {
            return true;
        }
        return this._map.containsKey("incompletePrompts");
    }

    public void removeIncompletePrompts() {
        this._map.remove("incompletePrompts");
    }

    @Nullable
    public FormPromptAssociationArray getIncompletePrompts(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getIncompletePrompts();
            }
            case NULL: {
                if (this._incompletePromptsField != null) {
                    return this._incompletePromptsField;
                }
                Object __rawValue = this._map.get("incompletePrompts");
                this._incompletePromptsField = __rawValue == null ? null : new FormPromptAssociationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._incompletePromptsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FormPromptAssociationArray getIncompletePrompts() {
        if (this._incompletePromptsField != null) {
            return this._incompletePromptsField;
        }
        Object __rawValue = this._map.get("incompletePrompts");
        if (__rawValue == null) {
            return DEFAULT_IncompletePrompts;
        }
        this._incompletePromptsField = __rawValue == null ? null : new FormPromptAssociationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._incompletePromptsField;
    }

    public FormAssociation setIncompletePrompts(@Nullable FormPromptAssociationArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIncompletePrompts(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field incompletePrompts of com.linkedin.common.FormAssociation");
                }
                CheckedUtil.putWithoutChecking(this._map, "incompletePrompts", value.data());
                this._incompletePromptsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIncompletePrompts();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "incompletePrompts", value.data());
                this._incompletePromptsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "incompletePrompts", value.data());
                this._incompletePromptsField = value;
            }
        }
        return this;
    }

    public FormAssociation setIncompletePrompts(@Nonnull FormPromptAssociationArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field incompletePrompts of com.linkedin.common.FormAssociation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "incompletePrompts", value.data());
        this._incompletePromptsField = value;
        return this;
    }

    public boolean hasCompletedPrompts() {
        if (this._completedPromptsField != null) {
            return true;
        }
        return this._map.containsKey("completedPrompts");
    }

    public void removeCompletedPrompts() {
        this._map.remove("completedPrompts");
    }

    @Nullable
    public FormPromptAssociationArray getCompletedPrompts(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCompletedPrompts();
            }
            case NULL: {
                if (this._completedPromptsField != null) {
                    return this._completedPromptsField;
                }
                Object __rawValue = this._map.get("completedPrompts");
                this._completedPromptsField = __rawValue == null ? null : new FormPromptAssociationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._completedPromptsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FormPromptAssociationArray getCompletedPrompts() {
        if (this._completedPromptsField != null) {
            return this._completedPromptsField;
        }
        Object __rawValue = this._map.get("completedPrompts");
        if (__rawValue == null) {
            return DEFAULT_CompletedPrompts;
        }
        this._completedPromptsField = __rawValue == null ? null : new FormPromptAssociationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._completedPromptsField;
    }

    public FormAssociation setCompletedPrompts(@Nullable FormPromptAssociationArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCompletedPrompts(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field completedPrompts of com.linkedin.common.FormAssociation");
                }
                CheckedUtil.putWithoutChecking(this._map, "completedPrompts", value.data());
                this._completedPromptsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCompletedPrompts();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "completedPrompts", value.data());
                this._completedPromptsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "completedPrompts", value.data());
                this._completedPromptsField = value;
            }
        }
        return this;
    }

    public FormAssociation setCompletedPrompts(@Nonnull FormPromptAssociationArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field completedPrompts of com.linkedin.common.FormAssociation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "completedPrompts", value.data());
        this._completedPromptsField = value;
        return this;
    }

    @Override
    public FormAssociation clone() throws CloneNotSupportedException {
        FormAssociation __clone = (FormAssociation)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public FormAssociation copy() throws CloneNotSupportedException {
        FormAssociation __copy = (FormAssociation)super.copy();
        __copy._urnField = null;
        __copy._completedPromptsField = null;
        __copy._incompletePromptsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_CompletedPrompts = SCHEMA.getField("completedPrompts");
        Custom.initializeCustomClass(Urn.class);
        DEFAULT_IncompletePrompts = FIELD_IncompletePrompts.getDefault() == null ? null : new FormPromptAssociationArray(DataTemplateUtil.castOrThrow(FIELD_IncompletePrompts.getDefault(), DataList.class));
        DEFAULT_CompletedPrompts = FIELD_CompletedPrompts.getDefault() == null ? null : new FormPromptAssociationArray(DataTemplateUtil.castOrThrow(FIELD_CompletedPrompts.getDefault(), DataList.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final FormAssociation __objectRef;

        private ChangeListener(FormAssociation reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "urn": {
                    this.__objectRef._urnField = null;
                    break;
                }
                case "completedPrompts": {
                    this.__objectRef._completedPromptsField = null;
                    break;
                }
                case "incompletePrompts": {
                    this.__objectRef._incompletePromptsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec urn() {
            return new PathSpec(this.getPathComponents(), "urn");
        }

        public FormPromptAssociationArray.Fields incompletePrompts() {
            return new FormPromptAssociationArray.Fields(this.getPathComponents(), "incompletePrompts");
        }

        public PathSpec incompletePrompts(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "incompletePrompts");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public FormPromptAssociationArray.Fields completedPrompts() {
            return new FormPromptAssociationArray.Fields(this.getPathComponents(), "completedPrompts");
        }

        public PathSpec completedPrompts(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "completedPrompts");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private FormPromptAssociationArray.ProjectionMask _incompletePromptsMask;
        private FormPromptAssociationArray.ProjectionMask _completedPromptsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withUrn() {
            this.getDataMap().put("urn", 1);
            return this;
        }

        public ProjectionMask withIncompletePrompts(Function<FormPromptAssociationArray.ProjectionMask, FormPromptAssociationArray.ProjectionMask> nestedMask) {
            this._incompletePromptsMask = nestedMask.apply(this._incompletePromptsMask == null ? FormPromptAssociationArray.createMask() : this._incompletePromptsMask);
            this.getDataMap().put("incompletePrompts", this._incompletePromptsMask.getDataMap());
            return this;
        }

        public ProjectionMask withIncompletePrompts() {
            this._incompletePromptsMask = null;
            this.getDataMap().put("incompletePrompts", 1);
            return this;
        }

        public ProjectionMask withIncompletePrompts(Function<FormPromptAssociationArray.ProjectionMask, FormPromptAssociationArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._incompletePromptsMask = nestedMask.apply(this._incompletePromptsMask == null ? FormPromptAssociationArray.createMask() : this._incompletePromptsMask);
            this.getDataMap().put("incompletePrompts", this._incompletePromptsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("incompletePrompts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("incompletePrompts").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withIncompletePrompts(Integer start, Integer count) {
            this._incompletePromptsMask = null;
            this.getDataMap().put("incompletePrompts", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("incompletePrompts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("incompletePrompts").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withCompletedPrompts(Function<FormPromptAssociationArray.ProjectionMask, FormPromptAssociationArray.ProjectionMask> nestedMask) {
            this._completedPromptsMask = nestedMask.apply(this._completedPromptsMask == null ? FormPromptAssociationArray.createMask() : this._completedPromptsMask);
            this.getDataMap().put("completedPrompts", this._completedPromptsMask.getDataMap());
            return this;
        }

        public ProjectionMask withCompletedPrompts() {
            this._completedPromptsMask = null;
            this.getDataMap().put("completedPrompts", 1);
            return this;
        }

        public ProjectionMask withCompletedPrompts(Function<FormPromptAssociationArray.ProjectionMask, FormPromptAssociationArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._completedPromptsMask = nestedMask.apply(this._completedPromptsMask == null ? FormPromptAssociationArray.createMask() : this._completedPromptsMask);
            this.getDataMap().put("completedPrompts", this._completedPromptsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("completedPrompts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("completedPrompts").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withCompletedPrompts(Integer start, Integer count) {
            this._completedPromptsMask = null;
            this.getDataMap().put("completedPrompts", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("completedPrompts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("completedPrompts").put("$count", count);
            }
            return this;
        }
    }
}

